/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.navigator.dnd.CommonDropAdapterDescriptor;
import org.eclipse.ui.internal.navigator.dnd.CommonDropDescriptorManager;
import org.eclipse.ui.internal.navigator.extensions.CommonDragAssistantDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorViewerDescriptor;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorDnDService;

public class NavigatorDnDService
implements INavigatorDnDService {
    private static final CommonDropAdapterAssistant[] NO_ASSISTANTS = new CommonDropAdapterAssistant[0];
    private INavigatorContentService contentService;
    private CommonDragAdapterAssistant[] dragAssistants;
    private CommonDropAdapter dropAdapter;
    private final Map dropAssistants = new HashMap();

    public NavigatorDnDService(INavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public void setDropAdaptor(CommonDropAdapter da) {
        this.dropAdapter = da;
    }

    @Override
    public synchronized CommonDragAdapterAssistant[] getCommonDragAssistants() {
        if (this.dragAssistants == null) {
            this.initializeDragAssistants();
        }
        return this.dragAssistants;
    }

    private void initializeDragAssistants() {
        int i = 0;
        Set dragDescriptors = ((NavigatorViewerDescriptor)this.contentService.getViewerDescriptor()).getDragAssistants();
        this.dragAssistants = new CommonDragAdapterAssistant[dragDescriptors.size()];
        for (CommonDragAssistantDescriptor descriptor : dragDescriptors) {
            this.dragAssistants[i++] = descriptor.createDragAssistant();
        }
    }

    @Override
    public synchronized void bindDragAssistant(CommonDragAdapterAssistant anAssistant) {
        if (this.dragAssistants == null) {
            this.initializeDragAssistants();
        }
        CommonDragAdapterAssistant[] newDragAssistants = new CommonDragAdapterAssistant[this.dragAssistants.length + 1];
        System.arraycopy(this.dragAssistants, 0, newDragAssistants, 0, this.dragAssistants.length);
        newDragAssistants[this.dragAssistants.length] = anAssistant;
        this.dragAssistants = newDragAssistants;
    }

    @Override
    public CommonDropAdapterAssistant[] findCommonDropAdapterAssistants(Object aDropTarget, TransferData aTransferType) {
        CommonDropAdapterDescriptor[] descriptors = CommonDropDescriptorManager.getInstance().findCommonDropAdapterAssistants(aDropTarget, this.contentService);
        if (descriptors.length == 0) {
            return NO_ASSISTANTS;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(aTransferType) && LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection) {
            return this.getAssistantsBySelection(descriptors, (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection());
        }
        return this.getAssistantsByTransferData(descriptors, aTransferType);
    }

    @Override
    public CommonDropAdapterAssistant[] findCommonDropAdapterAssistants(Object aDropTarget, IStructuredSelection theDragSelection) {
        CommonDropAdapterDescriptor[] descriptors = CommonDropDescriptorManager.getInstance().findCommonDropAdapterAssistants(aDropTarget, this.contentService);
        if (descriptors.length == 0) {
            return NO_ASSISTANTS;
        }
        return this.getAssistantsBySelection(descriptors, theDragSelection);
    }

    private CommonDropAdapterAssistant[] getAssistantsByTransferData(CommonDropAdapterDescriptor[] descriptors, TransferData aTransferType) {
        LinkedHashSet<CommonDropAdapterAssistant> assistants = new LinkedHashSet<CommonDropAdapterAssistant>();
        CommonDropAdapterDescriptor[] commonDropAdapterDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            CommonDropAdapterDescriptor descriptor = commonDropAdapterDescriptorArray[n2];
            CommonDropAdapterAssistant asst = this.getAssistant(descriptor);
            if (asst.isSupportedType(aTransferType)) {
                assistants.add(asst);
            }
            ++n2;
        }
        return this.sortAssistants(assistants.toArray(new CommonDropAdapterAssistant[assistants.size()]));
    }

    private CommonDropAdapterAssistant[] getAssistantsBySelection(CommonDropAdapterDescriptor[] descriptors, IStructuredSelection aSelection) {
        LinkedHashSet<CommonDropAdapterAssistant> assistants = new LinkedHashSet<CommonDropAdapterAssistant>();
        CommonDropAdapterDescriptor[] commonDropAdapterDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            CommonDropAdapterDescriptor descriptor = commonDropAdapterDescriptorArray[n2];
            if (descriptor.areDragElementsSupported(aSelection)) {
                assistants.add(this.getAssistant(descriptor));
            }
            ++n2;
        }
        return this.sortAssistants(assistants.toArray(new CommonDropAdapterAssistant[assistants.size()]));
    }

    private CommonDropAdapterAssistant[] sortAssistants(CommonDropAdapterAssistant[] array) {
        Arrays.sort(array, (a, b) -> {
            String id = "org.eclipse.ui.navigator.resources.";
            if (a.getClass().getName().startsWith(id)) {
                return -1;
            }
            if (b.getClass().getName().startsWith(id)) {
                return 1;
            }
            return a.getClass().getName().compareTo(b.getClass().getName());
        });
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonDropAdapterAssistant getAssistant(CommonDropAdapterDescriptor descriptor) {
        CommonDropAdapterAssistant asst = (CommonDropAdapterAssistant)this.dropAssistants.get(descriptor);
        if (asst != null) {
            return asst;
        }
        Map map = this.dropAssistants;
        synchronized (map) {
            asst = (CommonDropAdapterAssistant)this.dropAssistants.get(descriptor);
            if (asst == null) {
                asst = descriptor.createDropAssistant();
                this.dropAssistants.put(descriptor, asst);
                asst.init(this.contentService);
                asst.setCommonDropAdapter(this.dropAdapter);
            }
        }
        return asst;
    }
}

