/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup;

import org.eclipse.oomph.util.StringUtil;

public class Info {
    private static final String SEPARATOR = " ";
    private final String uuid;
    private final String name;

    protected Info(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string is null");
        }
        int pos = string.indexOf(SEPARATOR);
        if (pos != -1) {
            this.uuid = string.substring(0, pos);
            this.name = string.substring(pos + 1).trim();
        } else {
            this.uuid = string;
            this.name = null;
        }
    }

    protected Info(String uuid, String name) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid is null");
        }
        if (uuid.indexOf(32) != -1) {
            throw new IllegalArgumentException("uuid contains a space");
        }
        this.uuid = uuid;
        this.name = name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        if (!StringUtil.isEmpty((String)this.name)) {
            return this.name;
        }
        return this.uuid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Info other = (Info)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        String string = this.uuid;
        if (!StringUtil.isEmpty((String)this.name)) {
            string = String.valueOf(string) + SEPARATOR + this.name;
        }
        return string;
    }
}

