/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VControlPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;

public class VButtonPainter
extends VControlPainter {
    private VButton button;

    @Override
    public void paintBackground(VControl control, Event e) {
        this.button = (VButton)control;
        if (this.button.hasState(6)) {
            if (e.gc.getAlpha() == 255) {
                this.doPaintBackground(e.gc, this.button.bounds, this.button.getState());
            } else {
                Image img = new Image((Device)e.display, new Rectangle(0, 0, this.button.bounds.width, this.button.bounds.height));
                GC gc = new GC((Drawable)img);
                this.doPaintBackground(gc, img.getBounds(), this.button.getState());
                e.gc.drawImage(img, this.button.bounds.x, this.button.bounds.y);
                gc.dispose();
                img.dispose();
            }
        } else {
            super.paintBackground(control, e);
        }
    }

    private void doPaintBackground(GC gc, Rectangle bounds, int state) {
        Color outline = null;
        Color bkBlue = null;
        if ((state & 4) == 4) {
            outline = this.button.selectedBorderColor == null ? this.button.defaultSelectedBorderColor : this.button.selectedBorderColor;
            bkBlue = this.button.selectedBackgroundColor == null ? this.button.defaultSelectedBackgroundColor : this.button.selectedBackgroundColor;
        } else if ((state & 2) == 2) {
            outline = this.button.hoverBorderColor == null ? this.button.defaultHoverBorderColor : this.button.hoverBorderColor;
            Color color = bkBlue = this.button.hoverBackgroundColor == null ? this.button.defaultHoverBackgroundColor : this.button.hoverBackgroundColor;
        }
        if (outline != null && bkBlue != null) {
            gc.setBackground(bkBlue);
            gc.setForeground(outline);
            gc.fillRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        }
    }
}

