/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.views.markers.CompletionFieldFilter;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class CompletionConfigurationArea
extends FilterConfigurationArea {
    private Button completeButton;
    private Button incompleteButton;
    int completionState;

    @Override
    public void apply(MarkerFieldFilter filter) {
        ((CompletionFieldFilter)filter).setCompletion(this.completionState);
    }

    @Override
    public void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.completeButton = new Button(parent, 32);
        this.completeButton.setText(MarkerMessages.filtersDialog_statusComplete);
        this.completeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompletionConfigurationArea.this.updateCompletion(2, CompletionConfigurationArea.this.completeButton.getSelection());
            }
        });
        this.incompleteButton = new Button(parent, 32);
        this.incompleteButton.setText(MarkerMessages.filtersDialog_statusIncomplete);
        this.incompleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompletionConfigurationArea.this.updateCompletion(1, CompletionConfigurationArea.this.incompleteButton.getSelection());
            }
        });
    }

    void updateCompletion(int constant, boolean enabled) {
        this.completionState = enabled ? constant | this.completionState : constant ^ this.completionState;
    }

    @Override
    public void initialize(MarkerFieldFilter filter) {
        this.completionState = ((CompletionFieldFilter)filter).getCompletion();
        this.completeButton.setSelection((2 & this.completionState) > 0);
        this.incompleteButton.setSelection((1 & this.completionState) > 0);
    }

    @Override
    public String getTitle() {
        return MarkerMessages.filtersDialog_completionTitle;
    }
}

