/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.statushandlers.StatusHandlerDescriptor;
import org.eclipse.ui.internal.statushandlers.StatusHandlerDescriptorsMap;
import org.eclipse.ui.internal.statushandlers.StatusHandlerProductBindingDescriptor;

public class StatusHandlerRegistry
implements IExtensionChangeHandler {
    private static final String STATUSHANDLERS_POINT_NAME = "statusHandlers";
    private static final String TAG_STATUSHANDLER = "statusHandler";
    private static final String TAG_STATUSHANDLER_PRODUCTBINDING = "statusHandlerProductBinding";
    private static final String STATUSHANDLER_ARG = "-statushandler";
    private ArrayList<StatusHandlerDescriptor> statusHandlerDescriptors = new ArrayList();
    private ArrayList<StatusHandlerProductBindingDescriptor> productBindingDescriptors = new ArrayList();
    private StatusHandlerDescriptorsMap statusHandlerDescriptorsMap;
    private StatusHandlerDescriptor defaultHandlerDescriptor;
    private static StatusHandlerRegistry instance;

    private StatusHandlerRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        IExtensionPoint handlersPoint = Platform.getExtensionRegistry().getExtensionPoint(WorkbenchPlugin.PI_WORKBENCH, STATUSHANDLERS_POINT_NAME);
        IExtension[] extensions = handlersPoint.getExtensions();
        this.statusHandlerDescriptorsMap = new StatusHandlerDescriptorsMap();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension(tracker, extension);
            ++n2;
        }
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)handlersPoint));
        IExtensionPoint productsPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.runtime", "products");
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)productsPoint));
    }

    public static StatusHandlerRegistry getDefault() {
        if (instance == null) {
            instance = new StatusHandlerRegistry();
        }
        return instance;
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (configElement.getName().equals(TAG_STATUSHANDLER)) {
                descriptor = new StatusHandlerDescriptor(configElement);
                tracker.registerObject(extension, (Object)descriptor, 0);
                this.statusHandlerDescriptors.add((StatusHandlerDescriptor)descriptor);
            } else if (configElement.getName().equals(TAG_STATUSHANDLER_PRODUCTBINDING)) {
                descriptor = new StatusHandlerProductBindingDescriptor(configElement);
                tracker.registerObject(extension, (Object)descriptor, 0);
                this.productBindingDescriptors.add((StatusHandlerProductBindingDescriptor)descriptor);
            }
            ++n2;
        }
        this.buildHandlersStructure();
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof StatusHandlerDescriptor) {
                this.statusHandlerDescriptors.remove(object);
            } else if (object instanceof StatusHandlerProductBindingDescriptor) {
                this.productBindingDescriptors.remove(object);
            }
            ++n2;
        }
        this.buildHandlersStructure();
    }

    public StatusHandlerDescriptor getDefaultHandlerDescriptor() {
        return this.defaultHandlerDescriptor;
    }

    public List getHandlerDescriptors(String pluginId) {
        return this.statusHandlerDescriptorsMap.getHandlerDescriptors(pluginId);
    }

    public StatusHandlerDescriptor getHandlerDescriptor(String statusHandlerId) {
        StatusHandlerDescriptor descriptor2 = null;
        for (StatusHandlerDescriptor descriptor2 : this.statusHandlerDescriptors) {
            if (!descriptor2.getId().equals(statusHandlerId)) continue;
            return descriptor2;
        }
        if (this.defaultHandlerDescriptor != null && this.defaultHandlerDescriptor.getId().equals(statusHandlerId)) {
            return this.defaultHandlerDescriptor;
        }
        return null;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    private String resolveUserStatusHandlerId() {
        String[] parameters = Platform.getCommandLineArgs();
        int i = 0;
        while (i < parameters.length - 1) {
            if (STATUSHANDLER_ARG.equals(parameters[i])) {
                return parameters[i + 1];
            }
            ++i;
        }
        return null;
    }

    private void buildHandlersStructure() {
        this.statusHandlerDescriptorsMap.clear();
        this.defaultHandlerDescriptor = null;
        String productId = Platform.getProduct() != null ? Platform.getProduct().getId() : null;
        ArrayList<StatusHandlerDescriptor> allHandlers = new ArrayList<StatusHandlerDescriptor>();
        String defaultHandlerId = this.resolveUserStatusHandlerId();
        if (defaultHandlerId == null) {
            for (StatusHandlerProductBindingDescriptor statusHandlerProductBindingDescriptor : this.productBindingDescriptors) {
                if (!statusHandlerProductBindingDescriptor.getProductId().equals(productId)) continue;
                defaultHandlerId = statusHandlerProductBindingDescriptor.getHandlerId();
            }
        }
        for (StatusHandlerDescriptor statusHandlerDescriptor : this.statusHandlerDescriptors) {
            allHandlers.add(statusHandlerDescriptor);
        }
        Object var4_6 = null;
        for (StatusHandlerDescriptor statusHandlerDescriptor : allHandlers) {
            if (statusHandlerDescriptor.getId().equals(defaultHandlerId)) {
                this.defaultHandlerDescriptor = statusHandlerDescriptor;
                continue;
            }
            this.statusHandlerDescriptorsMap.addHandlerDescriptor(statusHandlerDescriptor);
        }
    }
}

