/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    private static final int AWT_WAITING_TIME_FOR_SWT_THREAD = 5000;
    private static final int SWT_THREAD_BLOCK_LIMIT = 200;
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static final String RUN_AWT_INVOKE_LATER_KEY = "org.eclipse.swt.internal.runAWTInvokeLater";
    static final String JDK17_FRAME = "sun.lwawt.macosx.CViewEmbeddedFrame";
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }

    static final native Object initFrame(long var0, String var2);

    static final native void validateWithBounds(Frame var0, int var1, int var2, int var3, int var4);

    static final native void synthesizeWindowActivation(Frame var0, boolean var1);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Frame getFrame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)parent.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        final long handle = parent.view.id;
        final String className = embeddedFrameClass != null ? embeddedFrameClass : JDK17_FRAME;
        try {
            if (embeddedFrameClass != null) {
                Class.forName(className);
            }
            SWT_AWT.loadLibrary();
        }
        catch (ClassNotFoundException cne) {
            SWT.error(20, cne);
        }
        catch (Throwable e2) {
            SWT.error(1, e2, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        final Frame[] result = new Frame[1];
        final Throwable[] exception = new Throwable[1];
        Runnable runnable = new Runnable(){
            boolean run;

            @Override
            public void run() {
                if (this.run) {
                    return;
                }
                this.run = true;
                Object obj = SWT_AWT.initFrame(handle, className);
                if (obj == null || !(obj instanceof Frame)) {
                    exception[0] = new Throwable("[Error while creating AWT embedded frame]");
                    SWT.error(1, exception[0]);
                    return;
                }
                result[0] = (Frame)obj;
                result[0].addNotify();
            }
        };
        if (EventQueue.isDispatchThread() || parent.getDisplay().getSyncThread() != null) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
            Display display = parent.getDisplay();
            while (result[0] == null && exception[0] == null) {
                display.setData(RUN_AWT_INVOKE_LATER_KEY, true);
                Boolean invoked = (Boolean)display.getData(RUN_AWT_INVOKE_LATER_KEY);
                if (invoked == null || invoked.booleanValue()) continue;
                runnable.run();
            }
        }
        if (exception[0] != null) {
            SWT.error(20, exception[0]);
        }
        final Frame frame = result[0];
        parent.setData(EMBEDDED_FRAME_KEY, frame);
        final Listener shellListener = e -> {
            switch (e.type) {
                case 20: {
                    EventQueue.invokeLater(() -> frame.dispatchEvent(new WindowEvent(frame, 204)));
                    break;
                }
                case 19: {
                    EventQueue.invokeLater(() -> frame.dispatchEvent(new WindowEvent(frame, 203)));
                }
            }
        };
        Shell shell = parent.getShell();
        shell.addListener(20, shellListener);
        shell.addListener(19, shellListener);
        final Display display = parent.getDisplay();
        display.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                while (frame.isDisplayable() && !display.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (!display.isDisposed()) {
                    display.removeListener(12, this);
                }
            }
        });
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        Shell shell = parent.getShell();
                        shell.removeListener(20, shellListener);
                        shell.removeListener(19, shellListener);
                        shell.removeListener(26, this);
                        shell.removeListener(27, this);
                        parent.setVisible(false);
                        EventQueue.invokeLater(() -> {
                            try {
                                frame.dispose();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                        break;
                    }
                    case 26: {
                        if (!parent.isFocusControl()) {
                            return;
                        }
                    }
                    case 15: {
                        EventQueue.invokeLater(() -> {
                            if (frame.isActive()) {
                                return;
                            }
                            this.synchronizedExecution(() -> parent != null && !parent.isDisposed() && parent.isFocusControl(), () -> SWT_AWT.synthesizeWindowActivation(frame, Boolean.TRUE));
                        });
                        break;
                    }
                    case 16: 
                    case 27: {
                        EventQueue.invokeLater(() -> {
                            if (!frame.isActive()) {
                                return;
                            }
                            this.synchronizedExecution(() -> parent == null || parent.isDisposed() || !parent.isFocusControl(), () -> SWT_AWT.synthesizeWindowActivation(frame, Boolean.FALSE));
                        });
                    }
                }
            }

            private void synchronizedExecution(Supplier<Boolean> swtExec, Runnable awtExec) {
                try {
                    AtomicBoolean swtResult = new AtomicBoolean();
                    CountDownLatch swtThreadStart = new CountDownLatch(1);
                    CountDownLatch awtThreadEnd = new CountDownLatch(1);
                    Display.getDefault().asyncExec(() -> {
                        swtResult.set((Boolean)swtExec.get());
                        swtThreadStart.countDown();
                        try {
                            awtThreadEnd.await(200L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    });
                    swtThreadStart.await(5000L, TimeUnit.MILLISECONDS);
                    if (swtResult.get()) {
                        awtExec.run();
                    }
                    awtThreadEnd.countDown();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        };
        parent.addListener(15, listener);
        parent.addListener(16, listener);
        shell.addListener(26, listener);
        shell.addListener(27, listener);
        parent.addListener(12, listener);
        display.asyncExec(() -> {
            if (parent.isDisposed()) {
                return;
            }
            Rectangle clientArea = parent.getClientArea();
            try {
                SWT_AWT.validateWithBounds(frame, clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        return frame;
    }

    public static Shell new_Shell(Display display, Canvas parent) {
        if (display == null) {
            SWT.error(4);
        }
        if (parent == null) {
            SWT.error(4);
        }
        SWT.error(20, null, "[Embedding SWT in AWT isn't supported on macOS]");
        return null;
    }
}

