/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming.client.websocket;

import java.net.HttpCookie;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.ClientConnectionFactoryOverHTTP2;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.JettyUpgradeListener;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class WebSocketClientDocs {
    public void start() throws Exception {
        WebSocketClient webSocketClient = new WebSocketClient();
        webSocketClient.setMaxTextMessageSize(8192L);
        webSocketClient.start();
    }

    public void startWithHttpClient() throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)new HttpProxy("localhost", 8888));
        WebSocketClient webSocketClient = new WebSocketClient(httpClient);
        webSocketClient.setMaxTextMessageSize(8192L);
        webSocketClient.start();
    }

    public void stop() throws Exception {
        WebSocketClient webSocketClient = new WebSocketClient();
        webSocketClient.start();
        new Thread(() -> LifeCycle.stop((Object)webSocketClient)).start();
    }

    public void connectHTTP11() throws Exception {
        HttpClient httpClient = new HttpClient();
        WebSocketClient webSocketClient = new WebSocketClient(httpClient);
        webSocketClient.start();
        ClientEndPoint clientEndPoint = new ClientEndPoint();
        URI serverURI = URI.create("ws://domain.com/path");
        CompletableFuture clientSessionPromise = webSocketClient.connect((Object)clientEndPoint, serverURI);
    }

    public void connectHTTP2() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP2(http2Client));
        WebSocketClient webSocketClient = new WebSocketClient(httpClient);
        webSocketClient.start();
        ClientEndPoint clientEndPoint = new ClientEndPoint();
        URI serverURI = URI.create("wss://domain.com/path");
        CompletableFuture clientSessionPromise = webSocketClient.connect((Object)clientEndPoint, serverURI);
    }

    public void connectHTTP2Dynamic() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(new ClientConnectionFactory.Info[]{new ClientConnectionFactoryOverHTTP2.HTTP2(http2Client)}));
        WebSocketClient webSocketClient = new WebSocketClient(httpClient);
        webSocketClient.start();
        ClientEndPoint clientEndPoint = new ClientEndPoint();
        URI serverURI = URI.create("wss://domain.com/path");
        CompletableFuture clientSessionPromise = webSocketClient.connect((Object)clientEndPoint, serverURI);
    }

    public void customHTTPRequest() throws Exception {
        WebSocketClient webSocketClient = new WebSocketClient(new HttpClient());
        webSocketClient.start();
        ClientEndPoint clientEndPoint = new ClientEndPoint();
        URI serverURI = URI.create("ws://domain.com/path");
        ClientUpgradeRequest customRequest = new ClientUpgradeRequest();
        customRequest.getCookies().add(new HttpCookie("name", "value"));
        customRequest.setHeader("X-Token", "0123456789ABCDEF");
        customRequest.setSubProtocols(new String[]{"chat"});
        CompletableFuture clientSessionPromise = webSocketClient.connect((Object)clientEndPoint, serverURI, customRequest);
    }

    public void inspectHTTPResponse() throws Exception {
        WebSocketClient webSocketClient = new WebSocketClient(new HttpClient());
        webSocketClient.start();
        ClientEndPoint clientEndPoint = new ClientEndPoint();
        URI serverURI = URI.create("ws://domain.com/path");
        JettyUpgradeListener listener = new JettyUpgradeListener(){

            public void onHandshakeResponse(HttpRequest request, HttpResponse response) {
            }
        };
        CompletableFuture clientSessionPromise = webSocketClient.connect((Object)clientEndPoint, serverURI, null, listener);
    }

    public class ClientEndPoint {
    }
}

