/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.lang.management.ManagementFactory;
import org.eclipse.jetty.demos.DumpServlet;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class OneServletContextJmxStats {
    public static Server createServer(int port) {
        Server server = new Server(port);
        server.addBean((Object)new MBeanContainer(ManagementFactory.getPlatformMBeanServer()));
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(DumpServlet.class, "/dump/*");
        context.addServlet(DefaultServlet.class, "/");
        server.addBeanToAllConnectors((Object)new ConnectionStatistics());
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = OneServletContextJmxStats.createServer(port);
        server.start();
        server.join();
    }
}

