/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.HelloHandler;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.security.Constraint;

public class SecuredHelloHandler {
    public static Server createServer(int port) throws FileNotFoundException {
        Server server = new Server(port);
        String realmResourceName = "etc/realm.properties";
        ClassLoader classLoader = SecuredHelloHandler.class.getClassLoader();
        URL realmProps = classLoader.getResource(realmResourceName);
        if (realmProps == null) {
            throw new FileNotFoundException("Unable to find " + realmResourceName);
        }
        HashLoginService loginService = new HashLoginService("MyRealm", realmProps.toExternalForm());
        server.addBean((Object)loginService);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        server.setHandler((Handler)security);
        Constraint constraint = new Constraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"user", "admin"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        security.setAuthenticator((Authenticator)new BasicAuthenticator());
        security.setLoginService((LoginService)loginService);
        HelloHandler hh = new HelloHandler();
        security.setHandler((Handler)hh);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = SecuredHelloHandler.createServer(port);
        server.start();
        server.join();
    }
}

