/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.http3.internal.parser.MessageParser;
import org.eclipse.jetty.http3.internal.parser.ParserListener;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.RetainableByteBufferPool;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP3StreamConnection
extends AbstractConnection {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3StreamConnection.class);
    private static final ByteBuffer EMPTY_DATA_FRAME = ByteBuffer.allocate(2);
    private final AutoLock lock = new AutoLock();
    private final AtomicReference<Runnable> event = new AtomicReference();
    private final RetainableByteBufferPool buffers;
    private final MessageParser parser;
    private boolean useInputDirectByteBuffers = true;
    private RetainableByteBuffer buffer;
    private boolean dataDemand;
    private boolean dataStalled;
    private DataFrame dataFrame;
    private boolean dataLast;
    private boolean hasNetworkData;
    private boolean remotelyClosed;

    public HTTP3StreamConnection(QuicStreamEndPoint endPoint, Executor executor, ByteBufferPool byteBufferPool, MessageParser parser) {
        super((EndPoint)endPoint, executor);
        this.buffers = byteBufferPool.asRetainableByteBufferPool();
        this.parser = parser;
        parser.init(x$0 -> new MessageListener((ParserListener)x$0));
    }

    public QuicStreamEndPoint getEndPoint() {
        return (QuicStreamEndPoint)super.getEndPoint();
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onClose(Throwable cause) {
        this.tryReleaseBuffer(true);
        super.onClose(cause);
    }

    protected boolean onReadTimeout(Throwable timeout) {
        return false;
    }

    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processing dataMode={} on {}", (Object)this.parser.isDataMode(), (Object)this);
        }
        if (this.parser.isDataMode()) {
            this.processDataFrames();
        } else {
            this.processNonDataFrames();
        }
    }

    private void processDataFrames() {
        this.processDataDemand();
        if (!this.parser.isDataMode()) {
            if (this.hasBuffer() && this.buffer.hasRemaining()) {
                this.processNonDataFrames();
            } else {
                this.fillInterested();
            }
        }
    }

    private void processNonDataFrames() {
        try {
            this.tryAcquireBuffer();
            MessageParser.Result result = this.parseAndFill(true);
            if (result == MessageParser.Result.NO_FRAME) {
                this.tryReleaseBuffer(false);
                return;
            }
            if (result == MessageParser.Result.BLOCKED_FRAME) {
                this.tryReleaseBuffer(false);
                return;
            }
            Runnable action = this.event.getAndSet(null);
            if (action == null) {
                throw new IllegalStateException();
            }
            action.run();
            if (this.remotelyClosed) {
                this.getEndPoint().getQuicSession().flush();
                this.tryReleaseBuffer(false);
                return;
            }
            if (!this.parser.isDataMode()) {
                throw new IllegalStateException();
            }
            if (this.hasBuffer() && this.buffer.hasRemaining()) {
                this.processDataFrames();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("setting fill interest on {}", (Object)this);
                }
                this.tryReleaseBuffer(false);
                this.fillInterested();
            }
        }
        catch (Throwable x) {
            this.tryReleaseBuffer(true);
            long error = HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code();
            this.getEndPoint().close(error, x);
            this.parser.getListener().onStreamFailure(this.getEndPoint().getStreamId(), error, x);
        }
    }

    protected abstract void onDataAvailable(long var1);

    public Stream.Data readData() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("reading data on {}", (Object)this);
            }
            this.tryAcquireBuffer();
            switch (this.parseAndFill(false)) {
                case FRAME: {
                    Runnable action = this.event.getAndSet(null);
                    if (action == null) {
                        throw new IllegalStateException();
                    }
                    action.run();
                    if (this.parser.isDataMode()) {
                        DataFrame frame = this.dataFrame;
                        this.dataFrame = null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("read data {} on {}", (Object)frame, (Object)this);
                        }
                        this.buffer.retain();
                        RetainableByteBuffer current = this.buffer;
                        this.tryReleaseBuffer(false);
                        return new Stream.Data(frame, () -> this.completeReadData(current));
                    }
                    this.tryReleaseBuffer(false);
                    return null;
                }
                case SWITCH_MODE: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("switching to dataMode=false on {}", (Object)this);
                    }
                    this.dataLast = true;
                    this.parser.setDataMode(false);
                    this.tryReleaseBuffer(false);
                    return null;
                }
                case NO_FRAME: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("read no data on {}", (Object)this);
                    }
                    this.tryReleaseBuffer(false);
                    return null;
                }
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            this.cancelDemand();
            this.tryReleaseBuffer(true);
            this.getEndPoint().close(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x);
            throw x;
        }
    }

    private void completeReadData(RetainableByteBuffer buffer) {
        buffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("released retained {}", (Object)buffer);
        }
    }

    public void demand() {
        boolean hasData;
        boolean process = false;
        try (AutoLock ignored = this.lock.lock();){
            hasData = this.hasNetworkData;
            this.dataDemand = true;
            if (this.dataStalled && hasData) {
                this.dataStalled = false;
                process = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("demand, wasStalled={} hasData={} on {}", new Object[]{process, hasData, this});
        }
        if (process) {
            this.processDataFrames();
        } else if (!hasData) {
            this.fillInterested();
        }
    }

    public boolean hasDemand() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataDemand;
            return bl;
        }
    }

    private void cancelDemand() {
        try (AutoLock ignored = this.lock.lock();){
            this.dataDemand = false;
        }
    }

    private boolean isStalled() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataStalled;
            return bl;
        }
    }

    private void setHasNetworkData(boolean noData) {
        try (AutoLock ignored = this.lock.lock();){
            this.hasNetworkData = noData;
        }
    }

    private void processDataDemand() {
        while (true) {
            boolean process = true;
            try (AutoLock ignored = this.lock.lock();){
                if (LOG.isDebugEnabled()) {
                    LOG.debug("processing demand={}, last={} fillInterested={} on {}", new Object[]{this.dataDemand, this.dataLast, this.isFillInterested(), this});
                }
                if (this.dataDemand) {
                    if (this.dataLast || this.isFillInterested()) {
                        process = false;
                    } else {
                        this.dataDemand = false;
                    }
                } else {
                    this.dataStalled = true;
                    process = false;
                }
            }
            if (!process) {
                return;
            }
            this.onDataAvailable(this.getEndPoint().getStreamId());
        }
    }

    private void tryAcquireBuffer() {
        if (!this.hasBuffer()) {
            this.buffer = this.buffers.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("acquired {}", (Object)this.buffer);
            }
        }
    }

    private void tryReleaseBuffer(boolean force) {
        if (this.hasBuffer()) {
            if (this.buffer.hasRemaining() && force) {
                this.buffer.clear();
            }
            if (!this.buffer.hasRemaining()) {
                this.buffer.release();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("released {}", (Object)this.buffer);
                }
                this.buffer = null;
            }
        }
    }

    public boolean hasBuffer() {
        return this.buffer != null;
    }

    private MessageParser.Result parseAndFill(boolean setFillInterest) {
        try {
            int filled;
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse+fill setFillInterest={} on {} with buffer {}", new Object[]{setFillInterest, this, this.buffer});
            }
            this.setHasNetworkData(true);
            do {
                ByteBuffer byteBuffer = this.buffer.getBuffer();
                MessageParser.Result result = this.parser.parse(byteBuffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsed {} on {} with buffer {}", new Object[]{result, this, this.buffer});
                }
                if (result != MessageParser.Result.NO_FRAME) {
                    return result;
                }
                if (this.buffer.isRetained()) {
                    this.buffer.release();
                    RetainableByteBuffer newBuffer = this.buffers.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("reacquired {} for retained {}", (Object)newBuffer, (Object)this.buffer);
                    }
                    this.buffer = newBuffer;
                    byteBuffer = this.buffer.getBuffer();
                }
                filled = this.fill(byteBuffer);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("filled {} on {} with buffer {}", new Object[]{filled, this, this.buffer});
            } while (filled > 0);
            if (filled == 0) {
                if (!this.remotelyClosed && this.getEndPoint().isStreamFinished()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("detected end of stream on {}", (Object)this);
                    }
                    this.parser.parse(EMPTY_DATA_FRAME.slice());
                    return MessageParser.Result.FRAME;
                }
                this.setHasNetworkData(false);
                if (setFillInterest) {
                    this.fillInterested();
                }
            }
            return MessageParser.Result.NO_FRAME;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse+fill failure on {}", (Object)this, (Object)x);
            }
            throw x;
        }
    }

    private int fill(ByteBuffer byteBuffer) {
        try {
            return this.getEndPoint().fill(byteBuffer);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x.getMessage(), x);
        }
    }

    private void processHeaders(HeadersFrame frame, boolean wasBlocked, Runnable delegate) {
        MetaData metaData = frame.getMetaData();
        if (metaData.isRequest()) {
            this.parser.setDataMode(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("switching to dataMode=true for request {} on {}", (Object)metaData, (Object)this);
            }
        } else if (metaData.isResponse()) {
            MetaData.Response response = (MetaData.Response)metaData;
            if (HttpStatus.isInformational((int)response.getStatus())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("staying in dataMode=false for response {} on {}", (Object)metaData, (Object)this);
                }
            } else {
                this.parser.setDataMode(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("switching to dataMode=true for response {} on {}", (Object)metaData, (Object)this);
                }
            }
        } else if (!frame.isLast()) {
            frame = new HeadersFrame(metaData, true);
        }
        if (frame.isLast()) {
            this.shutdownInput();
        }
        delegate.run();
        if (wasBlocked) {
            this.onFillable();
        }
    }

    private void processData(DataFrame frame, Runnable delegate) {
        if (this.dataFrame != null) {
            throw new IllegalStateException();
        }
        this.dataFrame = frame;
        if (frame.isLast()) {
            this.dataLast = true;
            this.shutdownInput();
        }
        delegate.run();
    }

    private void shutdownInput() {
        this.remotelyClosed = true;
        this.getEndPoint().shutdownInput(HTTP3ErrorCode.NO_ERROR.code());
    }

    public String toConnectionString() {
        return String.format("%s[demand=%b,stalled=%b,dataMode=%b]", super.toConnectionString(), this.hasDemand(), this.isStalled(), this.parser.isDataMode());
    }

    private class MessageListener
    extends ParserListener.Wrapper {
        private MessageListener(ParserListener listener) {
            super(listener);
        }

        @Override
        public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("received {}#{} wasBlocked={}", new Object[]{frame, streamId, wasBlocked});
            }
            Runnable delegate = () -> super.onHeaders(streamId, frame, wasBlocked);
            Runnable action = () -> HTTP3StreamConnection.this.processHeaders(frame, wasBlocked, delegate);
            if (wasBlocked) {
                action.run();
            } else if (!HTTP3StreamConnection.this.event.compareAndSet(null, action)) {
                throw new IllegalStateException();
            }
        }

        @Override
        public void onData(long streamId, DataFrame frame) {
            Runnable delegate;
            if (LOG.isDebugEnabled()) {
                LOG.debug("received {}#{}", (Object)frame, (Object)streamId);
            }
            if (!HTTP3StreamConnection.this.event.compareAndSet(null, () -> this.lambda$onData$3(frame, delegate = () -> super.onData(streamId, frame)))) {
                throw new IllegalStateException();
            }
        }

        private /* synthetic */ void lambda$onData$3(DataFrame frame, Runnable delegate) {
            HTTP3StreamConnection.this.processData(frame, delegate);
        }
    }
}

