/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.jna;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.net.SocketAddress;
import org.eclipse.jetty.quic.quiche.jna.SizedStructure;
import org.eclipse.jetty.quic.quiche.jna.linux.netinet_linux;
import org.eclipse.jetty.quic.quiche.jna.macos.netinet_macos;
import org.eclipse.jetty.quic.quiche.jna.windows.netinet_windows;

@Structure.FieldOrder(value={"opaque"})
public class sockaddr
extends Structure {
    public byte[] opaque = new byte[16];

    public sockaddr(Pointer p) {
        super(p);
        this.read();
    }

    public static SizedStructure<sockaddr> convert(SocketAddress socketAddress) {
        if (Platform.isLinux()) {
            return netinet_linux.to_sock_addr(socketAddress);
        }
        if (Platform.isMac()) {
            return netinet_macos.to_sock_addr(socketAddress);
        }
        if (Platform.isWindows()) {
            return netinet_windows.to_sock_addr(socketAddress);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + System.getProperty("os.name"));
    }

    public ByReference byReference() {
        return new ByReference(this.getPointer());
    }

    public static class ByReference
    extends sockaddr
    implements Structure.ByReference {
        private ByReference(Pointer p) {
            super(p);
        }
    }
}

