/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Domain;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDomainsCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get available target domains";
    private String domainName;
    private boolean defaultDomainMode;
    private List<Domain> domains;

    public GetDomainsCommand(Target target) {
        super(target);
    }

    public GetDomainsCommand(Target target, boolean defaultDomainMode) {
        super(target);
        this.defaultDomainMode = defaultDomainMode;
    }

    public GetDomainsCommand(Target target, String domainName) {
        super(target);
        this.domainName = domainName;
    }

    public List<Domain> getDomains() {
        this.assertWasRun();
        return this.domains;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            Domain domain;
            JSONObject domainJSON;
            int k;
            JSONObject result = new JSONObject();
            this.domains = new ArrayList<Domain>();
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            JSONObject domainsPrivateJSON = null;
            JSONArray resources = null;
            if (!this.defaultDomainMode) {
                ServerStatus getPrivateDomainsStatus;
                String privateDomainsURL = this.target.getOrg().getCFJSON().getJSONObject("entity").getString("private_domains_url");
                URI privateDomainsURI = targetURI.resolve(privateDomainsURL);
                GetMethod getPrivateDomainMethod = new GetMethod(privateDomainsURI.toString());
                ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getPrivateDomainMethod, this.target.getCloud());
                if (!confStatus.isOK()) {
                    return confStatus;
                }
                if (this.domainName != null) {
                    getPrivateDomainMethod.setQueryString("q=" + URLEncoder.encode("name:" + this.domainName, "UTF8"));
                }
                if (!(getPrivateDomainsStatus = HttpUtil.executeMethod((HttpMethodBase)getPrivateDomainMethod)).isOK()) {
                    return getPrivateDomainsStatus;
                }
                domainsPrivateJSON = getPrivateDomainsStatus.getJsonData();
                resources = domainsPrivateJSON.getJSONArray("resources");
                k = 0;
                while (k < resources.length()) {
                    domainJSON = resources.getJSONObject(k);
                    domain = new Domain();
                    domain.setCFJSON(domainJSON);
                    this.domains.add(domain);
                    result.append("Domains", (Object)domain.toJSON());
                    ++k;
                }
            }
            if (this.domainName == null || this.defaultDomainMode || domainsPrivateJSON.getInt("total_results") < 1) {
                URI sharedDomainsURI = targetURI.resolve("/v2/shared_domains");
                GetMethod getSharedDomainMethod = new GetMethod(sharedDomainsURI.toString());
                ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getSharedDomainMethod, this.target.getCloud());
                if (!confStatus.isOK()) {
                    return confStatus;
                }
                if (this.domainName != null) {
                    getSharedDomainMethod.setQueryString("q=" + URLEncoder.encode("name:" + this.domainName, "UTF8"));
                } else if (this.defaultDomainMode) {
                    getSharedDomainMethod.setQueryString("page=1&results-per-page=1");
                }
                ServerStatus getSharedDomainsStatus = HttpUtil.executeMethod((HttpMethodBase)getSharedDomainMethod);
                if (!getSharedDomainsStatus.isOK()) {
                    return getSharedDomainsStatus;
                }
                JSONObject domainsSharedJSON = getSharedDomainsStatus.getJsonData();
                resources = domainsSharedJSON.getJSONArray("resources");
                k = 0;
                while (k < resources.length()) {
                    domainJSON = resources.getJSONObject(k);
                    domain = new Domain();
                    domain.setCFJSON(domainJSON);
                    this.domains.add(domain);
                    result.append("Domains", (Object)domain.toJSON());
                    ++k;
                }
                if (this.domains.isEmpty()) {
                    return new ServerStatus(4, 404, "Domain can not be found", null);
                }
                return new ServerStatus(Status.OK_STATUS, 200, result);
            }
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

