/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Stack;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStackByNameCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get stack by name";
    private String stackName;
    private Stack stack;

    public GetStackByNameCommand(Target target, String stackName) {
        super(target);
        this.stackName = stackName;
    }

    public Stack getStack() {
        return this.stack;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI servicesURI = targetURI.resolve("/v2/stacks");
            GetMethod getStacksMethod = new GetMethod(servicesURI.toString());
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("q", "name:" + this.stackName), new NameValuePair("inline-relations-depth", "1")};
            getStacksMethod.setQueryString(params);
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getStacksMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ServerStatus getStacksStatus = HttpUtil.executeMethod((HttpMethodBase)getStacksMethod);
            if (!getStacksStatus.isOK()) {
                return getStacksStatus;
            }
            JSONObject stacksJSON = getStacksStatus.getJsonData();
            if (stacksJSON.getInt("total_results") < 1) {
                return getStacksStatus;
            }
            JSONArray resources = stacksJSON.getJSONArray("resources");
            JSONObject stackJSON = resources.getJSONObject(0);
            this.stack = new Stack().setCFJSON(stackJSON);
            return getStacksStatus;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

