/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.workspacepruner;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.UserEmailUtil;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspacePrunerJob
extends Job {
    private Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.account");
    private int notificationThresholdDays;
    private int gracePeriodDays;
    private String installationUrl;
    private static final int MINIMUM_DELETE_THRESHOLD_DAYS = 5;
    private static final int FINAL_WARNING_THRESHOLD_DAYS = 2;
    private static final long MS_IN_DAY = 86400000L;
    private static final String PROPERTY_GIT_MAIL = "GitMail";
    private static final String PROPERTY_GIT_USERINFO = "git/config/userInfo";
    private static final String TRUE = "true";
    private static final String UNKNOWN = "unknown";
    private static final Pattern conversionPattern = Pattern.compile("([0123456789.]+)\\s*(.)");

    public WorkspacePrunerJob() {
        super("Orion Workspace Pruner");
        String prefString = PreferenceHelper.getString("orion.workspacePruner.daycount.initialNotification", null);
        try {
            this.notificationThresholdDays = prefString == null ? 0 : Integer.valueOf(prefString);
        }
        catch (NumberFormatException numberFormatException) {}
        if (this.notificationThresholdDays < 0) {
            this.logger.warn("Workspace pruner will not run because a valid value was not found for config option: orion.workspacePruner.daycount.initialNotification");
            return;
        }
        prefString = PreferenceHelper.getString("orion.workspacePruner.daycount.deletionAfterNotification", null);
        try {
            this.gracePeriodDays = prefString == null ? 0 : Integer.valueOf(prefString);
        }
        catch (NumberFormatException numberFormatException) {}
        if (this.gracePeriodDays <= 0) {
            this.logger.warn("Workspace pruner will not run because a valid value was not found for config option: orion.workspacePruner.daycount.deletionAfterNotification");
            return;
        }
        if (this.gracePeriodDays < 5) {
            this.gracePeriodDays = 0;
            this.logger.warn("Workspace pruner will not run because the minimum number of days between initial e-mail warning notification and workspace deletion is : 5");
            return;
        }
        this.installationUrl = PreferenceHelper.getString("orion.workspacePruner.installUrl", "");
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.notificationThresholdDays >= 0 && this.gracePeriodDays > 0) {
            if (!this.traverseWorkspaces()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Orion workspace pruner job waiting for user metadata service");
                }
                this.schedule(5000L);
                return Status.OK_STATUS;
            }
            this.schedule(86400000L);
        }
        return Status.OK_STATUS;
    }

    private long convertToK(String usageString) {
        if (usageString.equals(UNKNOWN)) {
            return 0L;
        }
        double quantity = 0.0;
        Matcher matcher = conversionPattern.matcher(usageString);
        if (matcher.find()) {
            quantity = Double.valueOf(matcher.group(1));
            String unit = matcher.group(2);
            if (unit.equalsIgnoreCase("M")) {
                quantity *= 1024.0;
            } else if (unit.equalsIgnoreCase("G")) {
                quantity *= 1048576.0;
            } else if (!unit.equalsIgnoreCase("K")) {
                quantity = 0.0;
                this.logger.warn("Orion workspace pruner job encountered unexpected disk size unit: " + unit);
            }
        } else {
            this.logger.warn("Orion workspace pruner job encountered unexpected disk size string: " + usageString);
        }
        return (long)quantity;
    }

    private String getEmailAddress(UserInfo userInfo) {
        String result = userInfo.getProperty("Email");
        if (result != null) {
            return result;
        }
        String gitUserInfo = userInfo.getProperty(PROPERTY_GIT_USERINFO);
        if (gitUserInfo != null) {
            try {
                JSONObject object = new JSONObject(gitUserInfo);
                result = object.getString(PROPERTY_GIT_MAIL);
                if (result.length() > 0) {
                    return result;
                }
            }
            catch (JSONException jSONException) {
                this.logger.warn("Orion workspace pruner did not find GitMail within git/config/userInfo for " + userInfo.getUniqueId());
            }
        }
        return null;
    }

    private boolean traverseWorkspaces() {
        List<String> userids;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Orion workspace pruner job started");
        }
        IMetaStore metaStore = OrionConfiguration.getMetaStore();
        try {
            userids = metaStore.readAllUsers();
        }
        catch (CoreException e) {
            this.logger.error("Orion workspace pruner could not read all users", (Throwable)e);
            return false;
        }
        long totalReclaimedK = 0L;
        int prunedUserCount = 0;
        long warningThresholdMS = (long)this.notificationThresholdDays * 86400000L;
        DateFormat dateFormatter = DateFormat.getDateInstance(1);
        UserEmailUtil emailUtil = UserEmailUtil.getUtil();
        Calendar calendar = Calendar.getInstance();
        long now = calendar.getTimeInMillis();
        calendar.add(5, this.gracePeriodDays);
        long deletionTimestamp = calendar.getTimeInMillis();
        String deletionDateString = dateFormatter.format(calendar.getTime());
        for (String userId : userids) {
            try {
                String lastLoginProperty;
                UserInfo userInfo = metaStore.readUser(userId);
                String emailAddress = this.getEmailAddress(userInfo);
                if (emailAddress == null) {
                    this.logger.info("Workspace pruner will not process a user because it cannot determine the e-mail address for: " + userInfo.getUniqueId());
                    continue;
                }
                if (!this.hasProject(userInfo) || (lastLoginProperty = userInfo.getProperty("LastLoginTimestamp")) == null) continue;
                boolean userUpdated = false;
                long lastLoginTimestamp = Long.valueOf(lastLoginProperty);
                String startDateProperty = userInfo.getProperty("PrunerStartTimestamp");
                if (startDateProperty == null) {
                    long diff = now - lastLoginTimestamp;
                    if (warningThresholdMS < diff) {
                        try {
                            String lastLoginDateString = dateFormatter.format(new Date(lastLoginTimestamp));
                            emailUtil.sendInactiveWorkspaceNotification(userInfo, lastLoginDateString, deletionDateString, this.installationUrl, false, emailAddress);
                            userInfo.setProperty("PrunerStartTimestamp", String.valueOf(now));
                            userInfo.setProperty("PrunerEndTimestamp", String.valueOf(deletionTimestamp));
                            userUpdated = true;
                            this.logger.info("Initial inactive user notification sent to " + emailAddress + ", last login was: " + lastLoginDateString);
                        }
                        catch (Exception e) {
                            this.logger.warn("Orion workspace pruner failed its attempt to send an initial notification to inactive user: " + emailAddress, (Throwable)e);
                        }
                    }
                } else {
                    long startDate = Long.valueOf(startDateProperty);
                    if (startDate < lastLoginTimestamp) {
                        userInfo.setProperty("PrunerStartTimestamp", null);
                        userInfo.setProperty("PrunerReminderSent", null);
                        userInfo.setProperty("PrunerFinalWarningSent", null);
                        userInfo.setProperty("PrunerEndTimestamp", null);
                        userUpdated = true;
                    } else {
                        String endDateProperty = userInfo.getProperty("PrunerEndTimestamp");
                        long endDate = Long.valueOf(endDateProperty);
                        String finalWarningSent = userInfo.getProperty("PrunerFinalWarningSent");
                        if (endDate < now) {
                            String reminderSent = userInfo.getProperty("PrunerReminderSent");
                            if (reminderSent != null || finalWarningSent != null) {
                                File userRoot = metaStore.getUserHome(userId).toLocalFile(0, null);
                                long initialSize = this.convertToK(this.getFolderSize(userRoot));
                                List<String> workspaceIds = userInfo.getWorkspaceIds();
                                ListIterator<String> iterator = workspaceIds.listIterator();
                                boolean allSuccessful = true;
                                while (iterator.hasNext()) {
                                    allSuccessful &= this.deleteAllProjects(userId, iterator.next());
                                }
                                ++prunedUserCount;
                                long reclaimedK = initialSize - this.convertToK(this.getFolderSize(userRoot));
                                totalReclaimedK += reclaimedK;
                                this.logger.info("Deleted projects for user " + emailAddress + ", space reclaimed: " + this.toConsumableString(reclaimedK));
                                if (allSuccessful) {
                                    userInfo.setProperty("PrunerStartTimestamp", null);
                                    userInfo.setProperty("PrunerReminderSent", null);
                                    userInfo.setProperty("PrunerFinalWarningSent", null);
                                    userInfo.setProperty("PrunerEndTimestamp", null);
                                    userUpdated = true;
                                }
                            } else {
                                calendar.setTimeInMillis(now);
                                calendar.add(5, 2);
                                try {
                                    emailUtil.sendInactiveWorkspaceFinalWarning(userInfo, dateFormatter.format(new Date(calendar.getTimeInMillis())), this.installationUrl, emailAddress);
                                    userInfo.setProperty("PrunerFinalWarningSent", TRUE);
                                    userInfo.setProperty("PrunerEndTimestamp", String.valueOf(calendar.getTimeInMillis()));
                                    userUpdated = true;
                                    this.logger.info("Final inactive user warning sent to " + emailAddress + " (bumped), last login was: " + dateFormatter.format(new Date(lastLoginTimestamp)));
                                }
                                catch (Exception e) {
                                    this.logger.warn("Orion workspace pruner failed its attempt to send a (bumped) final warning to inactive user: " + emailAddress, (Throwable)e);
                                }
                            }
                        } else if (finalWarningSent == null) {
                            long nowPlusThreshold = now + 172800000L;
                            if (endDate < nowPlusThreshold) {
                                try {
                                    emailUtil.sendInactiveWorkspaceFinalWarning(userInfo, dateFormatter.format(new Date(endDate)), this.installationUrl, emailAddress);
                                    userInfo.setProperty("PrunerFinalWarningSent", TRUE);
                                    userUpdated = true;
                                    this.logger.info("Final inactive user warning sent to " + emailAddress + ", last login was: " + dateFormatter.format(new Date(lastLoginTimestamp)));
                                }
                                catch (Exception e) {
                                    this.logger.warn("Orion workspace pruner failed its attempt to send a final warning to inactive user: " + emailAddress, (Throwable)e);
                                }
                            } else {
                                long middle;
                                String reminderSent = userInfo.getProperty("PrunerReminderSent");
                                if (reminderSent == null && (middle = startDate + (endDate - startDate) / 2L) < now) {
                                    try {
                                        String lastLoginDateString = dateFormatter.format(new Date(lastLoginTimestamp));
                                        emailUtil.sendInactiveWorkspaceNotification(userInfo, lastLoginDateString, dateFormatter.format(new Date(endDate)), this.installationUrl, true, emailAddress);
                                        userInfo.setProperty("PrunerReminderSent", TRUE);
                                        userUpdated = true;
                                        this.logger.info("Reminder inactive user e-mail sent to " + emailAddress + ", last login was: " + dateFormatter.format(new Date(lastLoginTimestamp)));
                                    }
                                    catch (Exception e) {
                                        this.logger.warn("Orion workspace pruner failed its attempt to send a reminder e-mail to inactive user: " + emailAddress, (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                }
                if (!userUpdated) continue;
                metaStore.updateUser(userInfo);
            }
            catch (CoreException e) {
                this.logger.error("Orion workspace pruner error while processing user: " + userId, (Throwable)e);
            }
        }
        if (prunedUserCount > 0) {
            this.logger.info("Summary: Orion workspace pruner deleted workspaces for " + prunedUserCount + " users, total space reclaimed: " + this.toConsumableString(totalReclaimedK));
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Orion workspace pruner job completed");
        }
        return true;
    }

    private boolean deleteAllProjects(String userId, String workspaceId) {
        IMetaStore metaStore = OrionConfiguration.getMetaStore();
        WorkspaceInfo workspace = null;
        try {
            workspace = metaStore.readWorkspace(workspaceId);
        }
        catch (CoreException e) {
            this.logger.error("Orion workspace pruner failed to read the workspace metadata: " + workspaceId, (Throwable)e);
            return false;
        }
        boolean allSuccessful = true;
        List<String> projectNames = workspace.getProjectNames();
        Iterator<String> namesIterator = projectNames.iterator();
        while (namesIterator.hasNext()) {
            ProjectInfo project = null;
            String projectName = namesIterator.next();
            try {
                project = metaStore.readProject(workspaceId, projectName);
                if (project == null) continue;
                URI contentURI = project.getContentLocation();
                IFileStore projectStore = metaStore.getDefaultContentLocation(project);
                URI defaultLocation = projectStore.toURI();
                if (URIUtil.sameURI((URI)defaultLocation, (URI)contentURI)) {
                    projectStore.delete(0, null);
                }
                metaStore.deleteProject(workspaceId, projectName);
            }
            catch (CoreException e) {
                this.logger.error("Orion workspace pruner failed to delete project: " + projectName + ", workspace: " + workspaceId, (Throwable)e);
                allSuccessful = false;
            }
        }
        return allSuccessful;
    }

    private boolean hasProject(UserInfo userInfo) {
        IMetaStore metaStore = OrionConfiguration.getMetaStore();
        List<String> workspaceIds = userInfo.getWorkspaceIds();
        ListIterator<String> iterator = workspaceIds.listIterator();
        while (iterator.hasNext()) {
            String workspaceId = iterator.next();
            try {
                WorkspaceInfo workspace = metaStore.readWorkspace(workspaceId);
                if (workspace.getProjectNames().size() <= 0) continue;
                return true;
            }
            catch (CoreException e) {
                this.logger.error("Orion workspace pruner failed to read the workspace metadata: " + workspaceId, (Throwable)e);
            }
        }
        return false;
    }

    private String toConsumableString(long quantity) {
        String unit = "KB";
        if (quantity > 1024L) {
            quantity /= 1024L;
            unit = "MB";
        }
        if (quantity > 1024L) {
            quantity /= 1024L;
            unit = "GB";
        }
        return String.valueOf(quantity) + unit;
    }

    private String getFolderSize(File folder) {
        StringBuffer commandOutput = new StringBuffer();
        try {
            Process process = Runtime.getRuntime().exec("du -hs " + folder.toString());
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                commandOutput.append(String.valueOf(line) + "\n");
            }
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
        String size = commandOutput.toString();
        if (size.indexOf("\t") == -1) {
            return UNKNOWN;
        }
        return size.substring(0, size.indexOf("\t"));
    }
}

