/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Space;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetSpaceCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private boolean isGuid;
    private String defaultSpace;
    private String commandName;
    private String space;

    public SetSpaceCommand(Target target, String spaceName) {
        super(target);
        this.space = spaceName;
        this.isGuid = false;
        this.defaultSpace = null;
        this.commandName = "Set Space";
    }

    public SetSpaceCommand(Target target, String space, boolean isGuid) {
        super(target);
        this.space = space;
        this.isGuid = isGuid;
        this.defaultSpace = null;
        this.commandName = "Set Space";
    }

    public void setDefaultSpace(String defaultSpace) {
        this.defaultSpace = defaultSpace;
    }

    protected Space getSpace(JSONArray spaces, String orgSpace) throws JSONException {
        int i = 0;
        while (i < spaces.length()) {
            JSONObject spaceJSON = spaces.getJSONObject(i);
            if (!this.isGuid && orgSpace.equals(spaceJSON.getJSONObject("entity").getString("name")) || this.isGuid && orgSpace.equals(spaceJSON.getJSONObject("metadata").getString("guid"))) {
                return new Space().setCFJSON(spaceJSON);
            }
            ++i;
        }
        return null;
    }

    protected Space getArbitrarySpace(JSONArray spaces) throws JSONException {
        JSONObject org = spaces.getJSONObject(0);
        return new Space().setCFJSON(org);
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String spaceUrl = this.target.getOrg().getCFJSON().getJSONObject("entity").getString("spaces_url");
            URI spaceURI = targetURI.resolve(spaceUrl);
            GetMethod getMethod = new GetMethod(spaceURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getMethod, this.target.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethodBase)getMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject result = getStatus.getJsonData();
            JSONArray spaces = result.getJSONArray("resources");
            if (spaces.length() == 0) {
                return new ServerStatus(4, 404, "Space not found", null);
            }
            if (this.space == null || "".equals(this.space)) {
                Space finalFrontier = null;
                if (this.defaultSpace != null) {
                    finalFrontier = this.getSpace(spaces, this.defaultSpace);
                    if (finalFrontier == null) {
                        finalFrontier = this.getArbitrarySpace(spaces);
                    }
                } else {
                    finalFrontier = this.getArbitrarySpace(spaces);
                }
                this.target.setSpace(finalFrontier);
            } else {
                Space finalFrontier = this.getSpace(spaces, this.space);
                this.target.setSpace(finalFrontier);
            }
            if (this.target.getSpace() == null) {
                return new ServerStatus(4, 404, "Space not found", null);
            }
            return new ServerStatus(Status.OK_STATUS, 200, this.target.getSpace().toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

