/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.loggregator;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.orion.server.cf.loggregator.LoggregatorMessage;
import org.json.JSONArray;

public class LoggregatorListener {
    private SortedSet<LoggregatorMessage.Message> messages;
    private long lastAccess;

    public void add(LoggregatorMessage.Message msg) {
        if (this.messages == null) {
            Comparator<LoggregatorMessage.Message> comparator = new Comparator<LoggregatorMessage.Message>(){

                @Override
                public int compare(LoggregatorMessage.Message o1, LoggregatorMessage.Message o2) {
                    if (o1.getTimestamp() < o2.getTimestamp()) {
                        return -1;
                    }
                    if (o1.getTimestamp() > o2.getTimestamp()) {
                        return 1;
                    }
                    return 0;
                }
            };
            this.messages = new TreeSet<LoggregatorMessage.Message>(comparator);
        }
        this.messages.add(msg);
        this.lastAccess = System.currentTimeMillis();
    }

    public long getLastTimestamp() {
        if (this.messages != null) {
            return this.messages.last().getTimestamp();
        }
        return -1L;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public JSONArray getMessagesJSON(Long timestamp) {
        JSONArray messagesJSON = new JSONArray();
        if (this.messages != null) {
            for (LoggregatorMessage.Message loggregatorMessage : this.messages) {
                if (timestamp != -1L && loggregatorMessage.getTimestamp() <= timestamp) continue;
                String message = loggregatorMessage.getMessage().toStringUtf8();
                messagesJSON.put((Object)message);
            }
        }
        this.lastAccess = System.currentTimeMillis();
        return messagesJSON;
    }

    public String getString(Long timestamp) {
        StringBuffer buff = new StringBuffer();
        if (this.messages != null) {
            for (LoggregatorMessage.Message loggregatorMessage : this.messages) {
                if (timestamp != -1L && loggregatorMessage.getTimestamp() <= timestamp) continue;
                String message = loggregatorMessage.getMessage().toStringUtf8();
                buff.append(message).append("\n");
            }
        }
        this.lastAccess = System.currentTimeMillis();
        return buff.toString();
    }
}

