/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.orion.server.cf.manifest.v2.Analyzer;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;

public class ManifestTransformator
implements Analyzer {
    private void populate(ManifestParseTree application, List<ManifestParseTree> globals) {
        for (ManifestParseTree property : globals) {
            if (application.has(property.getLabel())) continue;
            application.getChildren().add(property);
        }
    }

    @Override
    public void apply(ManifestParseTree node) throws AnalyzerException {
        ManifestParseTree applications = node.getOpt("applications");
        if (applications == null) {
            return;
        }
        LinkedList<ManifestParseTree> globals = new LinkedList<ManifestParseTree>();
        for (ManifestParseTree property : node.getChildren()) {
            if (!ManifestUtils.isApplicationProperty(property)) continue;
            globals.add(property);
        }
        if (globals.isEmpty()) {
            return;
        }
        for (ManifestParseTree application : applications.getChildren()) {
            this.populate(application, globals);
        }
    }
}

