/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.xfer.ContentRange;
import org.eclipse.orion.internal.server.servlets.xfer.ImportStream;
import org.eclipse.orion.internal.server.servlets.xfer.TransferServlet;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.FrameworkUtil;

class ClientImport {
    private static final String FILE_DATA = "xfer.data";
    private static final String FILE_INDEX = "xfer.properties";
    private static final String KEY_FILE_NAME = "FileName";
    private static final String KEY_LENGTH = "Length";
    private static final String KEY_OPTIONS = "Options";
    private static final String KEY_PATH = "Path";
    private static final String KEY_TRANSFERRED = "Transferred";
    private static final String KEY_SOURCE_URL = "SourceURL";
    private final String id;
    private Properties props = new Properties();
    private final ServletResourceHandler<IStatus> statusHandler;

    ClientImport(String id, ServletResourceHandler<IStatus> servletResourceHandler) throws IOException {
        this.id = id;
        this.statusHandler = servletResourceHandler;
        this.restore();
    }

    private boolean completeMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String msg;
        IFileStore destination;
        IFileStore source;
        IPath destPath;
        boolean override;
        block4: {
            List<String> options = this.getOptions();
            override = options.contains("overwrite-older");
            destPath = new Path(this.getPath()).append(this.getFileName());
            source = EFS.getStore((URI)new File(this.getStorageDirectory(), FILE_DATA).toURI());
            destination = NewFileServlet.getFileStore(req, destPath);
            if (override || !destination.fetchInfo().exists()) break block4;
            String msg2 = NLS.bind((String)"Failed to complete file transfer on {0}. The file could not be overwritten.", (Object)destPath.toString());
            JSONObject jsonData = new JSONObject();
            jsonData.put("ExistingFiles", (Object)this.getFileName());
            this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, msg2, jsonData, null));
            return false;
        }
        try {
            source.move(destination, override ? 2 : 0, null);
        }
        catch (CoreException e) {
            msg = NLS.bind((String)"Failed to complete file transfer on {0}", (Object)destPath.toString());
            this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
            return false;
        }
        catch (JSONException e) {
            msg = NLS.bind((String)"Failed to complete file transfer on {0}", (Object)destPath.toString());
            this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
            return false;
        }
        return true;
    }

    private void completeTransfer(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List<String> options = this.getOptions();
        boolean success = !options.contains("raw") ? this.completeUnzip(req, resp) : this.completeMove(req, resp);
        this.removeTempFiles();
        if (success) {
            resp.setHeader("Location", String.valueOf(req.getContextPath()) + "/file" + this.getPath());
            resp.setStatus(201);
            resp.setContentType("text/html;charset=UTF-8");
        }
    }

    private static boolean hasExcludedParent(IFileStore destination, IFileStore destinationRoot, List<String> excludedFiles) {
        if (destination.equals(destinationRoot)) {
            return false;
        }
        if (excludedFiles.contains(destination.getName())) {
            return true;
        }
        return ClientImport.hasExcludedParent(destination.getParent(), destinationRoot, excludedFiles);
    }

    private boolean completeUnzip(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        IFileStore destinationRoot;
        IFileStore dotGitStorage;
        Path destPath = new Path(this.getPath());
        List<String> options = this.getOptions();
        boolean force = options.contains("overwrite-older");
        ArrayList<String> filesFailed = new ArrayList<String>();
        List<Object> excludedFiles = new ArrayList();
        if (req.getParameter("exclude") != null) {
            excludedFiles = Arrays.asList(req.getParameter("exclude").split(","));
        }
        if ((dotGitStorage = (destinationRoot = NewFileServlet.getFileStore(req, (IPath)destPath)).getChild(".git")).fetchInfo().exists()) {
            excludedFiles.add(".git");
        }
        try {
            ZipFile source = new ZipFile(new File(this.getStorageDirectory(), FILE_DATA));
            Enumeration<? extends ZipEntry> entries = source.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                IFileStore destination = destinationRoot.getChild(entry.getName());
                if (!destinationRoot.isParentOf(destination) || ClientImport.hasExcludedParent(destination, destinationRoot, excludedFiles)) continue;
                if (entry.isDirectory()) {
                    destination.mkdir(0, null);
                    continue;
                }
                if (!force && destination.fetchInfo().exists()) {
                    filesFailed.add(entry.getName());
                    continue;
                }
                destination.getParent().mkdir(0, null);
                FilterInputStream maxBytesReadInputStream = new FilterInputStream(source.getInputStream(entry)){
                    private static final int maxBytes = 0xFF00000;
                    private int totalBytes;

                    private void addByteCount(int count) throws IOException {
                        this.totalBytes += count;
                        if (this.totalBytes > 0xFF00000) {
                            throw new IOException("Zip file entry too large");
                        }
                    }

                    @Override
                    public int read() throws IOException {
                        int c = super.read();
                        if (c != -1) {
                            this.addByteCount(1);
                        }
                        return c;
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        int read = super.read(b, off, len);
                        if (read != -1) {
                            this.addByteCount(read);
                        }
                        return read;
                    }
                };
                boolean fileWritten = false;
                try {
                    IOUtilities.pipe((InputStream)maxBytesReadInputStream, (OutputStream)destination.openOutputStream(0, null), (boolean)false, (boolean)true);
                    fileWritten = true;
                }
                catch (Throwable throwable) {
                    if (!fileWritten) {
                        try {
                            destination.delete(0, null);
                        }
                        catch (CoreException coreException) {}
                    }
                    throw throwable;
                }
                if (fileWritten) continue;
                try {
                    destination.delete(0, null);
                }
                catch (CoreException coreException) {}
            }
            source.close();
            if (!filesFailed.isEmpty()) {
                String failedFilesList = "";
                for (String file : filesFailed) {
                    if (failedFilesList.length() > 0) {
                        failedFilesList = String.valueOf(failedFilesList) + ", ";
                    }
                    failedFilesList = String.valueOf(failedFilesList) + file;
                }
                String msg = NLS.bind((String)"Failed to transfer all files to {0}, the following files could not be overwritten: {1}", (Object)destPath.toString(), (Object)failedFilesList);
                JSONObject jsonData = new JSONObject();
                jsonData.put("ExistingFiles", filesFailed);
                this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, msg, jsonData, null));
                return false;
            }
        }
        catch (ZipException e) {
            String msg = NLS.bind((String)"Failed to complete file transfer on {0}", (Object)destPath.toString());
            this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, msg, (Throwable)e));
            return false;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"Failed to complete file transfer on {0}", (Object)destPath.toString());
            this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
            return false;
        }
        return true;
    }

    void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.save();
        if (this.getSourceURL() != null) {
            this.doImportFromURL(req, resp);
            return;
        }
        if (req.getHeader("X-Xfer-Content-Length") == null) {
            this.doPut(req, resp);
            return;
        }
        resp.setStatus(200);
        this.setResponseLocationHeader(req, resp);
    }

    private void doImportFromURL(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        URL source = this.getSourceURL();
        IOUtilities.pipe((InputStream)source.openStream(), (OutputStream)new FileOutputStream(new File(this.getStorageDirectory(), FILE_DATA), true), (boolean)true, (boolean)true);
        this.completeTransfer(req, resp);
    }

    private void setResponseLocationHeader(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        URI responseURI;
        URI requestURI = ServletResourceHandler.getURI(req);
        String responsePath = "/" + new Path(requestURI.getPath()).segment(0) + "/import/" + this.id;
        try {
            responseURI = new URI(requestURI.getScheme(), requestURI.getAuthority(), responsePath, null, null);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        resp.setHeader("Location", ServletResourceHandler.resovleOrionURI(req, responseURI).toString());
    }

    void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ContentRange range;
        int transferred = this.getTransferred();
        int length = this.getLength();
        int chunkSize = 0;
        if (length == 0) {
            range = ContentRange.parse("bytes 0-0/0");
        } else {
            String rangeString = req.getHeader("Content-Range");
            if (rangeString == null) {
                rangeString = "bytes 0-" + (length - 1) + '/' + length;
            }
            if (length != (range = ContentRange.parse(rangeString)).getLength()) {
                this.fail(req, resp, "Chunk specifies an incorrect document length");
                return;
            }
            if (range.getStartByte() > transferred) {
                this.fail(req, resp, "Chunk missing; Expected start byte: " + transferred);
                return;
            }
            if (range.getEndByte() < range.getStartByte()) {
                this.fail(req, resp, "Invalid range: " + rangeString);
                return;
            }
            chunkSize = 1 + range.getEndByte() - range.getStartByte();
        }
        long piped = 0L;
        String contentType = req.getHeader("Content-Type");
        if (contentType != null && contentType.startsWith("multipart")) {
            int boundaryOff = contentType.indexOf("boundary=");
            if (boundaryOff < 0) {
                this.fail(req, resp, "Boundary parameter missing in Content-Type: " + contentType);
                return;
            }
            String boundary = contentType.substring(boundaryOff + 9);
            ImportStream in = new ImportStream((InputStream)req.getInputStream());
            piped = this.pipeMultiPartChunk(in, range.getStartByte(), chunkSize, boundary);
        } else {
            ImportStream in = new ImportStream((InputStream)req.getInputStream());
            piped = this.pipeChunk(in, range.getStartByte(), chunkSize, true);
        }
        if ((long)chunkSize != piped) {
            this.fail(req, resp, "Content-Range doesn't agree with actual content length");
            return;
        }
        transferred = range.getEndByte() + 1;
        this.setTransferred(transferred);
        this.save();
        if (transferred >= length) {
            this.completeTransfer(req, resp);
            return;
        }
        resp.setStatus(308);
        resp.setHeader("Range", "bytes 0-" + range.getEndByte());
        this.setResponseLocationHeader(req, resp);
    }

    private long pipeMultiPartChunk(ImportStream in, long position, int count, String boundary) throws IOException {
        try {
            String delimiter = "--" + boundary;
            String line = in.readLine();
            while (!delimiter.equals(line)) {
                line = in.readLine();
            }
            while (!"\r\n".equals(line)) {
                line = in.readLine();
            }
            long piped = this.pipeChunk(in, position, count, false);
            line = in.readLine();
            if ("\r\n".equals(line) && (line = in.readLine()).startsWith(delimiter)) {
                long l = piped;
                return l;
            }
        }
        finally {
            in.skipAll();
        }
        return in.count();
    }

    private long pipeChunk(ImportStream in, long position, int count, boolean skipIn) throws IOException {
        FileOutputStream fout = null;
        FileChannel channel = null;
        try {
            in.resetCount();
            fout = new FileOutputStream(new File(this.getStorageDirectory(), FILE_DATA), true);
            channel = fout.getChannel();
            channel.transferFrom(Channels.newChannel(in), position, count);
            if (skipIn) {
                in.skipAll();
            }
        }
        catch (Throwable throwable) {
            IOUtilities.safeClose(channel);
            IOUtilities.safeClose(fout);
            throw throwable;
        }
        IOUtilities.safeClose((Closeable)channel);
        IOUtilities.safeClose((Closeable)fout);
        return in.count();
    }

    private void fail(HttpServletRequest req, HttpServletResponse resp, String msg) throws ServletException {
        this.statusHandler.handleRequest(req, resp, (IStatus)new ServerStatus(4, 400, msg, null));
    }

    private String getFileName() {
        return this.props.getProperty(KEY_FILE_NAME, "");
    }

    private int getLength() {
        return Integer.valueOf(this.props.getProperty(KEY_LENGTH, "0"));
    }

    private List<String> getOptions() {
        return TransferServlet.getOptions(this.props.getProperty(KEY_OPTIONS, ""));
    }

    private String getPath() {
        return this.props.getProperty(KEY_PATH, "");
    }

    private URL getSourceURL() {
        String urlString = this.props.getProperty(KEY_SOURCE_URL, null);
        try {
            return urlString == null ? null : new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private File getStorageDirectory() {
        return FrameworkUtil.getBundle(ClientImport.class).getDataFile("xfer/" + this.id);
    }

    private Integer getTransferred() {
        return Integer.valueOf(this.props.getProperty(KEY_TRANSFERRED, "0"));
    }

    void restore() throws IOException {
        try {
            File dir = this.getStorageDirectory();
            File index = new File(dir, FILE_INDEX);
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(index);
                this.props.load(inStream);
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    void save() throws IOException {
        File dir = this.getStorageDirectory();
        dir.mkdirs();
        File index = new File(dir, FILE_INDEX);
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(index);
            this.props.store(outStream, null);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    private void removeTempFiles() {
        File dir = this.getStorageDirectory();
        File index = new File(dir, FILE_INDEX);
        File data = new File(dir, FILE_DATA);
        data.delete();
        index.delete();
        dir.delete();
    }

    public void setFileName(String name) {
        this.props.put(KEY_FILE_NAME, name == null ? "" : name);
    }

    public void setLength(long length) {
        this.props.put(KEY_LENGTH, Long.toString(length));
    }

    public void setOptions(String options) {
        this.props.put(KEY_OPTIONS, options == null ? "" : options);
    }

    public void setPath(IPath path) {
        this.props.put(KEY_PATH, path.toString());
    }

    private void setTransferred(int transferred) {
        this.props.put(KEY_TRANSFERRED, Integer.toString(transferred));
    }

    public void setSourceURL(String urlString) throws MalformedURLException {
        if (new URL(urlString).getProtocol() == null) {
            throw new MalformedURLException(NLS.bind((String)"Expected an absolute URI: {0}", (Object)urlString));
        }
        this.props.put(KEY_SOURCE_URL, urlString);
    }
}

