/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.EncodingUtils;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitIgnoreHandlerV1
extends ServletResourceHandler<String> {
    private static final String DOT_GIT_IGNORE = ".gitignore";
    private ServletResourceHandler<IStatus> statusHandler;

    GitIgnoreHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws ServletException {
        Path filePath;
        block7: {
            try {
                Path path = pathInfo == null ? Path.ROOT : new Path(pathInfo);
                Object object = filePath = path.hasTrailingSeparator() ? path : path.removeLastSegments(1);
                if (!AuthorizationService.checkRights((String)request.getRemoteUser(), (String)("/" + filePath.toString()), (String)request.getMethod())) {
                    String msg = NLS.bind((String)"Forbidden: {0}", (Object)EncodingUtils.encodeForHTML((String)filePath.toString()));
                    ServerStatus status = new ServerStatus(4, 403, msg, null);
                    return this.statusHandler.handleRequest(request, response, (Object)status);
                }
                Set<Map.Entry<IPath, File>> set = GitUtils.getGitDirs((IPath)filePath, GitUtils.Traverse.GO_UP).entrySet();
                File gitDir = set.iterator().next().getValue();
                if (gitDir != null) break block7;
                return false;
            }
            catch (Exception e) {
                String msg = NLS.bind((String)"Failed to process an ignore operation for {0}", (Object)EncodingUtils.encodeForHTML((String)pathInfo));
                ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                LogHelper.log((IStatus)status);
                return this.statusHandler.handleRequest(request, response, (Object)status);
            }
        }
        switch (GitIgnoreHandlerV1.getMethod((HttpServletRequest)request)) {
            case PUT: {
                return this.handlePut(request, response, (IPath)filePath);
            }
        }
        return false;
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, IPath filePath) throws JSONException, IOException, ServletException, CoreException {
        JSONObject toIgnore = OrionServlet.readJSONRequest((HttpServletRequest)request);
        JSONArray paths = toIgnore.optJSONArray("Path");
        if (paths.length() < 1) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "No paths to insert into .gitignore", null));
        }
        IFileStore projectStore = NewFileServlet.getFileStore(null, (IPath)filePath.removeFirstSegments(1));
        int i = 0;
        while (i < paths.length()) {
            Path path = new Path(paths.getString(i));
            IFileStore pathStore = projectStore.getFileStore((IPath)path);
            IFileStore gitignoreStore = pathStore.getParent().getFileStore((IPath)new Path(DOT_GIT_IGNORE));
            if (!pathStore.fetchInfo().exists() || !projectStore.isParentOf(gitignoreStore)) {
                String msg = NLS.bind((String)"Invalid path: {0}", (Object)EncodingUtils.encodeForHTML((String)path.toString()));
                ServerStatus status = new ServerStatus(4, 400, msg, null);
                return this.statusHandler.handleRequest(request, response, (Object)status);
            }
            this.appendGitignore(gitignoreStore, pathStore.getName());
            ++i;
        }
        return true;
    }

    private void appendGitignore(IFileStore gitignoreStore, String rule) throws CoreException, IOException {
        OutputStream out = null;
        try {
            out = gitignoreStore.openOutputStream(1, null);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
            bw.write(String.valueOf(System.getProperty("line.separator")) + "/" + rule);
            bw.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

