/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugOptions;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDILambdaVariable;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIReturnValueVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIThisVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.core.model.LambdaUtils;
import org.eclipse.jdt.internal.debug.core.model.SyntheticVariableUtils;
import org.eclipse.jdt.internal.debug.eval.EvaluationResult;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTInstructionCompiler;
import org.eclipse.jdt.internal.debug.eval.ast.engine.AbstractRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ArrayRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.engine.EvaluationEngineMessages;
import org.eclipse.jdt.internal.debug.eval.ast.engine.EvaluationSourceGenerator;
import org.eclipse.jdt.internal.debug.eval.ast.engine.IRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.engine.Interpreter;
import org.eclipse.jdt.internal.debug.eval.ast.engine.JavaObjectRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.engine.RuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionSequence;

public class ASTEvaluationEngine
implements IAstEvaluationEngine {
    public static final String ANONYMOUS_VAR_PREFIX = "val$";
    private static final int EVALUATION_DETAIL_BITMASK = 192;
    private static final String QN_OBJECT = "java.lang.Object";
    private IJavaProject fProject;
    private IJavaDebugTarget fDebugTarget;
    private static Pattern fgThisPattern = Pattern.compile("(.*[^a-zA-Z0-9]+|^)(this)([^a-zA-Z0-9]+|$).*");

    public ASTEvaluationEngine(IJavaProject project, IJavaDebugTarget debugTarget) {
        this.setJavaProject(project);
        this.setDebugTarget(debugTarget);
    }

    public void setJavaProject(IJavaProject project) {
        this.fProject = project;
    }

    public void setDebugTarget(IJavaDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    @Override
    public void evaluate(String snippet, IJavaStackFrame frame, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        this.traceCaller(snippet, frame.getThread());
        ICompiledExpression expression = this.getCompiledExpression(snippet, frame);
        this.evaluateExpression(expression, frame, listener, evaluationDetail, hitBreakpoints);
    }

    @Override
    public void evaluate(String snippet, IJavaObject thisContext, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        this.traceCaller(snippet, thread);
        ICompiledExpression expression = this.getCompiledExpression(snippet, thisContext);
        this.evaluateExpression(expression, thisContext, thread, listener, evaluationDetail, hitBreakpoints);
    }

    private void traceCaller(String snippet, IThread thread) {
        if (JDIDebugOptions.DEBUG_AST_EVAL_THREAD_TRACE) {
            StringBuilder buf = new StringBuilder();
            buf.append(JDIDebugOptions.FORMAT.format(new Date()));
            buf.append(" : Evaluation Request Trace - Expression: ");
            buf.append(snippet);
            buf.append("\n\tThread: ");
            try {
                String name = thread.getName();
                buf.append('[');
                buf.append(name);
                buf.append("] ");
            }
            catch (DebugException debugException) {
                buf.append(thread.toString());
            }
            JDIDebugOptions.trace(buf.toString());
        }
    }

    @Override
    public void evaluateExpression(ICompiledExpression expression, IJavaStackFrame frame, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        this.traceCaller(expression.getSnippet(), frame.getThread());
        RuntimeContext context = new RuntimeContext(this.getJavaProject(), frame);
        this.doEvaluation(expression, context, (IJavaThread)frame.getThread(), listener, evaluationDetail, hitBreakpoints);
    }

    @Override
    public void evaluateExpression(ICompiledExpression expression, IJavaObject thisContext, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        this.traceCaller(expression.getSnippet(), thread);
        AbstractRuntimeContext context = null;
        context = thisContext instanceof IJavaArray ? new ArrayRuntimeContext((IJavaArray)thisContext, thread, this.getJavaProject()) : new JavaObjectRuntimeContext(thisContext, this.getJavaProject(), thread);
        this.doEvaluation(expression, context, thread, listener, evaluationDetail, hitBreakpoints);
    }

    private void doEvaluation(ICompiledExpression expression, IRuntimeContext context, IJavaThread thread, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        if (expression instanceof InstructionSequence) {
            if (thread.isSuspended() && ((JDIThread)thread).isInvokingMethod() || thread.isPerformingEvaluation() && evaluationDetail == 64) {
                EvaluationResult result = new EvaluationResult(this, expression.getSnippet(), thread);
                result.addError(EvaluationEngineMessages.ASTEvaluationEngine_Cannot_perform_nested_evaluations);
                listener.evaluationComplete(result);
                return;
            }
        } else {
            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, EvaluationEngineMessages.ASTEvaluationEngine_AST_evaluation_engine_cannot_evaluate_expression, null));
        }
        thread.queueRunnable(new EvalRunnable((InstructionSequence)expression, thread, context, listener, evaluationDetail, hitBreakpoints));
    }

    @Override
    public ICompiledExpression getCompiledExpression(String snippet, IJavaStackFrame frame) {
        IJavaProject javaProject = this.getJavaProject();
        RuntimeContext context = new RuntimeContext(javaProject, frame);
        EvaluationSourceGenerator mapper = null;
        CompilationUnit unit = null;
        try {
            String name;
            ArrayList<IJavaVariable> localsVar = new ArrayList<IJavaVariable>();
            localsVar.addAll(Arrays.asList(context.getLocals()));
            IJavaObject thisClass = context.getThis();
            IVariable[] innerClassFields = thisClass != null ? this.extractVariables(thisClass) : new IVariable[]{};
            List<IVariable> lambdaFrameVariables = LambdaUtils.getLambdaFrameVariables(frame);
            int numLocalsVar = localsVar.size();
            HashSet<String> names = new HashSet<String>();
            IJavaVariable[] locals = new IJavaVariable[numLocalsVar + innerClassFields.length + lambdaFrameVariables.size()];
            String[] localVariablesWithNull = new String[numLocalsVar + innerClassFields.length + lambdaFrameVariables.size()];
            int numLocals = 0;
            int i = 0;
            while (i < numLocalsVar) {
                IJavaVariable variable = (IJavaVariable)localsVar.get(i);
                if (!this.isLocalType(variable.getSignature()) && !names.contains(variable.getName())) {
                    locals[numLocals] = variable;
                    names.add(variable.getName());
                    localVariablesWithNull[numLocals++] = variable.getName();
                }
                ++i;
            }
            for (IVariable variable : lambdaFrameVariables) {
                String variableName;
                if (!(variable instanceof IJavaVariable) || ASTEvaluationEngine.isLambdaOrImplicitVariable(variable)) continue;
                IJavaVariable javaVariable = (IJavaVariable)variable;
                boolean lambdaField = LambdaUtils.isLambdaField(variable);
                name = variable.getName();
                String string = variableName = lambdaField && name.startsWith(ANONYMOUS_VAR_PREFIX) ? name.substring(ANONYMOUS_VAR_PREFIX.length()) : name;
                if (variableName == null || variableName.contains("$") && !lambdaField || this.isLocalType(javaVariable.getSignature()) || names.contains(variableName)) continue;
                locals[numLocals] = javaVariable;
                names.add(variableName);
                localVariablesWithNull[numLocals++] = variableName;
            }
            IVariable[] lambdaField = innerClassFields;
            int javaVariable = innerClassFields.length;
            int variable = 0;
            while (variable < javaVariable) {
                IVariable var = lambdaField[variable];
                if (var instanceof IJavaVariable && var.getName().startsWith(ANONYMOUS_VAR_PREFIX) && !names.contains(name = var.getName().substring(ANONYMOUS_VAR_PREFIX.length()))) {
                    locals[numLocals] = (IJavaVariable)var;
                    names.add(name);
                    localVariablesWithNull[numLocals++] = name;
                }
                ++variable;
            }
            String[] localTypesNames = new String[numLocals];
            int i2 = 0;
            while (i2 < numLocals) {
                localTypesNames[i2] = this.getFixedUnresolvableGenericTypes(locals[i2]);
                ++i2;
            }
            String[] localVariables = new String[names.size()];
            System.arraycopy(localVariablesWithNull, 0, localVariables, 0, localVariables.length);
            mapper = new EvaluationSourceGenerator(localTypesNames, localVariables, snippet, this.getJavaProject());
            IJavaReferenceType receivingType = frame.getReferenceType();
            Map<String, String> extraOptions = Collections.emptyMap();
            if (JavaCore.compareJavaVersions((String)((IJavaDebugTarget)frame.getDebugTarget()).getVersion(), (String)"1.8") > 0) {
                extraOptions = Collections.singletonMap("org.eclipse.jdt.internal.debug.compile.mode", "enabled");
            }
            unit = this.parseCompilationUnit(mapper.getSource(receivingType, frame.getLineNumber(), javaProject, frame.isStatic()).toCharArray(), mapper.getCompilationUnitName(), javaProject, extraOptions);
        }
        catch (CoreException e) {
            InstructionSequence expression = new InstructionSequence(snippet);
            expression.addError(e.getStatus().getMessage());
            return expression;
        }
        return this.createExpressionFromAST(snippet, mapper, unit);
    }

    private IVariable[] extractVariables(IJavaObject thisClass) throws DebugException {
        IVariable[] vars = thisClass.getVariables();
        ArrayList<IVariable> varList = new ArrayList<IVariable>(Arrays.asList(vars));
        varList.addAll(Arrays.asList(SyntheticVariableUtils.findSyntheticVariables(vars)));
        return varList.toArray(new IVariable[0]);
    }

    private String getFixedUnresolvableGenericTypes(IJavaVariable variable) throws DebugException {
        StringBuilder fixedSignature = new StringBuilder();
        this.scanAndFixSignature(variable.getGenericSignature(), Signature.toString((String)variable.getSignature()), fixedSignature);
        return fixedSignature.toString();
    }

    private void scanAndFixSignature(String genericSignature, String erasureSignature, StringBuilder fixedSignature) {
        if (genericSignature.startsWith(String.valueOf('T')) || genericSignature.startsWith(String.valueOf('!')) || genericSignature.startsWith(String.valueOf('-'))) {
            fixedSignature.append(this.toDotQualified(erasureSignature));
            return;
        }
        if (genericSignature.startsWith(String.valueOf('+'))) {
            fixedSignature.append(this.toDotQualified(Signature.toString((String)this.getUpperBoundTypeSignature(genericSignature))));
            return;
        }
        fixedSignature.append(this.toDotQualified(Signature.toString((String)Signature.getTypeErasure((String)genericSignature))));
        String[] typeArguments = Signature.getTypeArguments((String)genericSignature);
        if (typeArguments.length > 0) {
            if (typeArguments.length == 1 && (typeArguments[0].equals(String.valueOf('*')) || typeArguments[0].startsWith(String.valueOf(new char[]{'+', 'T'})))) {
                return;
            }
            fixedSignature.append('<');
            int i = 0;
            while (i < typeArguments.length) {
                if (i > 0) {
                    fixedSignature.append(',');
                }
                this.scanAndFixSignature(typeArguments[i], QN_OBJECT, fixedSignature);
                ++i;
            }
            fixedSignature.append('>');
        }
    }

    private String toDotQualified(String fqn) {
        return fqn.replace('/', '.');
    }

    private String getUpperBoundTypeSignature(String typeParamaterSignature) {
        return String.valueOf(this.getBoudTypeParameterSignature(typeParamaterSignature.toCharArray(), '+'));
    }

    private char[] getBoudTypeParameterSignature(char[] typeParamaterSignature, char boundType) {
        if (typeParamaterSignature.length < 2 || typeParamaterSignature[0] != boundType) {
            throw new IllegalArgumentException(Signature.toString((String)String.valueOf(typeParamaterSignature)));
        }
        return CharOperation.subarray((char[])typeParamaterSignature, (int)1, (int)typeParamaterSignature.length);
    }

    private CompilationUnit parseCompilationUnit(char[] source, String unitName, IJavaProject project) {
        return this.parseCompilationUnit(source, unitName, project, Collections.EMPTY_MAP);
    }

    private CompilationUnit parseCompilationUnit(char[] source, String unitName, IJavaProject project, Map<String, String> extraCompileOptions) {
        ASTParser parser = ASTParser.newParser((int)15);
        parser.setSource(source);
        parser.setUnitName(unitName);
        parser.setProject(project);
        parser.setResolveBindings(true);
        Map<String, String> options = EvaluationSourceGenerator.getCompilerOptions(project);
        options = new LinkedHashMap<String, String>(options);
        for (Map.Entry<String, String> extraCompileOption : extraCompileOptions.entrySet()) {
            options.put(extraCompileOption.getKey(), extraCompileOption.getValue());
        }
        parser.setCompilerOptions(options);
        return (CompilationUnit)parser.createAST(null);
    }

    private boolean isLocalType(String typeName) {
        StringTokenizer strTok = new StringTokenizer(typeName, "$");
        strTok.nextToken();
        while (strTok.hasMoreTokens()) {
            char char0 = strTok.nextToken().charAt(0);
            if ('0' > char0 || char0 > '9') continue;
            return true;
        }
        return false;
    }

    private ICompiledExpression getCompiledExpression(String snippet, IJavaArrayType arrayType) {
        CompilationUnit unit;
        EvaluationSourceGenerator mapper;
        block7: {
            mapper = null;
            unit = null;
            try {
                IJavaType[] javaTypes;
                IJavaProject javaProject = this.getJavaProject();
                String newSnippet = ASTEvaluationEngine.replaceThisReferences(snippet);
                int dimension = 1;
                IJavaType componentType = arrayType.getComponentType();
                while (componentType instanceof IJavaArrayType) {
                    componentType = ((IJavaArrayType)componentType).getComponentType();
                    ++dimension;
                }
                String recTypeName = QN_OBJECT;
                String typeName = arrayType.getName();
                if (componentType instanceof IJavaReferenceType) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(QN_OBJECT);
                    int i = 0;
                    while (i < dimension) {
                        buf.append("[]");
                        ++i;
                    }
                    typeName = buf.toString();
                }
                String[] localTypesNames = new String[]{typeName};
                String[] localVariables = new String[]{ArrayRuntimeContext.ARRAY_THIS_VARIABLE};
                mapper = new EvaluationSourceGenerator(localTypesNames, localVariables, newSnippet, this.getJavaProject());
                int index = typeName.indexOf(36);
                if (index >= 0) {
                    recTypeName = typeName.substring(0, index);
                }
                if ((javaTypes = this.getDebugTarget().getJavaTypes(recTypeName)).length > 0) {
                    IJavaReferenceType recType = (IJavaReferenceType)javaTypes[0];
                    unit = this.parseCompilationUnit(mapper.getSource(recType, -1, this.getJavaProject(), false).toCharArray(), mapper.getCompilationUnitName(), javaProject);
                    break block7;
                }
                Status status = new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 120, EvaluationEngineMessages.ASTEvaluationEngine_1, null);
                throw new CoreException((IStatus)status);
            }
            catch (CoreException e) {
                InstructionSequence expression = new InstructionSequence(snippet);
                expression.addError(e.getStatus().getMessage());
                return expression;
            }
        }
        return this.createExpressionFromAST(snippet, mapper, unit);
    }

    @Override
    public ICompiledExpression getCompiledExpression(String snippet, IJavaObject thisContext) {
        try {
            if (thisContext instanceof IJavaArray) {
                return this.getCompiledExpression(snippet, (IJavaArrayType)thisContext.getJavaType());
            }
            return this.getCompiledExpression(snippet, (IJavaReferenceType)thisContext.getJavaType());
        }
        catch (DebugException e) {
            InstructionSequence expression = new InstructionSequence(snippet);
            expression.addError(e.getStatus().getMessage());
            return expression;
        }
    }

    @Override
    public ICompiledExpression getCompiledExpression(String snippet, IJavaReferenceType type) {
        return this.getCompiledExpression(snippet, type, Collections.EMPTY_MAP);
    }

    @Override
    public ICompiledExpression getCompiledExpression(String snippet, IJavaReferenceType type, Map<String, String> compileOptions) {
        if (type instanceof IJavaArrayType) {
            return this.getCompiledExpression(snippet, (IJavaArrayType)type);
        }
        IJavaProject javaProject = this.getJavaProject();
        EvaluationSourceGenerator mapper = null;
        CompilationUnit unit = null;
        mapper = new EvaluationSourceGenerator(new String[0], new String[0], snippet, this.getJavaProject());
        try {
            unit = this.parseCompilationUnit(mapper.getSource(type, -1, javaProject, false).toCharArray(), mapper.getCompilationUnitName(), javaProject, compileOptions);
        }
        catch (CoreException e) {
            InstructionSequence expression = new InstructionSequence(snippet);
            expression.addError(e.getStatus().getMessage());
            return expression;
        }
        return this.createExpressionFromAST(snippet, mapper, unit);
    }

    private ICompiledExpression createExpressionFromAST(String snippet, EvaluationSourceGenerator mapper, CompilationUnit unit) {
        IProblem[] problems = unit.getProblems();
        if (problems.length != 0) {
            boolean snippetError = false;
            boolean runMethodError = false;
            InstructionSequence errorSequence = new InstructionSequence(snippet);
            int codeSnippetStart = mapper.getSnippetStart();
            int codeSnippetEnd = codeSnippetStart + mapper.getSnippet().length();
            int runMethodStart = mapper.getRunMethodStart();
            int runMethodEnd = runMethodStart + mapper.getRunMethodLength();
            IProblem[] iProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem = iProblemArray[n2];
                int errorOffset = problem.getSourceStart();
                int problemId = problem.getID();
                if (problemId == 0x1000144) {
                    errorSequence.addError(problem.getMessage());
                    snippetError = true;
                }
                if (problemId != 67108969 && problemId != 67108965 && problemId != 0x8000083 && problemId != 33554503 && problemId != 0x1000003 && problemId != 67109225 && problem.isError()) {
                    if (codeSnippetStart <= errorOffset && errorOffset <= codeSnippetEnd) {
                        errorSequence.addError(problem.getMessage());
                        snippetError = true;
                    } else if (runMethodStart <= errorOffset && errorOffset <= runMethodEnd) {
                        runMethodError = true;
                        DebugPlugin.log((IStatus)new Status(2, DebugPlugin.getUniqueIdentifier(), "Compile error during code evaluation: " + problem.getMessage()));
                    }
                }
                ++n2;
            }
            if (snippetError || runMethodError) {
                if (runMethodError) {
                    errorSequence.addError(EvaluationEngineMessages.ASTEvaluationEngine_Evaluations_must_contain_either_an_expression_or_a_block_of_well_formed_statements_1);
                }
                return errorSequence;
            }
        }
        ASTInstructionCompiler visitor = new ASTInstructionCompiler(mapper.getSnippetStart(), snippet, this.getJavaProject());
        unit.accept((ASTVisitor)visitor);
        return visitor.getInstructions();
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    @Override
    public IJavaDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    @Override
    public void dispose() {
    }

    public static String replaceThisReferences(String snippet) {
        StringBuilder updatedSnippet = new StringBuilder();
        Matcher matcher = fgThisPattern.matcher(snippet);
        int start = 0;
        while (matcher.find()) {
            int end = matcher.start(2);
            updatedSnippet.append(snippet.substring(start, end));
            updatedSnippet.append(ArrayRuntimeContext.ARRAY_THIS_VARIABLE);
            start = end + 4;
        }
        if (start < snippet.length()) {
            updatedSnippet.append(snippet.substring(start, snippet.length()));
        }
        return updatedSnippet.toString();
    }

    private static boolean isLambdaOrImplicitVariable(IVariable variable) {
        boolean isLambdaOrImplicitVariable = variable instanceof JDILambdaVariable || variable instanceof JDIReturnValueVariable || variable instanceof JDIThisVariable;
        return isLambdaOrImplicitVariable;
    }

    class EvalRunnable
    implements Runnable {
        private InstructionSequence fExpression;
        private IJavaThread fThread;
        private int fEvaluationDetail;
        private boolean fHitBreakpoints;
        private IRuntimeContext fContext;
        private IEvaluationListener fListener;
        private boolean fDisableGcOnResult;

        public EvalRunnable(InstructionSequence expression, IJavaThread thread, IRuntimeContext context, IEvaluationListener listener, int evaluationDetail, boolean hitBreakpoints) {
            this.fExpression = expression;
            this.fThread = thread;
            this.fContext = context;
            this.fListener = listener;
            this.fEvaluationDetail = evaluationDetail & 0xC0;
            this.fHitBreakpoints = hitBreakpoints;
            this.fDisableGcOnResult = (evaluationDetail & 0x100) != 0;
        }

        @Override
        public void run() {
            StringBuilder buf;
            if (JDIDebugOptions.DEBUG_AST_EVAL) {
                StringBuilder buf2 = new StringBuilder();
                buf2.append(JDIDebugOptions.FORMAT.format(new Date()));
                buf2.append(" : AST Evaluation");
                buf2.append("\n\tExpression: ");
                buf2.append(this.fExpression.getSnippet());
                buf2.append("\n\tThread: ");
                try {
                    String name = this.fThread.getName();
                    buf2.append('[');
                    buf2.append(name);
                    buf2.append("] ");
                }
                catch (DebugException debugException) {}
                buf2.append(this.fThread.toString());
                buf2.append("\n\tDetail: ");
                if (this.fEvaluationDetail == 64) {
                    buf2.append("EVALUATION");
                } else if (this.fEvaluationDetail == 128) {
                    buf2.append("EVALUATION_IMPLICIT");
                } else {
                    buf2.append(this.fEvaluationDetail);
                }
                buf2.append(" Hit Breakpoints: ");
                buf2.append(this.fHitBreakpoints);
                JDIDebugOptions.trace(buf2.toString());
            }
            EvaluationResult result = new EvaluationResult(ASTEvaluationEngine.this, this.fExpression.getSnippet(), this.fThread);
            if (this.fExpression.hasErrors()) {
                String[] errors;
                String[] stringArray = errors = this.fExpression.getErrorMessages();
                int n = errors.length;
                int n2 = 0;
                while (n2 < n) {
                    String error = stringArray[n2];
                    result.addError(error);
                    ++n2;
                }
                this.evaluationFinished(result);
                if (JDIDebugOptions.DEBUG_AST_EVAL) {
                    StringBuilder buf3 = new StringBuilder();
                    buf3.append("\tErrors: ");
                    int i = 0;
                    while (i < errors.length) {
                        if (i > 0) {
                            buf3.append('\n');
                        }
                        buf3.append("\t\t");
                        buf3.append(errors[i]);
                        ++i;
                    }
                    JDIDebugOptions.trace(buf3.toString());
                }
                return;
            }
            Interpreter interpreter = new Interpreter(this.fExpression, this.fContext);
            class EvaluationRunnable
            implements IEvaluationRunnable,
            ITerminate {
                CoreException fException;
                boolean fTerminated = false;
                private final /* synthetic */ Interpreter val$interpreter;

                EvaluationRunnable(Interpreter interpreter) {
                    this.val$interpreter = interpreter;
                }

                @Override
                public void run(IJavaThread jt, IProgressMonitor pm) {
                    EventFilter filter = new EventFilter();
                    try {
                        try {
                            DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)filter);
                            this.val$interpreter.execute(EvalRunnable.this.fDisableGcOnResult);
                        }
                        catch (CoreException exception) {
                            this.fException = exception;
                            if (EvalRunnable.this.fEvaluationDetail == 64 && exception.getStatus().getException() instanceof InvocationException) {
                                InvocationException invocationException = (InvocationException)exception.getStatus().getException();
                                ObjectReference exObject = invocationException.exception();
                                IJavaObject modelObject = (IJavaObject)((Object)JDIValue.createValue((JDIDebugTarget)ASTEvaluationEngine.this.getDebugTarget(), exObject));
                                try {
                                    modelObject.sendMessage("printStackTrace", "()V", null, jt, false);
                                }
                                catch (DebugException debugException) {}
                            }
                            DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)filter);
                        }
                    }
                    finally {
                        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)filter);
                    }
                }

                public void terminate() {
                    this.fTerminated = true;
                    this.val$interpreter.stop();
                }

                public boolean canTerminate() {
                    return true;
                }

                public boolean isTerminated() {
                    return false;
                }

                public CoreException getException() {
                    return this.fException;
                }
            }
            EvaluationRunnable er = new EvaluationRunnable(interpreter);
            Throwable exception = null;
            long start = System.currentTimeMillis();
            try {
                this.fThread.runEvaluation(er, null, this.fEvaluationDetail, this.fHitBreakpoints);
            }
            catch (DebugException e) {
                exception = e;
            }
            long end = System.currentTimeMillis();
            IJavaValue value = interpreter.getResult();
            if (exception == null) {
                exception = er.getException();
            }
            result.setTerminated(er.fTerminated);
            if (exception != null) {
                if (JDIDebugOptions.DEBUG_AST_EVAL) {
                    buf = new StringBuilder();
                    buf.append("\tException: ");
                    buf.append(exception.toString());
                    JDIDebugOptions.trace(buf.toString());
                }
                if (exception instanceof DebugException) {
                    result.setException((DebugException)exception);
                } else {
                    result.setException(new DebugException(exception.getStatus()));
                }
            } else if (value != null) {
                result.setValue(value);
                if (JDIDebugOptions.DEBUG_AST_EVAL) {
                    buf = new StringBuilder();
                    buf.append("\tResult: ");
                    buf.append(value);
                    JDIDebugOptions.trace(buf.toString());
                }
            } else {
                result.addError(EvaluationEngineMessages.ASTEvaluationEngine_An_unknown_error_occurred_during_evaluation);
            }
            if (JDIDebugOptions.DEBUG_AST_EVAL) {
                buf = new StringBuilder();
                buf.append("\tDuration: ");
                buf.append(end - start);
                buf.append("ms");
                JDIDebugOptions.trace(buf.toString());
            }
            this.evaluationFinished(result);
        }

        private void evaluationFinished(IEvaluationResult result) {
            if (JDIDebugPlugin.getDefault() != null) {
                this.fListener.evaluationComplete(result);
            }
        }
    }

    class EventFilter
    implements IDebugEventFilter {
        EventFilter() {
        }

        public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
            DebugEvent event;
            if (events.length == 1 && (event = events[0]).getSource() instanceof IJavaVariable && event.getKind() == 16 && ((IJavaVariable)event.getSource()).getDebugTarget().equals(ASTEvaluationEngine.this.getDebugTarget())) {
                return null;
            }
            return events;
        }
    }
}

