/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.debug.runtime;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.debug.Breakpoint;
import org.eclipse.rcptt.debug.BreakpointResource;
import org.eclipse.rcptt.debug.DebugContext;
import org.eclipse.rcptt.debug.DebugFactory;
import org.eclipse.rcptt.debug.Launch;
import org.eclipse.rcptt.debug.LaunchConfiguration;
import org.eclipse.rcptt.debug.LaunchType;
import org.eclipse.rcptt.debug.ListValue;
import org.eclipse.rcptt.debug.MapValue;
import org.eclipse.rcptt.debug.PrimitiveValue;
import org.eclipse.rcptt.debug.SetValue;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.ecl.impl.UIRunnable;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class DebugContextProcessor
implements IContextProcessor {
    public boolean isApplied(Context context) {
        return context instanceof DebugContext;
    }

    public void apply(Context ctx, BooleanSupplier isCancelled) throws CoreException {
        if (!(ctx instanceof DebugContext)) {
            return;
        }
        long stop = System.currentTimeMillis() + (long)TeslaLimits.getContextRunnableTimeout();
        final UIJobCollector collector = new UIJobCollector();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
        try {
            try {
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.enable();
                        return null;
                    }
                }, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
                DebugContext context = (DebugContext)ctx;
                if (context.isNoBreakpoints()) {
                    this.cleanBreakPoints();
                }
                if (context.isNoLaunches()) {
                    this.cleanLaunches(context.getLaunchExceptions(), Math.toIntExact(stop - System.currentTimeMillis()), isCancelled);
                }
                if (context.isNoLaunchShortcuts()) {
                    this.cleanLaunchShortcuts(context.getLaunchShortcutExceptions());
                }
                for (LaunchType modelType : context.getLaunchTypes()) {
                    for (LaunchConfiguration modelConf : modelType.getConfigurations()) {
                        assert (modelConf.getName() != null) : "Malfromed launch";
                    }
                }
                for (Launch modelLaunch : context.getLaunches()) {
                    assert (modelLaunch.getConfiguration().getName() != null) : "Malfromed launch";
                }
                this.applyLaunchConfigurations((EList<LaunchType>)context.getLaunchTypes());
                this.applyBreakpoints((List<BreakpointResource>)context.getBreakpointResources());
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.setNeedDisable();
                        return null;
                    }
                }, (int)Math.toIntExact(stop - System.currentTimeMillis()), (BooleanSupplier)isCancelled);
                collector.join(TeslaLimits.getContextJoinTimeout(), isCancelled);
                ContextHelper helper = new ContextHelper();
                helper.setFrom(context);
                helper.applyLaunches((Collection<Launch>)context.getLaunches());
            }
            catch (InterruptedException e) {
                throw new CoreException(RcpttPlugin.createStatus((String)"Launch context was interrupted", (Throwable)e));
            }
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
        }
    }

    private void applyLaunchConfigurations(EList<LaunchType> launchTypes) throws CoreException {
        for (LaunchType modelType : launchTypes) {
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(modelType.getId());
            if (type == null) {
                throw new CoreException(this.createError("Launch configuration type " + modelType.getId() + " is not installed."));
            }
            for (LaunchConfiguration configuration : modelType.getConfigurations()) {
                this.applyLaunchConfiguration(type, configuration);
            }
        }
    }

    private IStatus createError(String message) {
        return new Status(4, "org.eclipse.rcptt.ctx.debug.impl", message);
    }

    private void cleanLaunches(final String exceptions, int timeout_ms, BooleanSupplier isCancelled) throws CoreException, InterruptedException {
        final MultiStatus result = new MultiStatus("org.eclipse.rcptt.ctx.debug.impl", 0, "Failed to remove launches", null);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Patterns patterns = new Patterns();
                patterns.setFromCommaSeparated(exceptions);
                ILaunchManager launches = DebugPlugin.getDefault().getLaunchManager();
                try {
                    long start = System.currentTimeMillis();
                    ArrayList toTerminate = Arrays.stream(launches.getLaunches()).filter(launch -> !patterns.matches(DebugContextProcessor.name(launch))).collect(Collectors.toCollection(ArrayList::new));
                    block4: while (!toTerminate.isEmpty() && !Thread.interrupted()) {
                        ILaunch[] iLaunchArray = toTerminate.toArray(new ILaunch[0]);
                        int n = iLaunchArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILaunch launch2 = iLaunchArray[n2];
                            if (launch2.isTerminated()) {
                                launches.removeLaunch(launch2);
                                toTerminate.remove(launch2);
                            } else {
                                try {
                                    launch2.terminate();
                                }
                                catch (DebugException e) {
                                    if (Thread.interrupted()) break block4;
                                    result.add((IStatus)DebugContextProcessor.this.warning(String.format("Failed to terminate %s in %d ms", DebugContextProcessor.name(launch2), System.currentTimeMillis() - start), (Exception)((Object)e)));
                                }
                            }
                            ++n2;
                        }
                    }
                    toTerminate.stream().filter(l -> !l.isTerminated()).map(DebugContextProcessor::access$0).forEach(name -> result.add((IStatus)DebugContextProcessor.this.error(String.format("Failed to terminate %s", name), new RuntimeException())));
                }
                catch (Exception e) {
                    result.add((IStatus)DebugContextProcessor.this.error("Termination failed", e));
                }
            }
        }, "Debug Context: Clean launches");
        t.start();
        long stop = System.currentTimeMillis() + (long)timeout_ms;
        try {
            while (t.isAlive()) {
                if (isCancelled.getAsBoolean()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                if (stop < System.currentTimeMillis()) {
                    t.interrupt();
                    t.join();
                    result.add((IStatus)this.error("Timeout", new RuntimeException()));
                    throw new CoreException((IStatus)result);
                }
                t.join(100L);
            }
        }
        finally {
            t.interrupt();
        }
        if (!result.isOK()) {
            throw new CoreException((IStatus)result);
        }
    }

    private static String name(ILaunch launch) {
        if (launch.getLaunchConfiguration() == null) {
            return "";
        }
        return launch.getLaunchConfiguration().getName();
    }

    private Status error(String message, Exception e) {
        return new Status(4, "org.eclipse.rcptt.ctx.debug.impl", message, (Throwable)e);
    }

    private Status warning(String message, Exception e) {
        return new Status(2, "org.eclipse.rcptt.ctx.debug.impl", message, (Throwable)e);
    }

    private static boolean isIgnored(String fileName, String[] ignoredPatterns) {
        if (ignoredPatterns == null) {
            return false;
        }
        String[] stringArray = ignoredPatterns;
        int n = ignoredPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            fileName = fileName.replace('\\', '/');
            String fileNameWithSlash = fileName + "/";
            if (fileName.matches(pattern) || fileNameWithSlash.matches(pattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void cleanLaunchShortcuts(final String exceptions) throws CoreException {
        final Exception[] resultE = new Exception[1];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Patterns exceptPatterns = new Patterns();
                exceptPatterns.setFromCommaSeparated(exceptions);
                ILaunchManager launches = DebugPlugin.getDefault().getLaunchManager();
                try {
                    ILaunchConfiguration[] configurations;
                    ILaunchConfiguration[] iLaunchConfigurationArray = configurations = launches.getLaunchConfigurations();
                    int n = configurations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile file;
                        ILaunchConfiguration cfg = iLaunchConfigurationArray[n2];
                        String name = cfg.getName();
                        if (!exceptPatterns.matches(name) && (file = cfg.getFile()) == null) {
                            cfg.delete();
                        }
                        ++n2;
                    }
                }
                catch (CoreException e1) {
                    resultE[0] = e1;
                }
            }
        }, "Debug Context: Clean launch shortcuts");
        t.start();
        try {
            t.join(TeslaLimits.getContextJoinTimeout());
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
        if (resultE[0] != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.debug.impl", resultE[0].getMessage(), (Throwable)resultE[0]));
        }
    }

    private void cleanBreakPoints() throws CoreException {
        final Exception[] resultE = new Exception[1];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                IBreakpointManager breakpoints = DebugPlugin.getDefault().getBreakpointManager();
                try {
                    breakpoints.removeBreakpoints(breakpoints.getBreakpoints(), true);
                }
                catch (Exception e) {
                    resultE[0] = e;
                }
            }
        }, "Debug Context: Clean breakpoints");
        t.start();
        try {
            t.join(TeslaLimits.getContextJoinTimeout());
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
        if (resultE[0] != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ctx.debug.impl", resultE[0].getMessage(), (Throwable)resultE[0]));
        }
    }

    public Context create(EObject param) throws CoreException {
        return (Context)UIRunnable.exec((UIRunnable)new UIRunnable<DebugContext>(){

            public DebugContext run() throws CoreException {
                return DebugContextProcessor.this.doCreate();
            }
        });
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private NamedElement box(String name, Object value) throws CoreException {
        if (value instanceof Map) {
            MapValue rv = DebugFactory.eINSTANCE.createMapValue();
            rv.setName(name);
            for (Map.Entry e : ((Map)value).entrySet()) {
                rv.getEntries().add((Object)this.box((String)e.getKey(), e.getValue()));
            }
            return rv;
        }
        if (value instanceof List) {
            ListValue rv = DebugFactory.eINSTANCE.createListValue();
            rv.setName(name);
            for (Object entry : (List)value) {
                rv.getEntries().add((Object)this.box("", entry));
            }
            return rv;
        }
        if (value instanceof Set) {
            SetValue rv = DebugFactory.eINSTANCE.createSetValue();
            rv.setName(name);
            for (Object entry : (Set)value) {
                rv.getEntries().add((Object)this.box("", entry));
            }
            return rv;
        }
        PrimitiveValue rv = DebugFactory.eINSTANCE.createPrimitiveValue();
        rv.setName(name);
        rv.setValue(BoxedValues.box((Object)value));
        return rv;
    }

    private Object unbox(NamedElement value) throws CoreException {
        if (value instanceof MapValue) {
            HashMap<String, String> rv = new HashMap<String, String>();
            for (NamedElement e : ((MapValue)value).getEntries()) {
                rv.put(e.getName(), (String)this.unbox(e));
            }
            return rv;
        }
        if (value instanceof SetValue) {
            HashSet<String> rv = new HashSet<String>();
            for (NamedElement e : ((SetValue)value).getEntries()) {
                rv.add((String)this.unbox(e));
            }
            return rv;
        }
        if (value instanceof ListValue) {
            ArrayList<String> rv = new ArrayList<String>();
            for (NamedElement e : ((ListValue)value).getEntries()) {
                rv.add((String)this.unbox(e));
            }
            return rv;
        }
        if (value instanceof PrimitiveValue) {
            Object rv = BoxedValues.unbox((Object)((PrimitiveValue)value).getValue());
            if (rv instanceof String) {
                rv = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution((String)rv, false);
            }
            return rv;
        }
        throw new IllegalArgumentException("Can't unbox " + value.getClass().getName());
    }

    private void removeEqualAttributes(EList<NamedElement> pattern, EList<NamedElement> cleaned) {
        ArrayList<NamedElement> toRemove = new ArrayList<NamedElement>();
        HashMap<String, NamedElement> patternMap = new HashMap<String, NamedElement>(pattern.size());
        for (NamedElement a : pattern) {
            patternMap.put(a.getName(), a);
        }
        Iterator iterator = cleaned.iterator();
        while (iterator.hasNext()) {
            NamedElement oldValue;
            EcoreUtil.EqualityHelper helper = new EcoreUtil.EqualityHelper();
            NamedElement e = (NamedElement)iterator.next();
            if (!helper.equals((EObject)e, (EObject)(oldValue = (NamedElement)patternMap.get(e.getName())))) continue;
            toRemove.add(e);
        }
        for (NamedElement key : toRemove) {
            cleaned.remove((Object)key);
        }
    }

    private ILaunchConfiguration launchConfigurationByName(String name) throws CoreException {
        ILaunchConfiguration[] iLaunchConfigurationArray = DebugContextProcessor.getLaunchManager().getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration conf = iLaunchConfigurationArray[n2];
            if (conf.getName().equals(name)) {
                return conf;
            }
            ++n2;
        }
        return null;
    }

    private static byte[] captureImage(Image image) {
        if (image == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save((OutputStream)stream, 5);
        return stream.toByteArray();
    }

    private void applyLaunchConfiguration(ILaunchConfigurationType type, LaunchConfiguration launch) throws CoreException {
        ILaunchConfiguration conf;
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        if (launch == null) {
            throw new NullPointerException("Null launch");
        }
        ILaunchManager manager = DebugContextProcessor.getLaunchManager();
        if (launch.getName() == null) {
            throw new IllegalArgumentException("Null launch name");
        }
        ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            conf = iLaunchConfigurationArray[n2];
            if (conf.getName().equals(launch.getName())) {
                conf.delete();
            }
            ++n2;
        }
        conf = type.newInstance(null, launch.getName());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (NamedElement e : launch.getAttributes()) {
            attributes.put(e.getName(), this.unbox(e));
        }
        conf.setAttributes(attributes);
        conf.doSave();
    }

    private Breakpoint captureBreakpoint(IBreakpoint breakpoint) throws CoreException {
        Breakpoint rv = DebugFactory.eINSTANCE.createBreakpoint();
        IMarker marker = breakpoint.getMarker();
        rv.setEnabled(breakpoint.isEnabled());
        rv.setRegistered(breakpoint.isRegistered());
        rv.setPersisted(breakpoint.isPersisted());
        rv.setType(marker.getType());
        Iterator iterator = marker.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry e = entry = iterator.next();
            String key = (String)e.getKey();
            Object value = e.getValue();
            rv.getAttributes().add((Object)this.box(key, value));
        }
        IWorkingSetManager mgr = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] sets = mgr.getWorkingSets();
        int i = 0;
        while (i < sets.length) {
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(sets[i].getId()) && this.containsBreakpoint(sets[i], breakpoint)) {
                rv.getWorkingSets().add((Object)sets[i].getName());
            }
            ++i;
        }
        return rv;
    }

    private void applyBreakpoints(List<BreakpointResource> list) throws CoreException {
        BreakpointManager manager = (BreakpointManager)DebugPlugin.getDefault().getBreakpointManager();
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        HashSet<String> pathSet = new HashSet<String>();
        for (BreakpointResource modelResource : list) {
            pathSet.add(modelResource.getPath());
        }
        IBreakpoint[] iBreakpointArray = manager.getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint existing = iBreakpointArray[n2];
            if (pathSet.contains(existing.getMarker().getResource().getFullPath().toPortableString())) {
                existing.delete();
            }
            ++n2;
        }
        for (BreakpointResource modelResource : list) {
            IResource resource = workspace.findMember(modelResource.getPath());
            if (resource == null) {
                throw new IllegalArgumentException("Can't find resource " + modelResource.getPath());
            }
            for (Breakpoint eobject : modelResource.getBreakpoints()) {
                if (eobject.getType() == null) {
                    throw new NullPointerException("Breakpoint has null marker type");
                }
                IMarker marker = resource.createMarker(eobject.getType());
                HashMap attributes = new HashMap();
                for (NamedElement e : eobject.getAttributes()) {
                    marker.setAttribute(e.getName(), this.unbox(e));
                }
                IBreakpoint breakpoint = manager.createBreakpoint(marker);
                breakpoint.setEnabled(eobject.isEnabled());
                breakpoint.setPersisted(eobject.isPersisted());
                breakpoint.setRegistered(false);
                breakpoint.setRegistered(eobject.isRegistered());
            }
        }
    }

    private boolean containsBreakpoint(IWorkingSet set, IBreakpoint breakpoint) {
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(breakpoint)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private DebugContext doCreate() throws CoreException {
        DebugContext context = DebugFactory.eINSTANCE.createDebugContext();
        DebugPlugin debug = DebugPlugin.getDefault();
        ContextHelper helper = new ContextHelper();
        ILaunchConfiguration[] iLaunchConfigurationArray = debug.getLaunchManager().getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            try {
                helper.captureLaunchConfiguration(configuration);
            }
            catch (Exception e) {
                RcpttPlugin.log((Throwable)e);
            }
            ++n2;
        }
        iLaunchConfigurationArray = debug.getBreakpointManager().getBreakpoints();
        n = iLaunchConfigurationArray.length;
        n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration breakpoint = iLaunchConfigurationArray[n2];
            BreakpointResource resource = null;
            for (BreakpointResource r : context.getBreakpointResources()) {
                if (!r.getPath().equals(breakpoint.getMarker().getResource().getFullPath().toPortableString())) continue;
                resource = r;
            }
            if (resource == null) {
                resource = DebugFactory.eINSTANCE.createBreakpointResource();
                resource.setPath(breakpoint.getMarker().getResource().getFullPath().toPortableString());
                context.getBreakpointResources().add((Object)resource);
            }
            try {
                resource.getBreakpoints().add((Object)this.captureBreakpoint((IBreakpoint)breakpoint));
            }
            catch (Exception e) {
                RcpttPlugin.log((Throwable)e);
            }
            ++n2;
        }
        context.getLaunches().addAll(helper.captureLaunches());
        helper.saveTo(context);
        return context;
    }

    static /* synthetic */ String access$0(ILaunch iLaunch) {
        return DebugContextProcessor.name(iLaunch);
    }

    private class ContextHelper {
        private final Map<String, LaunchType> types = new HashMap<String, LaunchType>();
        private final Map<String, LaunchConfiguration> configurations = new HashMap<String, LaunchConfiguration>();
        private final List<Launch> runningLaunches = new ArrayList<Launch>();
        public final DebugPlugin debug = DebugPlugin.getDefault();
        public final ILaunchManager launchManager = this.debug.getLaunchManager();

        private ContextHelper() {
        }

        void setFrom(DebugContext context) {
            for (LaunchType type : context.getLaunchTypes()) {
                this.types.put(type.getId(), type);
                for (LaunchConfiguration conf : type.getConfigurations()) {
                    conf.setTypeId(type.getId());
                    this.configurations.put(conf.getName(), conf);
                }
            }
        }

        public List<Launch> captureLaunches() throws CoreException {
            ILaunch[] launches = this.launchManager.getLaunches();
            ArrayList<Launch> rv = new ArrayList<Launch>(launches.length);
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                boolean terminated = true;
                IProcess[] iProcessArray = launch.getProcesses();
                int n3 = iProcessArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    if (!process.isTerminated()) {
                        terminated = false;
                        break;
                    }
                    ++n4;
                }
                if (!terminated) {
                    rv.add(this.captureLaunch(launch));
                }
                ++n2;
            }
            return rv;
        }

        private LaunchConfiguration getOrCapture(ILaunchConfiguration configuration) throws CoreException {
            LaunchConfiguration modelConfiguration = this.configurations.get(configuration.getName());
            if (modelConfiguration == null) {
                modelConfiguration = this.captureLaunchConfiguration(configuration);
            }
            return modelConfiguration;
        }

        private Launch captureLaunch(ILaunch launch) throws CoreException {
            if (launch.getLaunchConfiguration() == null) {
                throw new UnsupportedOperationException("Launches without configuration are not suppported");
            }
            LaunchConfiguration modelConfiguration = this.getOrCapture(launch.getLaunchConfiguration());
            LaunchType modelType = (LaunchType)modelConfiguration.eContainer();
            if (!modelType.getId().equals(launch.getLaunchConfiguration().getType().getIdentifier())) {
                throw new IllegalArgumentException("Launch type differs from the one stored in model");
            }
            LaunchConfiguration workingCopy = this.captureLaunchConfigurationRaw(launch.getLaunchConfiguration());
            DebugContextProcessor.this.removeEqualAttributes((EList<NamedElement>)modelConfiguration.getAttributes(), (EList<NamedElement>)workingCopy.getAttributes());
            Launch rv = DebugFactory.eINSTANCE.createLaunch();
            rv.setConfiguration(modelConfiguration);
            assert (rv.getConfiguration().getName() != null);
            rv.setConfigurationName(rv.getConfiguration().getName());
            rv.setMode(launch.getLaunchMode());
            rv.getConfigurationDelta().addAll((Collection)workingCopy.getAttributes());
            return rv;
        }

        public void applyLaunches(Collection<Launch> launches) throws CoreException {
            this.runningLaunches.clear();
            this.runningLaunches.addAll(this.captureLaunches());
            for (Launch modelLaunch : launches) {
                assert (modelLaunch.getConfiguration().getName() != null) : "Malfromed launch";
                this.applyLaunch(modelLaunch);
            }
        }

        private void applyLaunch(Launch modelLaunch) throws CoreException {
            ILaunchConfiguration configuration = DebugContextProcessor.this.launchConfigurationByName(modelLaunch.getConfiguration().getName());
            Iterator<Launch> iterator = this.runningLaunches.iterator();
            while (iterator.hasNext()) {
                EcoreUtil.EqualityHelper helper = new EcoreUtil.EqualityHelper();
                Launch running = iterator.next();
                if (!helper.equals((EObject)running, (EObject)modelLaunch)) continue;
                return;
            }
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            Map attributes = workingCopy.getAttributes();
            for (NamedElement e : modelLaunch.getConfigurationDelta()) {
                attributes.put(e.getName(), DebugContextProcessor.this.unbox(e));
            }
            workingCopy.setAttributes(attributes);
            workingCopy.launch(modelLaunch.getMode(), (IProgressMonitor)new NullProgressMonitor());
        }

        private LaunchType getOrCapture(ILaunchConfigurationType type) {
            LaunchType rv = this.types.get(type.getIdentifier());
            if (rv == null) {
                rv = this.captureLaunchType(type);
            }
            return rv;
        }

        private LaunchType captureLaunchType(ILaunchConfigurationType type) {
            LaunchType etype = DebugFactory.eINSTANCE.createLaunchType();
            etype.setId(type.getIdentifier());
            etype.setName(type.getName());
            Image image = DebugUITools.getImage((String)type.getIdentifier());
            etype.setImage(DebugContextProcessor.captureImage(image));
            this.types.put(etype.getId(), etype);
            return etype;
        }

        private LaunchConfiguration captureLaunchConfigurationRaw(ILaunchConfiguration configuration) throws CoreException {
            LaunchConfiguration rv = DebugFactory.eINSTANCE.createLaunchConfiguration();
            rv.setName(configuration.getName());
            rv.setTypeId(configuration.getType().getIdentifier());
            Map capturedAttributes = configuration.getAttributes();
            for (Map.Entry e : capturedAttributes.entrySet()) {
                String name = (String)e.getKey();
                Object value = e.getValue();
                rv.getAttributes().add((Object)DebugContextProcessor.this.box(name, value));
            }
            return rv;
        }

        private LaunchConfiguration captureLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
            LaunchConfiguration rv = this.captureLaunchConfigurationRaw(configuration);
            this.getOrCapture(configuration.getType()).getConfigurations().add((Object)rv);
            this.configurations.put(rv.getName(), rv);
            return rv;
        }

        public void saveTo(DebugContext context) {
            context.getLaunchTypes().addAll(this.types.values());
        }
    }

    static class Patterns {
        ArrayList<Pattern> payload = new ArrayList();

        Patterns() {
        }

        public static Pattern compile(String simplePattern) {
            return Pattern.compile(simplePattern.replace('\\', '/').replace("*", ".*").trim());
        }

        void setFromCommaSeparated(String commaSeparatedPatterns) {
            if (commaSeparatedPatterns == null) {
                return;
            }
            String[] stringArray = commaSeparatedPatterns.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String simplePattern = stringArray[n2];
                this.payload.add(Patterns.compile(simplePattern));
                ++n2;
            }
        }

        boolean matches(String data) {
            for (Pattern pattern : this.payload) {
                if (!pattern.matcher(data).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

