/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ComponentTemporalAmount
implements TemporalAmount {
    private final Map<? extends TemporalUnit, Long> components;
    private final List<TemporalUnit> units;

    ComponentTemporalAmount(Map<? extends TemporalUnit, Long> components) {
        this.components = components;
        this.units = Collections.unmodifiableList(components.keySet().stream().sorted(Comparator.comparing(TemporalUnit::getDuration).reversed()).collect(Collectors.toList()));
    }

    @Override
    public long get(TemporalUnit unit) {
        return this.components.getOrDefault(unit, 0L);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return this.units;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Temporal value = temporal;
        for (Map.Entry<? extends TemporalUnit, Long> component : this.components.entrySet()) {
            value = value.plus(component.getValue(), component.getKey());
        }
        return value;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Temporal value = temporal;
        for (Map.Entry<? extends TemporalUnit, Long> component : this.components.entrySet()) {
            value = value.minus(component.getValue(), component.getKey());
        }
        return value;
    }
}

