/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;

public class ProjectionElem
extends AbstractQueryModelNode {
    private static final long serialVersionUID = -8129811335486478066L;
    private String name;
    private String projectionAlias;
    private boolean aggregateOperatorInExpression;
    private ExtensionElem sourceExpression;

    public ProjectionElem() {
    }

    public ProjectionElem(String name) {
        this(name, null);
    }

    public ProjectionElem(String name, String targetName) {
        this.setName(name);
        this.setProjectionAlias(targetName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public Optional<String> getProjectionAlias() {
        return Optional.ofNullable(this.projectionAlias);
    }

    public void setProjectionAlias(String alias) {
        this.projectionAlias = alias;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        throw new IllegalArgumentException("Node is not a child node: " + current);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(super.getSignature());
        sb.append(" \"");
        sb.append(this.name);
        sb.append("\"");
        if (this.projectionAlias != null) {
            sb.append(" AS \"").append(this.projectionAlias).append("\"");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ProjectionElem) {
            ProjectionElem o = (ProjectionElem)other;
            return this.name.equals(o.getName()) && Objects.equals(this.getProjectionAlias(), o.getProjectionAlias());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.projectionAlias);
    }

    @Override
    public ProjectionElem clone() {
        return (ProjectionElem)super.clone();
    }

    public boolean hasAggregateOperatorInExpression() {
        return this.aggregateOperatorInExpression;
    }

    public void setAggregateOperatorInExpression(boolean aggregateOperatorInExpression) {
        this.aggregateOperatorInExpression = aggregateOperatorInExpression;
    }

    public ExtensionElem getSourceExpression() {
        return this.sourceExpression;
    }

    public void setSourceExpression(ExtensionElem sourceExpression) {
        this.sourceExpression = sourceExpression;
    }
}

