/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.helpers.collectors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;

public class StatementPatternCollector
extends AbstractSimpleQueryModelVisitor<RuntimeException> {
    private final List<StatementPattern> statementPatterns = new ArrayList<StatementPattern>();

    public StatementPatternCollector() {
        super(true);
    }

    public static List<StatementPattern> process(QueryModelNode node) {
        StatementPatternCollector collector = new StatementPatternCollector();
        node.visit(collector);
        return collector.getStatementPatterns();
    }

    public List<StatementPattern> getStatementPatterns() {
        return this.statementPatterns;
    }

    @Override
    public void meet(Filter node) {
        node.getArg().visit(this);
    }

    @Override
    public void meet(Join node) throws RuntimeException {
        if (!(node.getLeftArg() instanceof Join) && !(node.getRightArg() instanceof Join)) {
            super.meet(node);
            return;
        }
        ArrayDeque<TupleExpr> stack = new ArrayDeque<TupleExpr>();
        TupleExpr current = node;
        while (true) {
            if (current instanceof Join) {
                Join join = current;
                stack.push(join.getRightArg());
                current = join.getLeftArg();
                continue;
            }
            current.visit(this);
            if (stack.isEmpty()) {
                return;
            }
            current = (TupleExpr)stack.pop();
        }
    }

    @Override
    public void meet(StatementPattern node) {
        this.statementPatterns.add(node);
    }
}

