/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.config;

import java.util.Optional;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailConfigSchema;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.config.SailRegistry;

public class SailConfigUtil {
    public static SailImplConfig parseRepositoryImpl(Model m, Resource implNode) throws SailConfigException {
        try {
            Optional<Literal> typeLit = Configurations.getLiteralValue(m, implNode, CONFIG.Sail.type, SailConfigSchema.SAILTYPE);
            if (typeLit.isPresent()) {
                Optional factory = SailRegistry.getInstance().get(typeLit.get().getLabel());
                if (factory.isPresent()) {
                    SailImplConfig implConfig = ((SailFactory)factory.get()).getConfig();
                    implConfig.parse(m, implNode);
                    return implConfig;
                }
                throw new SailConfigException("Unsupported Sail type: " + typeLit.get().getLabel());
            }
            return null;
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

