/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.InterruptTask;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeLimitIteration<E>
extends IterationWrapper<E> {
    private static final Timer timer = new Timer("TimeLimitIteration", true);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InterruptTask<E> interruptTask;
    private final AtomicBoolean isInterrupted = new AtomicBoolean(false);

    protected TimeLimitIteration(CloseableIteration<? extends E> iter, long timeLimit) {
        super(iter);
        assert (timeLimit > 0L) : "time limit must be a positive number, is: " + timeLimit;
        this.interruptTask = new InterruptTask(this);
        timer.schedule(this.interruptTask, timeLimit);
    }

    @Override
    public boolean hasNext() {
        this.checkInterrupted();
        if (this.isClosed()) {
            return false;
        }
        this.checkInterrupted();
        try {
            boolean result = super.hasNext();
            this.checkInterrupted();
            return result;
        }
        catch (NoSuchElementException e) {
            this.checkInterrupted();
            this.close();
            throw e;
        }
    }

    @Override
    public E next() {
        this.checkInterrupted();
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        this.checkInterrupted();
        try {
            return super.next();
        }
        catch (NoSuchElementException e) {
            this.checkInterrupted();
            this.close();
            throw e;
        }
    }

    @Override
    public void remove() {
        this.checkInterrupted();
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        this.checkInterrupted();
        try {
            super.remove();
        }
        catch (IllegalStateException e) {
            this.checkInterrupted();
            this.close();
            throw e;
        }
    }

    @Override
    protected void handleClose() {
        try {
            this.interruptTask.cancel();
        }
        finally {
            super.handleClose();
        }
    }

    private void checkInterrupted() {
        if (this.isInterrupted.get()) {
            try {
                this.throwInterruptedException();
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.logger.warn("TimeLimitIteration timed out and failed to close successfully: ", (Throwable)e);
                }
            }
        }
    }

    protected abstract void throwInterruptedException();

    void interrupt() {
        this.isInterrupted.set(true);
        try {
            this.close();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.logger.warn("TimeLimitIteration timed out and failed to close successfully: ", (Throwable)e);
        }
    }
}

