/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.PersistentSet;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBStat;

class PersistentSetFactory<T extends Serializable> {
    final long env;
    private final Path dbDir;
    TxnManager txnManager;
    long writeTxn;
    PointerBuffer writeTxnPp = PointerBuffer.allocateDirect((int)1);
    private int defaultDbi;
    private long mapSize = 0x100000L;
    private long pageSize;

    PersistentSetFactory(File cacheDir) throws IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_env_create((PointerBuffer)pp));
            this.env = pp.get(0);
            this.txnManager = new TxnManager(this.env, TxnManager.Mode.ABORT);
            LmdbUtil.E(LMDB.mdb_env_set_maxdbs((long)this.env, (int)2));
            LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
            int flags = 0x250000;
            this.dbDir = Files.createTempDirectory(cacheDir.toPath(), "set", new FileAttribute[0]);
            LmdbUtil.E(LMDB.mdb_env_open((long)this.env, (CharSequence)this.dbDir.toAbsolutePath().toString(), (int)flags, (int)436));
            this.defaultDbi = LmdbUtil.openDatabase(this.env, null, 262144, null);
            MDBStat stat = MDBStat.malloc((MemoryStack)stack);
            LmdbUtil.readTransaction(this.env, (stack2, txn) -> {
                LmdbUtil.E(LMDB.mdb_stat((long)txn, (int)this.defaultDbi, (MDBStat)stat));
                this.pageSize = stat.ms_psize();
                return null;
            });
        }
    }

    public synchronized void close() throws IOException {
        if (this.writeTxn != 0L) {
            LMDB.mdb_txn_abort((long)this.writeTxn);
            this.writeTxn = 0L;
        }
        LMDB.mdb_env_close((long)this.env);
        FileUtils.deleteDirectory((File)this.dbDir.toFile());
    }

    synchronized void commit() throws IOException {
        if (this.writeTxn != 0L) {
            LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
            this.writeTxn = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureResize() throws IOException {
        if (LmdbUtil.requiresResize(this.mapSize, this.pageSize, this.writeTxn, 0L)) {
            StampedLock lock = this.txnManager.lock();
            long stamp = lock.writeLock();
            try {
                this.txnManager.deactivate();
                LmdbUtil.E(LMDB.mdb_txn_commit((long)this.writeTxn));
                this.mapSize = LmdbUtil.autoGrowMapSize(this.mapSize, this.pageSize, 0L);
                LmdbUtil.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)this.mapSize));
                LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)0, (PointerBuffer)this.writeTxnPp));
                this.writeTxn = this.writeTxnPp.get(0);
            }
            finally {
                try {
                    this.txnManager.activate();
                }
                finally {
                    lock.unlockWrite(stamp);
                }
            }
        }
    }

    PersistentSet<T> createSet(String name, final Function<T, byte[]> writeFunc, final Function<ByteBuffer, T> readFunc) throws IOException {
        int dbi = LmdbUtil.openDatabase(this.env, name, 262144, null);
        return new PersistentSet<T>(this, dbi){

            @Override
            protected byte[] write(T element) throws IOException {
                try {
                    return (byte[])writeFunc.apply(element);
                }
                catch (UncheckedIOException ioe) {
                    throw ioe.getCause();
                }
            }

            @Override
            protected T read(ByteBuffer buffer) throws IOException {
                try {
                    return (Serializable)readFunc.apply(buffer);
                }
                catch (UncheckedIOException ioe) {
                    throw ioe.getCause();
                }
            }
        };
    }
}

