/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.model.CorruptValue;

public class CorruptLiteral
extends CorruptValue
implements Literal {
    private static final long serialVersionUID = -2510885288827542623L;
    private static final IRI CORRUPT = Values.iri("urn:corrupt");

    public CorruptLiteral(ValueStoreRevision revision, int internalID, byte[] data) {
        super(revision, internalID, data);
    }

    @Override
    public String stringValue() {
        return "CorruptLiteral_with_ID_" + this.getInternalID();
    }

    @Override
    public String getLabel() {
        byte[] data = this.getData();
        try {
            if (data != null && data.length < 1024) {
                return "CorruptUnknownValue with ID " + this.getInternalID() + " with possible data: " + new String(data, StandardCharsets.UTF_8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "CorruptUnknownValue_with_ID_" + this.getInternalID();
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.empty();
    }

    @Override
    public IRI getDatatype() {
        return CORRUPT;
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public byte byteValue() {
        return 0;
    }

    @Override
    public short shortValue() {
        return 0;
    }

    @Override
    public int intValue() {
        return 0;
    }

    @Override
    public long longValue() {
        return 0L;
    }

    @Override
    public BigInteger integerValue() {
        return null;
    }

    @Override
    public BigDecimal decimalValue() {
        return null;
    }

    @Override
    public float floatValue() {
        return 0.0f;
    }

    @Override
    public double doubleValue() {
        return 0.0;
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        return null;
    }

    @Override
    public CoreDatatype getCoreDatatype() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        CorruptLiteral otherCorruptValue;
        if (this == o) {
            return true;
        }
        if (o instanceof CorruptLiteral && this.getInternalID() != -1 && (otherCorruptValue = (CorruptLiteral)o).getInternalID() != -1 && this.getValueStoreRevision().equals(otherCorruptValue.getValueStoreRevision())) {
            return this.getInternalID() == otherCorruptValue.getInternalID();
        }
        return super.equals(o);
    }
}

