/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.ShapeValidationContainer;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.ContextWithShape;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.LazyValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.VerySimpleRdfsBackwardsChainingConnection;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.CombinedShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ShaclValidator {
    private static final Resource[] ALL_CONTEXTS = new Resource[0];
    private static final Logger logger = LoggerFactory.getLogger(ShaclValidator.class);
    private static Resource[] SHAPE_CONTEXTS = ALL_CONTEXTS;

    public static ValidationReport validate(Sail dataRepo, Sail shapesRepo) {
        ValidationReport validationReport;
        block33: {
            List<ContextWithShape> shapes;
            try (SailConnection shapesConnection = shapesRepo.getConnection();){
                shapesConnection.begin(IsolationLevels.NONE);
                try (CombinedShapeSource shapeSource = new CombinedShapeSource(shapesConnection, shapesConnection);){
                    Stream<ShapeSource.ShapesGraph> allShapeContexts = shapeSource.withContext(SHAPE_CONTEXTS).getAllShapeContexts();
                    if (SHAPE_CONTEXTS.length == 0) {
                        allShapeContexts = Stream.concat(allShapeContexts, Stream.of(new ShapeSource.ShapesGraph(RDF4J.NIL)));
                    }
                    List<ContextWithShape> parsed = allShapeContexts.map(context -> Shape.Factory.parse(shapeSource.withContext(context.getShapesGraph()), context, new Shape.ParseSettings(true, true))).flatMap(Collection::stream).collect(Collectors.toList());
                    shapes = Shape.Factory.getShapes(parsed).stream().distinct().collect(Collectors.toList());
                    if (logger.isDebugEnabled()) {
                        for (ContextWithShape shape : shapes) {
                            logger.debug("Using data graph(s) {} and shape graph(s) {} with shape {}", new Object[]{Arrays.toString(shape.getDataGraph()), Arrays.toString(shape.getShapeGraph()), shape.getShape()});
                        }
                    }
                }
                shapesConnection.commit();
            }
            catch (Throwable e) {
                logger.warn("Failed to read shapes", e);
                throw e;
            }
            SailConnection dataRepoConnection = dataRepo.getConnection();
            try {
                RdfsSubClassOfReasoner reasoner;
                try (SailConnection shapesConnection = shapesRepo.getConnection();){
                    reasoner = RdfsSubClassOfReasoner.createReasoner(dataRepoConnection, shapesConnection, new ValidationSettings(ALL_CONTEXTS, false, true, false));
                }
                VerySimpleRdfsBackwardsChainingConnection verySimpleRdfsBackwardsChainingConnection = new VerySimpleRdfsBackwardsChainingConnection(dataRepoConnection, reasoner);
                validationReport = ShaclValidator.performValidation(shapes, new ConnectionsGroup(verySimpleRdfsBackwardsChainingConnection, null, null, null, new Stats(), () -> reasoner, new ShaclSailConnection.Settings(true, true, true, IsolationLevels.NONE), true));
                if (dataRepoConnection == null) break block33;
            }
            catch (Throwable throwable) {
                try {
                    if (dataRepoConnection != null) {
                        try {
                            dataRepoConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    logger.warn("Failed to validate shapes", e);
                    throw e;
                }
            }
            dataRepoConnection.close();
        }
        return validationReport;
    }

    private static ValidationReport performValidation(List<ContextWithShape> shapes, ConnectionsGroup connectionsGroup) {
        List<ValidationResultIterator> collect = shapes.stream().map(contextWithShape -> new ShapeValidationContainer(contextWithShape.getShape(), () -> contextWithShape.getShape().generatePlans(connectionsGroup, new ValidationSettings(contextWithShape.getDataGraph(), false, true, false)), false, false, 1000L, false, false, logger, connectionsGroup)).filter(ShapeValidationContainer::hasPlanNode).map(ShapeValidationContainer::performValidation).collect(Collectors.toList());
        return new LazyValidationReport(collect, 10000L);
    }
}

