/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.AlternativePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SequencePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class InversePath
extends Path {
    private final Path path;

    public InversePath(Resource id, Resource path, ShapeSource shapeSource) {
        super(id);
        this.path = Path.buildPath(shapeSource, path);
    }

    public InversePath(Resource id, Path path) {
        super(id);
        this.path = path;
    }

    public String toString() {
        return "InversePath{ " + this.path + " }";
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.INVERSE_PATH, this.path.getId(), new Resource[0]);
        this.path.toModel(this.path.getId(), null, model, cycleDetection);
    }

    @Override
    public PlanNode getAllAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        PlanNode added = this.path.getAllAdded(connectionsGroup, dataGraph, null);
        added = new TupleMapper(added, t -> new ValidationTuple(t.getValue(), t.getActiveTarget(), ConstraintComponent.Scope.propertyShape, true, dataGraph), connectionsGroup);
        if (planNodeWrapper != null) {
            added = (PlanNode)planNodeWrapper.apply(added);
        }
        return connectionsGroup.getCachedNodeFor(added);
    }

    @Override
    public PlanNode getAnyAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNodeWrapper planNodeWrapper) {
        return this.getAllAdded(connectionsGroup, dataGraph, planNodeWrapper);
    }

    @Override
    public boolean isSupported() {
        return this.path.isSupported();
    }

    @Override
    public String toSparqlPathString() {
        assert (this.path.toSparqlPathString().equals(this.path.toSparqlPathString().trim()));
        if (this.path instanceof SimplePath || this.path instanceof AlternativePath || this.path instanceof SequencePath) {
            return "^" + this.path.toSparqlPathString();
        }
        return "^(" + this.path.toSparqlPathString() + ")";
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        return this.path.getTargetQueryFragment(object, subject, rdfsSubClassOfReasoner, stableRandomVariableProvider, inheritedVarNames);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InversePath that = (InversePath)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

