/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.sorted.mutable;

import java.util.Comparator;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.factory.bag.sorted.MutableSortedBagFactory;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;

public class MutableSortedBagFactoryImpl
implements MutableSortedBagFactory {
    public static final MutableSortedBagFactory INSTANCE = new MutableSortedBagFactoryImpl();

    public <T> MutableSortedBag<T> empty() {
        return TreeBag.newBag();
    }

    public <T> MutableSortedBag<T> empty(Comparator<? super T> comparator) {
        return TreeBag.newBag(comparator);
    }

    public <T> MutableSortedBag<T> of() {
        return this.with();
    }

    public <T> MutableSortedBag<T> with() {
        return TreeBag.newBag();
    }

    public <T> MutableSortedBag<T> of(Comparator<? super T> comparator) {
        return this.with(comparator);
    }

    public <T> MutableSortedBag<T> with(Comparator<? super T> comparator) {
        return TreeBag.newBag(comparator);
    }

    public <T> MutableSortedBag<T> of(T ... elements) {
        return this.with(elements);
    }

    public <T> MutableSortedBag<T> with(T ... elements) {
        return TreeBag.newBagWith(elements);
    }

    public <T> MutableSortedBag<T> of(Comparator<? super T> comparator, T ... elements) {
        return this.with(comparator, elements);
    }

    public <T> MutableSortedBag<T> with(Comparator<? super T> comparator, T ... elements) {
        return TreeBag.newBagWith(comparator, elements);
    }

    public <T> MutableSortedBag<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    public <T> MutableSortedBag<T> withAll(Iterable<? extends T> items) {
        return TreeBag.newBag(items);
    }

    public <T> MutableSortedBag<T> ofAll(Comparator<? super T> comparator, Iterable<? extends T> items) {
        return this.withAll(comparator, items);
    }

    public <T> MutableSortedBag<T> withAll(Comparator<? super T> comparator, Iterable<? extends T> items) {
        return TreeBag.newBag(comparator, items);
    }
}

