/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core.query;

import java.util.Optional;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.TriplesTemplate;
import org.eclipse.rdf4j.sparqlbuilder.core.query.UpdateQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphName;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;

abstract class UpdateDataQuery<T extends UpdateDataQuery<T>>
extends UpdateQuery<T> {
    protected TriplesTemplate triplesTemplate = SparqlBuilder.triplesTemplate(new TriplePattern[0]);
    protected Optional<GraphName> graphName = Optional.empty();

    UpdateDataQuery() {
    }

    protected T addTriples(TriplePattern ... triples) {
        this.triplesTemplate.and(triples);
        return (T)this;
    }

    protected T setTriplesTemplate(TriplesTemplate triplesTemplate) {
        this.triplesTemplate = triplesTemplate;
        return (T)this;
    }

    public T graph(GraphName graph) {
        this.graphName = Optional.ofNullable(graph);
        return (T)this;
    }

    protected abstract String getPrefix();

    @Override
    protected String getQueryActionString() {
        StringBuilder updateDataQuery = new StringBuilder();
        updateDataQuery.append(this.getPrefix()).append(" ");
        this.appendNamedTriplesTemplates(updateDataQuery, this.graphName, this.triplesTemplate);
        return updateDataQuery.toString();
    }
}

