/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.config;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.nativerdf.config.NativeStoreSchema;

public class NativeStoreConfig
extends BaseSailConfig {
    private String tripleIndexes;
    private boolean forceSync = false;
    private int valueCacheSize = -1;
    private int valueIDCacheSize = -1;
    private int namespaceCacheSize = -1;
    private int namespaceIDCacheSize = -1;

    public NativeStoreConfig() {
        super("openrdf:NativeStore");
    }

    public NativeStoreConfig(String tripleIndexes) {
        this();
        this.setTripleIndexes(tripleIndexes);
    }

    public NativeStoreConfig(String tripleIndexes, boolean forceSync) {
        this(tripleIndexes);
        this.setForceSync(forceSync);
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setTripleIndexes(String tripleIndexes) {
        this.tripleIndexes = tripleIndexes;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public int getValueCacheSize() {
        return this.valueCacheSize;
    }

    public void setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
    }

    public int getValueIDCacheSize() {
        return this.valueIDCacheSize;
    }

    public void setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
    }

    public int getNamespaceCacheSize() {
        return this.namespaceCacheSize;
    }

    public void setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
    }

    public int getNamespaceIDCacheSize() {
        return this.namespaceIDCacheSize;
    }

    public void setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
    }

    public Resource export(Model m) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(m);
        }
        Resource implNode = super.export(m);
        m.setNamespace(CONFIG.NS);
        if (this.tripleIndexes != null) {
            m.add(implNode, CONFIG.Native.tripleIndexes, (Value)Values.literal((String)this.tripleIndexes), new Resource[0]);
        }
        if (this.forceSync) {
            m.add(implNode, CONFIG.Native.forceSync, (Value)Values.literal((boolean)this.forceSync), new Resource[0]);
        }
        if (this.valueCacheSize >= 0) {
            m.add(implNode, CONFIG.Native.valueCacheSize, (Value)Values.literal((int)this.valueCacheSize), new Resource[0]);
        }
        if (this.valueIDCacheSize >= 0) {
            m.add(implNode, CONFIG.Native.valueIDCacheSize, (Value)Values.literal((int)this.valueIDCacheSize), new Resource[0]);
        }
        if (this.namespaceCacheSize >= 0) {
            m.add(implNode, CONFIG.Native.namespaceCacheSize, (Value)Values.literal((int)this.namespaceCacheSize), new Resource[0]);
        }
        if (this.namespaceIDCacheSize >= 0) {
            m.add(implNode, CONFIG.Native.namespaceIDCacheSize, (Value)Values.literal((int)this.namespaceIDCacheSize), new Resource[0]);
        }
        return implNode;
    }

    private Resource exportLegacy(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace("ns", "http://www.openrdf.org/config/sail/native#");
        if (this.tripleIndexes != null) {
            m.add(implNode, NativeStoreSchema.TRIPLE_INDEXES, (Value)Values.literal((String)this.tripleIndexes), new Resource[0]);
        }
        if (this.forceSync) {
            m.add(implNode, NativeStoreSchema.FORCE_SYNC, (Value)Values.literal((boolean)this.forceSync), new Resource[0]);
        }
        if (this.valueCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.VALUE_CACHE_SIZE, (Value)Values.literal((int)this.valueCacheSize), new Resource[0]);
        }
        if (this.valueIDCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.VALUE_ID_CACHE_SIZE, (Value)Values.literal((int)this.valueIDCacheSize), new Resource[0]);
        }
        if (this.namespaceCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.NAMESPACE_CACHE_SIZE, (Value)Values.literal((int)this.namespaceCacheSize), new Resource[0]);
        }
        if (this.namespaceIDCacheSize >= 0) {
            m.add(implNode, NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE, (Value)Values.literal((int)this.namespaceIDCacheSize), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Native.tripleIndexes, (IRI)NativeStoreSchema.TRIPLE_INDEXES).ifPresent(lit -> this.setTripleIndexes(lit.getLabel()));
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Native.forceSync, (IRI)NativeStoreSchema.FORCE_SYNC).ifPresent(lit -> {
                try {
                    this.setForceSync(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + String.valueOf(CONFIG.Native.forceSync) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Native.valueCacheSize, (IRI)NativeStoreSchema.VALUE_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setValueCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.valueCacheSize) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Native.valueIDCacheSize, (IRI)NativeStoreSchema.VALUE_ID_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setValueIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.valueIDCacheSize) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Native.namespaceCacheSize, (IRI)NativeStoreSchema.NAMESPACE_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setNamespaceCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.namespaceCacheSize) + " property, found " + String.valueOf(lit));
                }
            });
            Configurations.getLiteralValue((Model)m, (Resource)implNode, (IRI)CONFIG.Native.namespaceIDCacheSize, (IRI)NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setNamespaceIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + String.valueOf(CONFIG.Native.namespaceIDCacheSize) + " property, found " + String.valueOf(lit));
                }
            });
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

