/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;

public class IrBGP
extends IrNode {
    private static final boolean DEBUG_PROPERTY_LISTS = Boolean.getBoolean("rdf4j.queryrender.debugPropertyLists");
    private List<IrNode> lines = new ArrayList<IrNode>();

    public IrBGP(boolean newScope) {
        super(newScope);
    }

    public IrBGP(IrBGP where, boolean newScope) {
        super(newScope);
        this.add(where);
    }

    public IrBGP(List<IrNode> lines, boolean newScope) {
        super(newScope);
        this.lines = lines;
    }

    public List<IrNode> getLines() {
        return this.lines;
    }

    public void add(IrNode node) {
        if (node != null) {
            this.lines.add(node);
        }
    }

    @Override
    public void print(IrPrinter p) {
        p.openBlock();
        if (this.isNewScope()) {
            p.openBlock();
        }
        List<IrNode> ordered = IrBGP.stablyOrdered(this.lines);
        this.printWithPropertyLists(p, ordered);
        if (this.isNewScope()) {
            p.closeBlock();
        }
        p.closeBlock();
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        IrBGP w = new IrBGP(this.isNewScope());
        for (IrNode ln : this.lines) {
            IrNode t = (IrNode)op.apply(ln);
            w.add((t = t.transformChildren(op)) == null ? ln : t);
        }
        return w;
    }

    public String toString() {
        return "IrBGP{lines=" + Arrays.toString(this.lines.toArray()) + "}";
    }

    private static List<IrNode> stablyOrdered(List<IrNode> in) {
        if (in == null || in.size() < 2) {
            return in;
        }
        boolean allTriples = in.stream().allMatch(n -> n instanceof IrStatementPattern);
        if (!allTriples) {
            return in;
        }
        boolean allAnonSubjects = in.stream().allMatch(n -> {
            Var s = ((IrStatementPattern)n).getSubject();
            return s != null && s.isAnonymous();
        });
        if (!allAnonSubjects) {
            return in;
        }
        ArrayList<IrNode> copy = new ArrayList<IrNode>(in);
        copy.sort((a, b) -> {
            IrStatementPattern sa = (IrStatementPattern)a;
            IrStatementPattern sb = (IrStatementPattern)b;
            int c = IrBGP.name(sa.getSubject()).compareTo(IrBGP.name(sb.getSubject()));
            if (c != 0) {
                return c;
            }
            return IrBGP.name(sa.getPredicate()).compareTo(IrBGP.name(sb.getPredicate()));
        });
        return copy;
    }

    private static String name(Var v) {
        return v == null ? "" : String.valueOf(v.getName());
    }

    private void printWithPropertyLists(IrPrinter p, List<IrNode> ordered) {
        String subjName;
        IrStatementPattern sp;
        if (ordered == null || ordered.isEmpty()) {
            return;
        }
        LinkedHashMap<String, List<IrStatementPattern>> bySubject = new LinkedHashMap<String, List<IrStatementPattern>>();
        HashSet<String> childSubjects = new HashSet<String>();
        for (IrNode n : ordered) {
            String objName;
            if (!(n instanceof IrStatementPattern) || !this.isPropertyListCandidate(sp = (IrStatementPattern)n)) continue;
            subjName = IrBGP.name(sp.getSubject());
            bySubject.computeIfAbsent(subjName, k -> new ArrayList()).add(sp);
            Var obj = sp.getObject();
            if (obj == null || !obj.isAnonymous() || !this.isAutoAnonBNodeName(objName = IrBGP.name(obj))) continue;
            childSubjects.add(objName);
        }
        if (DEBUG_PROPERTY_LISTS && !bySubject.isEmpty()) {
            System.out.println("[irbgp-debug] property list subjects=" + String.valueOf(bySubject.keySet()) + " childSubjects=" + String.valueOf(childSubjects));
        }
        for (IrNode n : ordered) {
            if (n instanceof IrStatementPattern && this.isPropertyListCandidate(sp = (IrStatementPattern)n)) {
                subjName = IrBGP.name(sp.getSubject());
                if (this.isAutoAnonBNodeName(subjName) && childSubjects.contains(subjName) && bySubject.containsKey(subjName)) {
                    if (!DEBUG_PROPERTY_LISTS) continue;
                    System.out.println("[irbgp-debug] deferring nested property list for " + subjName);
                    continue;
                }
                if (!bySubject.containsKey(subjName)) continue;
                this.printPropertyList(subjName, bySubject, p);
                continue;
            }
            if (n == null) continue;
            n.print(p);
        }
    }

    private void printPropertyList(String subjName, Map<String, List<IrStatementPattern>> bySubject, IrPrinter p) {
        List<IrStatementPattern> props = bySubject.remove(subjName);
        if (props == null || props.isEmpty()) {
            return;
        }
        IrStatementPattern first = props.get(0);
        String subjText = IrBGP.renderNodeOrVar(first.getSubjectOverride(), first.getSubject(), p);
        String align = " ".repeat(Math.max(1, subjText.length() + 1));
        for (int i = 0; i < props.size(); ++i) {
            IrStatementPattern sp = props.get(i);
            StringBuilder sb = new StringBuilder();
            if (i == 0) {
                sb.append(subjText).append(" ");
            } else {
                sb.append(align);
            }
            sb.append(p.convertVarToString(sp.getPredicate())).append(" ");
            sb.append(this.renderObject(sp, bySubject, p));
            if (i == props.size() - 1) {
                sb.append(" .");
            } else {
                sb.append(" ;");
            }
            p.line(sb.toString());
        }
    }

    private String renderPropertyListInline(String subjName, Map<String, List<IrStatementPattern>> bySubject, IrPrinter p) {
        List<IrStatementPattern> props = bySubject.remove(subjName);
        if (props == null || props.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < props.size(); ++i) {
            IrStatementPattern sp = props.get(i);
            if (i > 0) {
                sb.append(" ; ");
            }
            sb.append(p.convertVarToString(sp.getPredicate())).append(" ");
            sb.append(this.renderObject(sp, bySubject, p));
        }
        return sb.toString();
    }

    private String renderObject(IrStatementPattern sp, Map<String, List<IrStatementPattern>> bySubject, IrPrinter p) {
        List<IrStatementPattern> nested;
        if (sp.getObjectOverride() != null) {
            StringBuilder tmp = new StringBuilder();
            sp.getObjectOverride().print(new InlinePrinter(tmp, p::convertVarToString));
            return tmp.toString();
        }
        Var obj = sp.getObject();
        if (obj != null && obj.isAnonymous() && (nested = bySubject.get(IrBGP.name(obj))) != null && nested.size() >= 1) {
            String nestedText = this.renderPropertyListInline(IrBGP.name(obj), bySubject, p);
            return "[ " + nestedText + " ]";
        }
        return p.convertVarToString(obj);
    }

    private static String renderNodeOrVar(IrNode override, Var v, IrPrinter p) {
        if (override != null) {
            StringBuilder tmp = new StringBuilder();
            override.print(new InlinePrinter(tmp, p::convertVarToString));
            return tmp.toString();
        }
        if (v != null && v.isAnonymous()) {
            String name = v.getName();
            assert (name == null || !name.startsWith("anon_"));
            if (name != null && name.startsWith("_anon_bnode_")) {
                return "[]";
            }
        }
        return p.convertVarToString(v);
    }

    private boolean isPropertyListCandidate(IrStatementPattern sp) {
        if (sp == null || sp.getSubjectOverride() != null) {
            return false;
        }
        Var s = sp.getSubject();
        if (s == null || !s.isAnonymous()) {
            return false;
        }
        String n = s.getName();
        if (n == null) {
            return false;
        }
        assert (!n.startsWith("anon_"));
        if (n.startsWith("_anon_path_")) {
            return false;
        }
        return n.startsWith("_anon_bnode_") || n.startsWith("_anon_user_bnode_");
    }

    private boolean isAutoAnonBNodeName(String n) {
        if (n == null) {
            return false;
        }
        assert (!n.startsWith("anon_"));
        return n.startsWith("_anon_bnode_");
    }

    @Override
    public Set<Var> getVars() {
        HashSet<Var> out = new HashSet<Var>();
        for (IrNode ln : this.lines) {
            if (ln == null) continue;
            out.addAll(ln.getVars());
        }
        return out;
    }

    private static final class InlinePrinter
    implements IrPrinter {
        private final StringBuilder out;
        private final Function<Var, String> fmt;

        InlinePrinter(StringBuilder out, Function<Var, String> fmt) {
            this.out = out;
            this.fmt = fmt;
        }

        @Override
        public void startLine() {
        }

        @Override
        public void append(String s) {
            this.out.append(s);
        }

        @Override
        public void endLine() {
        }

        @Override
        public void line(String s) {
            this.out.append(s);
        }

        @Override
        public void openBlock() {
        }

        @Override
        public void closeBlock() {
        }

        @Override
        public void pushIndent() {
        }

        @Override
        public void popIndent() {
        }

        @Override
        public void printLines(List<IrNode> lines) {
            if (lines == null) {
                return;
            }
            for (IrNode n : lines) {
                if (n == null) continue;
                n.print(this);
            }
        }

        @Override
        public String convertVarToString(Var v) {
            return this.fmt.apply(v);
        }
    }
}

