/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IInputOrder;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.ILanguageInfoCalculator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.AdditionalInput;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.InputOrder;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.osgi.framework.Version;

public class InputType
extends BuildObject
implements IInputType {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String EMPTY_STRING = "";
    private IInputType superClass;
    private String superClassId;
    private ITool parent;
    private Vector<InputOrder> inputOrderList;
    private Vector<AdditionalInput> additionalInputList;
    private String[] sourceContentTypeIds;
    private IContentType[] sourceContentTypes;
    private String[] headerContentTypeIds;
    private IContentType[] headerContentTypes;
    private String[] inputExtensions;
    private String[] headerExtensions;
    private String dependencyContentTypeId;
    private IContentType dependencyContentType;
    private List<String> dependencyExtensions;
    private String optionId;
    private String assignToOptionId;
    private String buildVariable;
    private Boolean multipleOfType;
    private Boolean primaryInput;
    private IConfigurationElement dependencyGeneratorElement = null;
    private IManagedDependencyGeneratorType dependencyGenerator = null;
    private String languageId;
    private String languageName;
    private IConfigurationElement languageInfoCalculatorElement;
    private ILanguageInfoCalculator languageInfoCalculator;
    private String buildInfoDicsoveryProfileId;
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator;
    private boolean isExtensionInputType = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private boolean rebuildState;

    public InputType(ITool parent, IManagedConfigElement element) {
        IManagedConfigElement[] iElements;
        this.parent = parent;
        this.isExtensionInputType = true;
        this.resolved = false;
        this.loadFromManifest(element);
        IManagedConfigElement[] enablements = element.getChildren("enablement");
        if (enablements.length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        ManagedBuildManager.addExtensionInputType(this);
        IManagedConfigElement[] iManagedConfigElementArray = iElements = element.getChildren();
        int n = iElements.length;
        int n2 = 0;
        while (n2 < n) {
            IManagedConfigElement elem = iManagedConfigElementArray[n2];
            if (elem.getName().equals("inputOrder")) {
                InputOrder inputOrder = new InputOrder((IInputType)this, elem);
                this.getInputOrderList().add(inputOrder);
            } else if (elem.getName().equals("additionalInput")) {
                AdditionalInput addlInput = new AdditionalInput((IInputType)this, elem);
                this.getAdditionalInputList().add(addlInput);
            }
            ++n2;
        }
    }

    public InputType(Tool parent, IInputType superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionInputType = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionInputType(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public InputType(ITool parent, ICStorageElement element) {
        ICStorageElement[] configElements;
        this.parent = parent;
        this.isExtensionInputType = false;
        this.loadFromProject(element);
        ICStorageElement[] iCStorageElementArray = configElements = element.getChildren();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement configElement = iCStorageElementArray[n2];
            if (configElement.getName().equals("inputOrder")) {
                InputOrder inputOrder = new InputOrder((IInputType)this, configElement);
                this.getInputOrderList().add(inputOrder);
            } else if (configElement.getName().equals("additionalInput")) {
                AdditionalInput addlInput = new AdditionalInput((IInputType)this, configElement);
                this.getAdditionalInputList().add(addlInput);
            }
            ++n2;
        }
    }

    public InputType(ITool parent, String Id, String name, InputType inputType) {
        this.parent = parent;
        this.superClass = inputType.superClass;
        if (this.superClass != null && inputType.superClassId != null) {
            this.superClassId = inputType.superClassId;
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionInputType = false;
        boolean copyIds = Id.equals(inputType.id);
        if (inputType.sourceContentTypeIds != null) {
            this.sourceContentTypeIds = (String[])inputType.sourceContentTypeIds.clone();
        }
        if (inputType.sourceContentTypes != null) {
            this.sourceContentTypes = (IContentType[])inputType.sourceContentTypes.clone();
        }
        if (inputType.inputExtensions != null) {
            this.inputExtensions = (String[])inputType.inputExtensions.clone();
        }
        if (inputType.headerContentTypeIds != null) {
            this.headerContentTypeIds = (String[])inputType.headerContentTypeIds.clone();
        }
        if (inputType.headerContentTypes != null) {
            this.headerContentTypes = (IContentType[])inputType.headerContentTypes.clone();
        }
        if (inputType.headerExtensions != null) {
            this.headerExtensions = (String[])inputType.headerExtensions.clone();
        }
        if (inputType.dependencyContentTypeId != null) {
            this.dependencyContentTypeId = inputType.dependencyContentTypeId;
        }
        this.dependencyContentType = inputType.dependencyContentType;
        if (inputType.dependencyExtensions != null) {
            this.dependencyExtensions = new ArrayList<String>(inputType.dependencyExtensions);
        }
        if (inputType.optionId != null) {
            this.optionId = inputType.optionId;
        }
        if (inputType.assignToOptionId != null) {
            this.assignToOptionId = inputType.assignToOptionId;
        }
        if (inputType.buildVariable != null) {
            this.buildVariable = inputType.buildVariable;
        }
        if (inputType.multipleOfType != null) {
            this.multipleOfType = inputType.multipleOfType;
        }
        if (inputType.primaryInput != null) {
            this.primaryInput = inputType.primaryInput;
        }
        this.dependencyGeneratorElement = inputType.dependencyGeneratorElement;
        this.dependencyGenerator = inputType.dependencyGenerator;
        this.languageId = inputType.languageId;
        this.languageName = inputType.languageName;
        this.languageInfoCalculatorElement = inputType.languageInfoCalculatorElement;
        this.languageInfoCalculator = inputType.languageInfoCalculator;
        this.buildInfoDicsoveryProfileId = inputType.buildInfoDicsoveryProfileId;
        if (inputType.inputOrderList != null) {
            for (InputOrder inputOrder : inputType.getInputOrderList()) {
                InputOrder newInputOrder = new InputOrder((IInputType)this, inputOrder);
                this.getInputOrderList().add(newInputOrder);
            }
        }
        if (inputType.additionalInputList != null) {
            for (AdditionalInput additionalInput : inputType.getAdditionalInputList()) {
                AdditionalInput newAdditionalInput = new AdditionalInput((IInputType)this, additionalInput);
                this.getAdditionalInputList().add(newAdditionalInput);
            }
        }
        if (copyIds) {
            this.isDirty = inputType.isDirty;
            this.rebuildState = inputType.rebuildState;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String isPI;
        String hs;
        StringTokenizer tokenizer;
        String inputs;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        ArrayList<String> list = new ArrayList<String>();
        String ids = element.getAttribute("sourceContentType");
        if (ids != null) {
            StringTokenizer tokenizer2 = new StringTokenizer(ids, DEFAULT_SEPARATOR);
            while (tokenizer2.hasMoreElements()) {
                list.add(SafeStringInterner.safeIntern((String)tokenizer2.nextToken()));
            }
            if (list.size() != 0) {
                this.sourceContentTypeIds = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if ((inputs = element.getAttribute("sources")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
            if (list.size() != 0) {
                this.inputExtensions = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if ((ids = element.getAttribute("headerContentType")) != null) {
            tokenizer = new StringTokenizer(ids, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
            if (list.size() != 0) {
                this.headerContentTypeIds = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if ((hs = element.getAttribute("headers")) != null) {
            StringTokenizer tokenizer3 = new StringTokenizer(hs, DEFAULT_SEPARATOR);
            while (tokenizer3.hasMoreElements()) {
                list.add(SafeStringInterner.safeIntern((String)tokenizer3.nextToken()));
            }
            if (list.size() != 0) {
                this.headerExtensions = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        this.dependencyContentTypeId = element.getAttribute("dependencyContentType");
        String headers = element.getAttribute("dependencyExtensions");
        if (headers != null) {
            StringTokenizer tokenizer4 = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer4.hasMoreElements()) {
                this.getDependencyExtensionsList().add(SafeStringInterner.safeIntern((String)tokenizer4.nextToken()));
            }
        }
        this.optionId = SafeStringInterner.safeIntern((String)element.getAttribute("option"));
        this.assignToOptionId = SafeStringInterner.safeIntern((String)element.getAttribute("assignToOption"));
        String isMOT = element.getAttribute("multipleOfType");
        if (isMOT != null) {
            this.multipleOfType = Boolean.parseBoolean(isMOT);
        }
        if ((isPI = element.getAttribute("primaryInput")) != null) {
            this.primaryInput = Boolean.parseBoolean(isPI);
        }
        this.buildVariable = SafeStringInterner.safeIntern((String)element.getAttribute("buildVariable"));
        this.languageId = SafeStringInterner.safeIntern((String)element.getAttribute("languageId"));
        this.languageName = SafeStringInterner.safeIntern((String)element.getAttribute("languageName"));
        if (element.getAttribute("languageInfoCalculator") != null && element instanceof DefaultManagedConfigElement) {
            this.languageInfoCalculatorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.buildInfoDicsoveryProfileId = SafeStringInterner.safeIntern((String)element.getAttribute("scannerConfigDiscoveryProfileId"));
        String depGenerator = element.getAttribute("dependencyCalculator");
        if (depGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.dependencyGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    protected boolean loadFromProject(ICStorageElement element) {
        String isPI;
        String isMOT;
        String headers;
        String inputs;
        IContentType type;
        int n;
        int n2;
        String[] stringArray;
        ArrayList<IContentType> types;
        StringTokenizer tokenizer;
        String ids;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        }
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionInputType(this.superClassId);
        }
        IContentTypeManager manager = Platform.getContentTypeManager();
        ArrayList<String> list = new ArrayList<String>();
        if (element.getAttribute("sourceContentType") != null && (ids = element.getAttribute("sourceContentType")) != null) {
            tokenizer = new StringTokenizer(ids, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
            if (list.size() != 0) {
                this.sourceContentTypeIds = list.toArray(new String[list.size()]);
                list.clear();
            }
            if (this.sourceContentTypeIds != null) {
                types = new ArrayList<IContentType>();
                stringArray = this.sourceContentTypeIds;
                n2 = this.sourceContentTypeIds.length;
                n = 0;
                while (n < n2) {
                    String sourceContentTypeId = stringArray[n];
                    type = manager.getContentType(sourceContentTypeId);
                    if (type != null) {
                        types.add(type);
                    }
                    ++n;
                }
                if (types.size() != 0) {
                    this.sourceContentTypes = types.toArray(new IContentType[types.size()]);
                }
            }
        }
        if (element.getAttribute("sources") != null && (inputs = element.getAttribute("sources")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
            if (list.size() != 0) {
                this.inputExtensions = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if (element.getAttribute("headerContentType") != null && (ids = element.getAttribute("headerContentType")) != null) {
            tokenizer = new StringTokenizer(ids, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
            if (list.size() != 0) {
                this.headerContentTypeIds = list.toArray(new String[list.size()]);
                list.clear();
            }
            if (this.headerContentTypeIds != null) {
                types = new ArrayList();
                stringArray = this.headerContentTypeIds;
                n2 = this.headerContentTypeIds.length;
                n = 0;
                while (n < n2) {
                    String headerContentTypeId = stringArray[n];
                    type = manager.getContentType(headerContentTypeId);
                    if (type != null) {
                        types.add(type);
                    }
                    ++n;
                }
                if (types.size() != 0) {
                    this.headerContentTypes = types.toArray(new IContentType[types.size()]);
                }
            }
        }
        if (element.getAttribute("headers") != null && (inputs = element.getAttribute("headers")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
            if (list.size() != 0) {
                this.headerExtensions = list.toArray(new String[list.size()]);
                list.clear();
            }
        }
        if (element.getAttribute("dependencyContentType") != null) {
            this.dependencyContentTypeId = element.getAttribute("dependencyContentType");
            if (this.dependencyContentTypeId != null && this.dependencyContentTypeId.length() > 0) {
                this.dependencyContentType = manager.getContentType(this.dependencyContentTypeId);
            }
        }
        if (element.getAttribute("dependencyExtensions") != null && (headers = element.getAttribute("dependencyExtensions")) != null) {
            tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getDependencyExtensionsList().add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
        }
        if (element.getAttribute("option") != null) {
            this.optionId = SafeStringInterner.safeIntern((String)element.getAttribute("option"));
        }
        if (element.getAttribute("assignToOption") != null) {
            this.assignToOptionId = SafeStringInterner.safeIntern((String)element.getAttribute("assignToOption"));
        }
        if (element.getAttribute("multipleOfType") != null && (isMOT = element.getAttribute("multipleOfType")) != null) {
            this.multipleOfType = Boolean.parseBoolean(isMOT);
        }
        if (element.getAttribute("primaryInput") != null && (isPI = element.getAttribute("primaryInput")) != null) {
            this.primaryInput = Boolean.parseBoolean(isPI);
        }
        if (element.getAttribute("buildVariable") != null) {
            this.buildVariable = SafeStringInterner.safeIntern((String)element.getAttribute("buildVariable"));
        }
        this.languageId = SafeStringInterner.safeIntern((String)element.getAttribute("languageId"));
        this.languageName = SafeStringInterner.safeIntern((String)element.getAttribute("languageName"));
        this.buildInfoDicsoveryProfileId = SafeStringInterner.safeIntern((String)element.getAttribute("scannerConfigDiscoveryProfileId"));
        element.getAttribute("dependencyCalculator");
        return true;
    }

    private String composeString(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(array[0]);
        int i = 1;
        while (i < array.length) {
            buf.append(separator).append(array[i]);
            ++i;
        }
        return buf.toString();
    }

    public void serialize(ICStorageElement element) {
        String inputs;
        String s;
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.sourceContentTypeIds != null) {
            s = this.composeString(this.sourceContentTypeIds, DEFAULT_SEPARATOR);
            element.setAttribute("sourceContentType", s);
        }
        if (this.inputExtensions != null) {
            inputs = this.composeString(this.inputExtensions, DEFAULT_SEPARATOR);
            element.setAttribute("sources", inputs);
        }
        if (this.headerContentTypeIds != null) {
            s = this.composeString(this.headerContentTypeIds, DEFAULT_SEPARATOR);
            element.setAttribute("headerContentType", s);
        }
        if (this.headerExtensions != null) {
            inputs = this.composeString(this.headerExtensions, DEFAULT_SEPARATOR);
            element.setAttribute("headers", inputs);
        }
        if (this.dependencyContentTypeId != null) {
            element.setAttribute("dependencyContentType", this.dependencyContentTypeId);
        }
        if (this.getDependencyExtensionsList().size() > 0) {
            String headers = EMPTY_STRING;
            for (String header : this.getDependencyExtensionsList()) {
                if (headers.length() > 0) {
                    headers = String.valueOf(headers) + DEFAULT_SEPARATOR;
                }
                headers = String.valueOf(headers) + header;
            }
            element.setAttribute("dependencyExtensions", headers);
        }
        if (this.optionId != null) {
            element.setAttribute("option", this.optionId);
        }
        if (this.assignToOptionId != null) {
            element.setAttribute("assignToOption", this.assignToOptionId);
        }
        if (this.multipleOfType != null) {
            element.setAttribute("multipleOfType", this.multipleOfType.toString());
        }
        if (this.primaryInput != null) {
            element.setAttribute("primaryInput", this.primaryInput.toString());
        }
        if (this.buildVariable != null) {
            element.setAttribute("buildVariable", this.buildVariable);
        }
        if (this.languageId != null) {
            element.setAttribute("languageId", this.languageId);
        }
        if (this.languageName != null) {
            element.setAttribute("languageName", this.languageName);
        }
        if (this.buildInfoDicsoveryProfileId != null) {
            element.setAttribute("scannerConfigDiscoveryProfileId", this.buildInfoDicsoveryProfileId);
        }
        for (InputOrder io : this.getInputOrderList()) {
            ICStorageElement ioElement = element.createChild("inputOrder");
            io.serialize(ioElement);
        }
        for (AdditionalInput ai : this.getAdditionalInputList()) {
            ICStorageElement aiElement = element.createChild("additionalInput");
            ai.serialize(aiElement);
        }
        this.isDirty = false;
    }

    @Override
    public ITool getParent() {
        return this.parent;
    }

    @Override
    public IInputOrder createInputOrder(String path) {
        InputOrder inputOrder = new InputOrder(this, false);
        inputOrder.setPath(path);
        this.getInputOrderList().add(inputOrder);
        this.setDirty(true);
        return inputOrder;
    }

    @Override
    public IInputOrder[] getInputOrders() {
        return this.getInputOrderList().toArray(new IInputOrder[0]);
    }

    @Override
    public IInputOrder getInputOrder(String path) {
        for (InputOrder io : this.getInputOrderList()) {
            if (path.compareToIgnoreCase(io.getPath()) != 0) continue;
            return io;
        }
        return null;
    }

    @Override
    public void removeInputOrder(String path) {
        IInputOrder order = this.getInputOrder(path);
        if (order != null) {
            this.removeInputOrder(order);
        }
    }

    @Override
    public void removeInputOrder(IInputOrder element) {
        this.getInputOrderList().remove(element);
        this.setDirty(true);
    }

    @Override
    public IAdditionalInput createAdditionalInput(String paths) {
        AdditionalInput addlInput = new AdditionalInput(this, false);
        addlInput.setPaths(paths);
        this.getAdditionalInputList().add(addlInput);
        this.setDirty(true);
        return addlInput;
    }

    IAdditionalInput createAdditionalInput(IAdditionalInput base) {
        AdditionalInput newAdditionalInput = new AdditionalInput((IInputType)this, (AdditionalInput)base);
        this.getAdditionalInputList().add(newAdditionalInput);
        this.setDirty(true);
        return newAdditionalInput;
    }

    @Override
    public IAdditionalInput[] getAdditionalInputs() {
        return this.getAdditionalInputList().toArray(new IAdditionalInput[0]);
    }

    @Override
    public IAdditionalInput getAdditionalInput(String paths) {
        String[] inputTokens = paths.split(";");
        for (AdditionalInput ai : this.getAdditionalInputList()) {
            boolean match = false;
            String[] tokens = ai.getPaths();
            if (tokens.length == inputTokens.length) {
                match = true;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].compareToIgnoreCase(inputTokens[i]) != 0) {
                        match = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!match) continue;
            return ai;
        }
        return null;
    }

    @Override
    public void removeAdditionalInput(String path) {
        IAdditionalInput input = this.getAdditionalInput(path);
        if (input != null) {
            this.removeAdditionalInput(input);
        }
    }

    @Override
    public void removeAdditionalInput(IAdditionalInput element) {
        this.getAdditionalInputList().remove(element);
        this.setDirty(true);
    }

    @Override
    public IPath[] getAdditionalDependencies() {
        ArrayList<IPath> deps = new ArrayList<IPath>();
        for (AdditionalInput additionalInput : this.getAdditionalInputList()) {
            String[] paths;
            int kind = additionalInput.getKind();
            if (kind != 1 && kind != 3 || (paths = additionalInput.getPaths()) == null) continue;
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (path.length() > 0) {
                    deps.add(Path.fromOSString((String)path));
                }
                ++n2;
            }
        }
        return deps.toArray(new IPath[deps.size()]);
    }

    @Override
    public IPath[] getAdditionalResources() {
        ArrayList<IPath> ins = new ArrayList<IPath>();
        for (AdditionalInput additionalInput : this.getAdditionalInputList()) {
            String[] paths;
            int kind = additionalInput.getKind();
            if (kind != 2 && kind != 3 || (paths = additionalInput.getPaths()) == null) continue;
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (path.length() > 0) {
                    ins.add(Path.fromOSString((String)path));
                }
                ++n2;
            }
        }
        return ins.toArray(new IPath[ins.size()]);
    }

    private Vector<InputOrder> getInputOrderList() {
        if (this.inputOrderList == null) {
            this.inputOrderList = new Vector();
        }
        return this.inputOrderList;
    }

    private Vector<AdditionalInput> getAdditionalInputList() {
        if (this.additionalInputList == null) {
            this.additionalInputList = new Vector();
        }
        return this.additionalInputList;
    }

    @Override
    public IInputType getSuperClass() {
        return this.superClass;
    }

    @Override
    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    @Override
    public String getBuildVariable() {
        if (this.buildVariable == null) {
            if (this.superClass != null) {
                return this.superClass.getBuildVariable();
            }
            return EMPTY_STRING;
        }
        return this.buildVariable;
    }

    @Override
    public void setBuildVariable(String variableName) {
        if (variableName == null && this.buildVariable == null) {
            return;
        }
        if (this.buildVariable == null || variableName == null || !variableName.equals(this.buildVariable)) {
            this.buildVariable = variableName;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public IContentType getDependencyContentType() {
        if (this.dependencyContentType == null) {
            if (this.superClass != null) {
                return this.superClass.getDependencyContentType();
            }
            return null;
        }
        return this.dependencyContentType;
    }

    @Override
    public void setDependencyContentType(IContentType type) {
        if (this.dependencyContentType != type) {
            this.dependencyContentType = type;
            this.dependencyContentTypeId = this.dependencyContentType != null ? this.dependencyContentType.getId() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public String[] getDependencyExtensionsAttribute() {
        if (this.dependencyExtensions == null || this.dependencyExtensions.size() == 0) {
            if (this.superClass != null) {
                return this.superClass.getDependencyExtensionsAttribute();
            }
            if (this.dependencyExtensions == null) {
                this.dependencyExtensions = new ArrayList<String>();
            }
        }
        return this.dependencyExtensions.toArray(new String[this.dependencyExtensions.size()]);
    }

    @Override
    public void setDependencyExtensionsAttribute(String extensions) {
        this.getDependencyExtensionsList().clear();
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getDependencyExtensionsList().add(tokenizer.nextToken());
            }
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    @Override
    public String[] getDependencyExtensions(ITool tool) {
        IContentType type = this.getDependencyContentType();
        if (type != null) {
            String[] exts = ((Tool)tool).getContentTypeFileSpecs(type);
            if (type.getId().compareTo("org.eclipse.cdt.core.cxxHeader") == 0) {
                boolean h_found = false;
                String[] stringArray = exts;
                int n = exts.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (ext.compareTo("h") == 0) {
                        h_found = true;
                        break;
                    }
                    ++n2;
                }
                if (!h_found) {
                    String[] cppexts = new String[exts.length + 1];
                    int i = 0;
                    while (i < exts.length) {
                        cppexts[i] = exts[i];
                        ++i;
                    }
                    cppexts[i] = "h";
                    return cppexts;
                }
            }
            return exts;
        }
        return this.getDependencyExtensionsAttribute();
    }

    @Override
    public boolean isDependencyExtension(ITool tool, String ext) {
        String[] exts;
        String[] stringArray = exts = this.getDependencyExtensions(tool);
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String depExt = stringArray[n2];
            if (ext.equals(depExt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<String> getDependencyExtensionsList() {
        if (this.dependencyExtensions == null) {
            this.dependencyExtensions = new ArrayList<String>();
        }
        return this.dependencyExtensions;
    }

    @Override
    public IManagedDependencyGeneratorType getDependencyGenerator() {
        if (this.dependencyGenerator != null) {
            return this.dependencyGenerator;
        }
        IConfigurationElement element = this.getDependencyGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("dependencyCalculator") != null) {
                    this.dependencyGenerator = (IManagedDependencyGeneratorType)element.createExecutableExtension("dependencyCalculator");
                    return this.dependencyGenerator;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public IConfigurationElement getDependencyGeneratorElement() {
        if (this.dependencyGeneratorElement == null && this.superClass != null) {
            return ((InputType)this.superClass).getDependencyGeneratorElement();
        }
        return this.dependencyGeneratorElement;
    }

    public void setDependencyGeneratorElement(IConfigurationElement element) {
        this.dependencyGeneratorElement = element;
        this.setDirty(true);
        this.setRebuildState(true);
    }

    @Override
    public boolean getMultipleOfType() {
        if (this.multipleOfType == null) {
            if (this.superClass != null) {
                return this.superClass.getMultipleOfType();
            }
            return false;
        }
        return this.multipleOfType;
    }

    @Override
    public void setMultipleOfType(boolean b) {
        if (this.multipleOfType == null || b != this.multipleOfType) {
            this.multipleOfType = b;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public boolean getPrimaryInput() {
        if (this.primaryInput == null) {
            if (this.superClass != null) {
                return this.superClass.getPrimaryInput();
            }
            return false;
        }
        return this.primaryInput;
    }

    @Override
    public void setPrimaryInput(boolean b) {
        if (this.primaryInput == null || b != this.primaryInput) {
            this.primaryInput = b;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public String getOptionId() {
        if (this.optionId == null) {
            if (this.superClass != null) {
                return this.superClass.getOptionId();
            }
            return null;
        }
        return this.optionId;
    }

    @Override
    public void setOptionId(String id) {
        if (id == null && this.optionId == null) {
            return;
        }
        if (id == null || this.optionId == null || !this.optionId.equals(id)) {
            this.optionId = id;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public String getAssignToOptionId() {
        if (this.assignToOptionId == null) {
            if (this.superClass != null) {
                return this.superClass.getAssignToOptionId();
            }
            return null;
        }
        return this.assignToOptionId;
    }

    @Override
    public void setAssignToOptionId(String id) {
        if (id == null && this.assignToOptionId == null) {
            return;
        }
        if (id == null || this.assignToOptionId == null || !this.assignToOptionId.equals(id)) {
            this.assignToOptionId = id;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public IContentType getSourceContentType() {
        IContentType[] types = this.getSourceContentTypes();
        if (types != null && types.length != 0) {
            return types[0];
        }
        return null;
    }

    @Override
    public IContentType[] getSourceContentTypes() {
        if (this.sourceContentTypes == null) {
            if (this.superClass != null) {
                return this.superClass.getSourceContentTypes();
            }
            return new IContentType[0];
        }
        return (IContentType[])this.sourceContentTypes.clone();
    }

    @Override
    public IContentType[] getHeaderContentTypes() {
        if (this.headerContentTypes == null) {
            if (this.superClass != null) {
                return this.superClass.getHeaderContentTypes();
            }
            return new IContentType[0];
        }
        return (IContentType[])this.headerContentTypes.clone();
    }

    @Override
    public String[] getHeaderExtensionsAttribute() {
        if (this.headerExtensions == null) {
            if (this.superClass != null) {
                return this.superClass.getHeaderExtensionsAttribute();
            }
            return new String[0];
        }
        return (String[])this.headerExtensions.clone();
    }

    @Override
    public String[] getHeaderContentTypeIds() {
        if (this.headerContentTypeIds == null) {
            if (this.superClass != null) {
                return this.superClass.getHeaderContentTypeIds();
            }
            return new String[0];
        }
        return (String[])this.headerContentTypeIds.clone();
    }

    @Override
    public String[] getSourceContentTypeIds() {
        if (this.sourceContentTypeIds == null) {
            if (this.superClass != null) {
                return this.superClass.getSourceContentTypeIds();
            }
            return new String[0];
        }
        return (String[])this.sourceContentTypeIds.clone();
    }

    @Override
    public void setHeaderContentTypeIds(String[] ids) {
        if (!Arrays.equals(this.headerContentTypeIds, ids)) {
            this.headerContentTypeIds = ids != null ? (String[])ids.clone() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public void setHeaderExtensionsAttribute(String[] extensions) {
        if (!Arrays.equals(this.headerExtensions, extensions)) {
            this.headerExtensions = extensions != null ? (String[])extensions.clone() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public void setSourceContentTypeIds(String[] ids) {
        if (!Arrays.equals(this.sourceContentTypeIds, ids)) {
            this.sourceContentTypeIds = ids != null ? (String[])ids.clone() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public void setSourceExtensionsAttribute(String[] extensions) {
        if (!Arrays.equals(this.inputExtensions, extensions)) {
            this.inputExtensions = extensions != null ? (String[])extensions.clone() : null;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public void setSourceContentType(IContentType type) {
        if (type == null) {
            if (this.sourceContentTypes != null) {
                this.sourceContentTypes = null;
                this.sourceContentTypeIds = null;
                this.setDirty(true);
                this.setRebuildState(true);
            }
        } else {
            if (this.sourceContentTypes == null || this.sourceContentTypes.length != 1 || this.sourceContentTypes[0] != type) {
                this.sourceContentTypes = new IContentType[1];
                this.sourceContentTypes[0] = type;
                this.sourceContentTypeIds = new String[1];
                this.sourceContentTypeIds[0] = type.getId();
                this.setDirty(true);
                this.setRebuildState(true);
            }
            return;
        }
    }

    public void setSourceContentTypes(IContentType[] types) {
        if (types == null) {
            if (this.sourceContentTypes != null) {
                this.sourceContentTypes = null;
                this.sourceContentTypeIds = null;
                this.setDirty(true);
                this.setRebuildState(true);
            }
        } else {
            this.sourceContentTypes = (IContentType[])types.clone();
            this.sourceContentTypeIds = new String[types.length];
            int i = 0;
            while (i < types.length) {
                this.sourceContentTypeIds[i] = types[i].getId();
                ++i;
            }
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    @Override
    public String[] getSourceExtensionsAttribute() {
        if (this.inputExtensions == null) {
            if (this.superClass != null) {
                return this.superClass.getSourceExtensionsAttribute();
            }
            return new String[0];
        }
        return (String[])this.inputExtensions.clone();
    }

    @Override
    public void setSourceExtensionsAttribute(String extensions) {
        if (extensions == null) {
            if (this.inputExtensions != null) {
                this.inputExtensions = null;
                this.setDirty(true);
                this.setRebuildState(true);
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(extensions, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextToken());
            }
            Object[] newExts = list.toArray(new String[list.size()]);
            if (!Arrays.equals(newExts, this.inputExtensions)) {
                this.inputExtensions = newExts;
                this.setDirty(true);
                this.setRebuildState(true);
            }
        }
    }

    @Override
    public String[] getSourceExtensions(ITool tool) {
        return this.getSourceExtensions(tool, ((Tool)tool).getProject());
    }

    public String[] getSourceExtensions(ITool tool, IProject project) {
        IContentType[] types = this.getSourceContentTypes();
        if (types.length != 0) {
            ArrayList<String> list = new ArrayList<String>();
            IContentType[] iContentTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType type = iContentTypeArray[n2];
                list.addAll(Arrays.asList(((Tool)tool).getContentTypeFileSpecs(type, project)));
                ++n2;
            }
            return list.toArray(new String[list.size()]);
        }
        return this.getSourceExtensionsAttribute();
    }

    @Override
    public String[] getHeaderExtensions(ITool tool) {
        IContentType[] types = this.getHeaderContentTypes();
        if (types.length != 0) {
            ArrayList<String> list = new ArrayList<String>();
            IContentType[] iContentTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType type = iContentTypeArray[n2];
                list.addAll(Arrays.asList(((Tool)tool).getContentTypeFileSpecs(type)));
                ++n2;
            }
            return list.toArray(new String[list.size()]);
        }
        return this.getHeaderExtensionsAttribute();
    }

    @Override
    public boolean isSourceExtension(ITool tool, String ext) {
        return this.isSourceExtension(tool, ext, ((Tool)tool).getProject());
    }

    public boolean isSourceExtension(ITool tool, String ext, IProject project) {
        String[] exts;
        String[] stringArray = exts = this.getSourceExtensions(tool, project);
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String srcExt = stringArray[n2];
            if (ext.equals(srcExt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionInputType;
    }

    @Override
    public boolean isDirty() {
        if (this.isExtensionInputType) {
            return false;
        }
        for (InputOrder inputOrder : this.getInputOrderList()) {
            if (!inputOrder.isDirty()) continue;
            return true;
        }
        for (AdditionalInput additionalInput : this.getAdditionalInputList()) {
            if (!additionalInput.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            for (InputOrder inputOrder : this.getInputOrderList()) {
                inputOrder.setDirty(false);
            }
            for (AdditionalInput additionalInput : this.getAdditionalInputList()) {
                additionalInput.setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            IContentType type;
            int n;
            int n2;
            String[] stringArray;
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionInputType(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "inputType", this.getId());
                }
            }
            IContentTypeManager manager = Platform.getContentTypeManager();
            ArrayList<IContentType> list = new ArrayList<IContentType>();
            if (this.sourceContentTypeIds != null) {
                stringArray = this.sourceContentTypeIds;
                n2 = this.sourceContentTypeIds.length;
                n = 0;
                while (n < n2) {
                    String sourceContentTypeId = stringArray[n];
                    type = manager.getContentType(sourceContentTypeId);
                    if (type != null) {
                        list.add(type);
                    }
                    ++n;
                }
                if (list.size() != 0) {
                    this.sourceContentTypes = list.toArray(new IContentType[list.size()]);
                    list.clear();
                } else {
                    this.sourceContentTypes = new IContentType[0];
                }
            }
            if (this.headerContentTypeIds != null) {
                stringArray = this.headerContentTypeIds;
                n2 = this.headerContentTypeIds.length;
                n = 0;
                while (n < n2) {
                    String headerContentTypeId = stringArray[n];
                    type = manager.getContentType(headerContentTypeId);
                    if (type != null) {
                        list.add(type);
                    }
                    ++n;
                }
                if (list.size() != 0) {
                    this.headerContentTypes = list.toArray(new IContentType[list.size()]);
                    list.clear();
                } else {
                    this.headerContentTypes = new IContentType[0];
                }
            }
            if (this.dependencyContentTypeId != null && this.dependencyContentTypeId.length() > 0) {
                this.dependencyContentType = manager.getContentType(this.dependencyContentTypeId);
            }
            for (InputOrder inputOrder : this.getInputOrderList()) {
                inputOrder.resolveReferences();
            }
            for (AdditionalInput additionalInput : this.getAdditionalInputList()) {
                additionalInput.resolveReferences();
            }
        }
    }

    @Override
    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getParent() != null) {
            return this.getParent().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    @Override
    public Version getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
    }

    public boolean needsRebuild() {
        if (this.rebuildState) {
            return true;
        }
        for (InputOrder inputOrder : this.getInputOrderList()) {
            if (!inputOrder.needsRebuild()) continue;
            return true;
        }
        for (AdditionalInput additionalInput : this.getAdditionalInputList()) {
            if (!additionalInput.needsRebuild()) continue;
            return true;
        }
        return this.rebuildState;
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.rebuildState = rebuild;
        if (!rebuild) {
            for (InputOrder inputOrder : this.getInputOrderList()) {
                inputOrder.setRebuildState(false);
            }
            for (AdditionalInput additionalInput : this.getAdditionalInputList()) {
                additionalInput.setRebuildState(false);
            }
        }
    }

    public IResourceInfo getRcInfo(ITool tool) {
        IBuildObject parent = tool.getParent();
        if (parent instanceof IFileInfo) {
            return (IFileInfo)parent;
        }
        if (parent instanceof IToolChain) {
            return ((IToolChain)parent).getParentFolderInfo();
        }
        return null;
    }

    private ILanguageInfoCalculator getLanguageInfoCalculator() {
        if (this.languageInfoCalculator == null && this.languageInfoCalculatorElement != null) {
            try {
                Object ex = this.languageInfoCalculatorElement.createExecutableExtension("languageInfoCalculator");
                if (ex instanceof ILanguageInfoCalculator) {
                    this.languageInfoCalculator = (ILanguageInfoCalculator)ex;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.languageInfoCalculator;
    }

    public String getLanguageIdAttribute() {
        if (this.languageId == null) {
            if (this.superClass != null) {
                return ((InputType)this.superClass).getLanguageIdAttribute();
            }
            return null;
        }
        return this.languageId;
    }

    public String getLanguageNameAttribute() {
        if (this.languageName == null) {
            if (this.superClass != null) {
                return ((InputType)this.superClass).getLanguageNameAttribute();
            }
            return null;
        }
        return this.languageName;
    }

    @Override
    public String getLanguageId(ITool tool) {
        ILanguage language;
        IContentType contentType;
        ILanguageInfoCalculator calc;
        IResourceInfo rcInfo = this.getRcInfo(tool);
        String langId = this.languageId;
        if ((langId == null || this.isExtensionInputType) && (calc = this.getLanguageInfoCalculator()) != null) {
            langId = calc.getLanguageId(rcInfo, tool, this);
        }
        if (langId == null) {
            langId = this.getLanguageIdAttribute();
        }
        if (langId == null && (contentType = this.getSourceContentType()) != null && (language = LanguageManager.getInstance().getLanguage(contentType)) != null) {
            langId = language.getId();
        }
        return langId;
    }

    @Override
    public String getLanguageName(ITool tool) {
        ILanguageInfoCalculator calc;
        IResourceInfo rcInfo = this.getRcInfo(tool);
        String langName = this.languageName;
        if ((langName == null || this.isExtensionInputType) && (calc = this.getLanguageInfoCalculator()) != null) {
            langName = calc.getLanguageName(rcInfo, tool, this);
        }
        if (langName == null && (langName = this.getLanguageNameAttribute()) == null) {
            String name;
            IContentType type;
            IContentType[] types;
            IContentType[] iContentTypeArray = types = this.getSourceContentTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                type = iContentTypeArray[n2];
                name = type.getName();
                if (name != null && name.length() != 0) {
                    langName = name;
                    break;
                }
                ++n2;
            }
            if (langName == null) {
                iContentTypeArray = types = this.getHeaderContentTypes();
                n = types.length;
                n2 = 0;
                while (n2 < n) {
                    type = iContentTypeArray[n2];
                    name = type.getName();
                    if (name != null && name.length() != 0) {
                        langName = name;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (langName == null) {
            String[] exts = this.getSourceExtensions(tool);
            if (exts.length != 0) {
                langName = CDataUtil.arrayToString((String[])exts, (String)DEFAULT_SEPARATOR);
            } else {
                exts = this.getHeaderExtensions(tool);
                if (exts.length != 0) {
                    langName = CDataUtil.arrayToString((String[])exts, (String)DEFAULT_SEPARATOR);
                }
            }
        }
        if (langName == null && (langName = this.getName()) == null && (langName = tool.getName()) == null) {
            langName = this.getId();
        }
        return langName;
    }

    @Override
    public String getDiscoveryProfileId(ITool tool) {
        int nPos;
        String id = this.getDiscoveryProfileIdAttribute();
        if (id == null) {
            id = ((Tool)tool).getDiscoveryProfileId();
        }
        if (id != null && (nPos = id.indexOf(124)) > 0) {
            id = id.substring(0, nPos);
        }
        return id;
    }

    private boolean useLegacyScannerDiscoveryProfiles() {
        IResource rc;
        IConfiguration cfg;
        IBuildObject toolchain;
        boolean useLegacy = true;
        ITool tool = this.getParent();
        if (tool != null && (toolchain = tool.getParent()) instanceof IToolChain && ((IToolChain)toolchain).getDefaultLanguageSettingsProviderIds() != null && (cfg = ((IToolChain)toolchain).getParent()) != null && cfg.getDefaultLanguageSettingsProviderIds() != null && (rc = cfg.getOwner()) != null) {
            IProject project = rc.getProject();
            useLegacy = !ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled((IProject)project);
        }
        return useLegacy;
    }

    public String getLegacyDiscoveryProfileIdAttribute() {
        String profileId = this.buildInfoDicsoveryProfileId;
        if (profileId == null && (profileId = ScannerDiscoveryLegacySupport.getDeprecatedLegacyProfiles((String)this.id)) == null && this.superClass instanceof InputType) {
            profileId = ((InputType)this.superClass).getLegacyDiscoveryProfileIdAttribute();
        }
        return profileId;
    }

    public String getDiscoveryProfileIdAttribute() {
        String discoveryProfileAttribute = this.getDiscoveryProfileIdAttributeInternal();
        if (discoveryProfileAttribute == null && this.useLegacyScannerDiscoveryProfiles()) {
            discoveryProfileAttribute = this.getLegacyDiscoveryProfileIdAttribute();
        }
        return discoveryProfileAttribute;
    }

    private String getDiscoveryProfileIdAttributeInternal() {
        if (this.buildInfoDicsoveryProfileId == null && this.superClass instanceof InputType) {
            return ((InputType)this.superClass).getDiscoveryProfileIdAttributeInternal();
        }
        return this.buildInfoDicsoveryProfileId;
    }

    @Override
    public void setLanguageIdAttribute(String id) {
        this.languageId = id;
    }

    @Override
    public void setLanguageNameAttribute(String name) {
        this.languageName = name;
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator() {
        if (this.booleanExpressionCalculator == null && this.superClass != null) {
            return ((InputType)this.superClass).getBooleanExpressionCalculator();
        }
        return this.booleanExpressionCalculator;
    }

    public boolean isEnabled(ITool tool) {
        if (tool.isExtensionElement()) {
            return true;
        }
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
        if (calc == null) {
            return true;
        }
        return calc.isInputTypeEnabled(tool, this);
    }

    public boolean hasScannerConfigSettings() {
        if (this.getDiscoveryProfileIdAttribute() != null) {
            return true;
        }
        if (this.superClass != null && this.superClass instanceof InputType) {
            return ((InputType)this.superClass).hasScannerConfigSettings();
        }
        return false;
    }

    public boolean hasCustomSettings() {
        return false;
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

