/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITextInputComponent;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.tester.util.CAPUtil;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Widget;

public class StyledTextAdapter
extends ControlAdapter
implements ITextInputComponent {
    private static AutServerLogger log = new AutServerLogger(StyledTextAdapter.class);
    private StyledText m_styledText;

    public StyledTextAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_styledText = (StyledText)objectToAdapt;
    }

    public String getText() {
        return (String)this.getEventThreadQueuer().invokeAndWait("getText", (IRunnable)new IRunnable<String>(){

            public String run() {
                return CAPUtil.getWidgetText((Widget)StyledTextAdapter.this.m_styledText, StyledTextAdapter.this.m_styledText.getText());
            }
        });
    }

    public void setSelection(final int start) {
        this.getEventThreadQueuer().invokeAndWait("setSelection", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                StyledTextAdapter.this.m_styledText.setSelection(start);
                return null;
            }
        });
    }

    public void setSelection(final int start, final int end) {
        this.getEventThreadQueuer().invokeAndWait("setSelection", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                StyledTextAdapter.this.m_styledText.setSelection(start, end);
                return null;
            }
        });
    }

    public String getSelectionText() {
        return (String)this.getEventThreadQueuer().invokeAndWait("getSelectionText", (IRunnable)new IRunnable<String>(){

            public String run() {
                return StyledTextAdapter.this.m_styledText.getSelectionText();
            }
        });
    }

    public void selectAll() {
        String selectionText;
        String totalText = this.getText();
        if (!EnvironmentUtils.isMacOS()) {
            try {
                this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
            }
            catch (StepExecutionException see) {
                log.warn((Object)see);
            }
        }
        if (!totalText.equals(this.getSelectionText())) {
            this.getEventThreadQueuer().invokeAndWait("text.selectAll", (IRunnable)new IRunnable<Void>(){

                public Void run() {
                    StyledTextAdapter.this.m_styledText.selectAll();
                    return null;
                }
            });
        }
        if (!totalText.equals(selectionText = this.getSelectionText())) {
            log.warn((Object)("SelectAll failed!\nTotal text: '" + totalText + "'\n" + "Selected text: '" + selectionText + "'"));
        }
    }

    public boolean isEditable() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isEditable", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                if (StyledTextAdapter.this.m_styledText.getEditable() && StyledTextAdapter.this.m_styledText.getEnabled()) {
                    return true;
                }
                return false;
            }
        });
    }
}

