/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.dialogs.about;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.dialogs.about.WEAboutItem;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;

public class WEAboutDialog
extends TrayDialog {
    private static final int MAX_IMAGE_WIDTH_FOR_TEXT = 250;
    private ArrayList images = new ArrayList();
    private StyledText text;
    private WEAboutItem item;
    private Cursor handCursor;
    private Cursor busyCursor;
    private boolean mouseDown = false;
    private boolean dragEvent = false;
    private String aboutText;
    private Image aboutImage;

    public WEAboutDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
        WEAboutDialog.setDialogHelpAvailable((boolean)false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (GeneralHelper.isPluginMode()) {
            newShell.setText(NLS.bind((String)PluginProperties.about_title, (Object)PluginProperties.plugin_Name));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.about_dialog_context");
            this.aboutImage = null;
            ImageDescriptor imageDescriptor = Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.about_image_file);
            if (imageDescriptor != null) {
                this.aboutImage = Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(imageDescriptor);
            }
            this.aboutText = this.readAboutText(PluginProperties.about_text_file);
        } else {
            String property;
            URL url;
            ImageDescriptor imageDescriptor;
            block9: {
                newShell.setText(NLS.bind((String)PluginProperties.about_title, (Object)Platform.getProduct().getName()));
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.about_dialog_context");
                imageDescriptor = null;
                String aboutProperty = Platform.getProduct().getProperty("aboutImage");
                Bundle definingBundle = Platform.getProduct().getDefiningBundle();
                url = null;
                try {
                    if (aboutProperty != null) {
                        url = new URL(aboutProperty);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    if (definingBundle == null) break block9;
                    url = FileLocator.find((Bundle)definingBundle, (IPath)new Path(aboutProperty), null);
                }
            }
            ImageDescriptor imageDescriptor2 = imageDescriptor = url == null ? null : ImageDescriptor.createFromURL(url);
            if (imageDescriptor != null) {
                this.aboutImage = Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(imageDescriptor);
            }
            if ((property = Platform.getProduct().getProperty("aboutText")) == null) {
                this.aboutText = "";
            }
            if (property.indexOf(123) == -1) {
                this.aboutText = property;
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        final Cursor hand = new Cursor((Device)parent.getDisplay(), 21);
        final Cursor busy = new Cursor((Device)parent.getDisplay(), 1);
        this.setHandCursor(hand);
        this.setBusyCursor(busy);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WEAboutDialog.this.setHandCursor(null);
                hand.dispose();
                WEAboutDialog.this.setBusyCursor(null);
                busy.dispose();
            }
        });
        if ((this.aboutImage == null || this.aboutImage.getBounds().width <= 250) && this.aboutText != null) {
            this.setItem(this.scan(this.aboutText));
        }
        if (this.aboutImage != null) {
            this.images.add(this.aboutImage);
        }
        Composite workArea = new Composite(parent, 0);
        GridLayout workLayout = new GridLayout();
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 0;
        workArea.setLayout((Layout)workLayout);
        workArea.setLayoutData((Object)new GridData(1808));
        Color background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = new Composite(top, 0);
        topContainer.setBackground(background);
        topContainer.setForeground(foreground);
        layout = new GridLayout();
        layout.numColumns = this.aboutImage == null || this.getItem() == null ? 1 : 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topContainer.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        topContainer.setLayoutData((Object)data);
        if (this.aboutImage != null) {
            Label imageLabel = new Label(topContainer, 0);
            imageLabel.setBackground(background);
            imageLabel.setForeground(foreground);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = false;
            imageLabel.setLayoutData((Object)data);
            imageLabel.setImage(this.aboutImage);
        }
        if (this.getItem() != null) {
            Composite textContainer = new Composite(topContainer, 0);
            textContainer.setBackground(background);
            textContainer.setForeground(foreground);
            layout = new GridLayout();
            layout.numColumns = 1;
            textContainer.setLayout((Layout)layout);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = true;
            textContainer.setLayoutData((Object)data);
            this.text = new StyledText(textContainer, 10);
            this.text.setCaret(null);
            this.text.setFont(parent.getFont());
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = true;
            this.text.setText(this.getItem().getText());
            this.text.setLayoutData((Object)data);
            this.text.setCursor(null);
            this.text.setBackground(background);
            this.text.setForeground(foreground);
            this.setLinkRanges(this.text, this.getItem().getLinkRanges());
            this.addListeners(this.text);
        }
        Label bar = new Label(workArea, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        Composite bottom = (Composite)super.createDialogArea(workArea);
        layout = new GridLayout();
        bottom.setLayout((Layout)layout);
        bottom.setLayoutData((Object)new GridData(1808));
        bar = new Label(bottom, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        return workArea;
    }

    public boolean close() {
        int i = 0;
        while (i < this.images.size()) {
            Image image = (Image)this.images.get(i);
            image.dispose();
            ++i;
        }
        return super.close();
    }

    private String readAboutText(String filename) {
        String result = "";
        try {
            URL aboutURL = Plugin.getDefault().getBundle().getEntry(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(aboutURL.openStream()));
            String temp = br.readLine();
            while (temp != null && temp.length() != 0) {
                result = String.valueOf(result) + "\n" + temp;
                temp = br.readLine();
            }
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)GeneralHelper.getActiveShell(), (String)"Error", (String)("Could not read about text file " + PluginProperties.about_text_file + "."));
        }
        return result;
    }

    protected void addListeners(StyledText styledText) {
        styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                WEAboutDialog.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent e) {
                WEAboutDialog.this.mouseDown = false;
                StyledText text = (StyledText)e.widget;
                int offset = text.getCaretOffset();
                if (WEAboutDialog.this.dragEvent) {
                    WEAboutDialog.this.dragEvent = false;
                    if (WEAboutDialog.this.item != null && WEAboutDialog.this.item.isLinkAt(offset)) {
                        text.setCursor(WEAboutDialog.this.handCursor);
                    }
                } else if (WEAboutDialog.this.item != null && WEAboutDialog.this.item.isLinkAt(offset)) {
                    text.setCursor(WEAboutDialog.this.busyCursor);
                    WEAboutDialog.this.openLink(WEAboutDialog.this.item.getLinkAt(offset));
                    StyleRange selectionRange = WEAboutDialog.this.getCurrentRange(text);
                    text.setSelectionRange(selectionRange.start, selectionRange.length);
                    text.setCursor(null);
                }
            }
        });
        styledText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (WEAboutDialog.this.mouseDown) {
                    if (!WEAboutDialog.this.dragEvent) {
                        StyledText text = (StyledText)e.widget;
                        text.setCursor(null);
                    }
                    WEAboutDialog.this.dragEvent = true;
                    return;
                }
                StyledText text = (StyledText)e.widget;
                int offset = -1;
                try {
                    offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (offset == -1) {
                    text.setCursor(null);
                } else if (WEAboutDialog.this.item != null && WEAboutDialog.this.item.isLinkAt(offset)) {
                    text.setCursor(WEAboutDialog.this.handCursor);
                } else {
                    text.setCursor(null);
                }
            }
        });
        styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                StyledText text = (StyledText)e.widget;
                switch (e.detail) {
                    case 2: {
                        e.doit = true;
                        break;
                    }
                    case 16: {
                        StyleRange nextRange;
                        Point nextSelection = text.getSelection();
                        int charCount = text.getCharCount();
                        if (nextSelection.x == charCount && nextSelection.y == charCount) {
                            text.setSelection(0);
                        }
                        if ((nextRange = WEAboutDialog.this.findNextRange(text)) == null) {
                            text.setSelection(0);
                            e.doit = true;
                            break;
                        }
                        text.setSelectionRange(nextRange.start, nextRange.length);
                        e.doit = true;
                        e.detail = 0;
                        break;
                    }
                    case 8: {
                        StyleRange previousRange;
                        Point previousSelection = text.getSelection();
                        if (previousSelection.x == 0 && previousSelection.y == 0) {
                            text.setSelection(text.getCharCount());
                        }
                        if ((previousRange = WEAboutDialog.this.findPreviousRange(text)) == null) {
                            text.setSelection(text.getCharCount());
                            e.doit = true;
                            break;
                        }
                        text.setSelectionRange(previousRange.start, previousRange.length);
                        e.doit = true;
                        e.detail = 0;
                        break;
                    }
                }
            }
        });
        styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                StyledText text = (StyledText)event.widget;
                if (event.character == ' ' || event.character == '\r') {
                    if (WEAboutDialog.this.item != null) {
                        int offset = text.getSelection().x + 1;
                        if (WEAboutDialog.this.item.isLinkAt(offset)) {
                            text.setCursor(WEAboutDialog.this.busyCursor);
                            WEAboutDialog.this.openLink(WEAboutDialog.this.item.getLinkAt(offset));
                            StyleRange selectionRange = WEAboutDialog.this.getCurrentRange(text);
                            text.setSelectionRange(selectionRange.start, selectionRange.length);
                            text.setCursor(null);
                        }
                    }
                    return;
                }
            }
        });
    }

    protected Cursor getBusyCursor() {
        return this.busyCursor;
    }

    protected void setBusyCursor(Cursor busyCursor) {
        this.busyCursor = busyCursor;
    }

    protected Cursor getHandCursor() {
        return this.handCursor;
    }

    protected void setHandCursor(Cursor handCursor) {
        this.handCursor = handCursor;
    }

    protected WEAboutItem getItem() {
        return this.item;
    }

    protected void setItem(WEAboutItem item) {
        this.item = item;
    }

    protected StyleRange getCurrentRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionEnd = text.getSelection().y;
        int currentSelectionStart = text.getSelection().x;
        int i = 0;
        while (i < ranges.length) {
            if (currentSelectionStart >= ranges[i].start && currentSelectionEnd <= ranges[i].start + ranges[i].length) {
                return ranges[i];
            }
            ++i;
        }
        return null;
    }

    protected StyleRange findNextRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionEnd = text.getSelection().y;
        int i = 0;
        while (i < ranges.length) {
            if (ranges[i].start >= currentSelectionEnd) {
                return ranges[i];
            }
            ++i;
        }
        return null;
    }

    protected StyleRange findPreviousRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionStart = text.getSelection().x;
        int i = ranges.length - 1;
        while (i > -1) {
            if (ranges[i].start + ranges[i].length - 1 < currentSelectionStart) {
                return ranges[i];
            }
            --i;
        }
        return null;
    }

    private void openWebBrowserError(String href, Throwable t) {
        MessageDialog.openError((Shell)GeneralHelper.getActiveShell(), (String)"Error", (String)("Unable to open web browser for " + href + "."));
    }

    protected void openLink(String href) {
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            browser.openURL(new URL(this.urlEncodeForSpaces(href.toCharArray())));
        }
        catch (MalformedURLException e) {
            this.openWebBrowserError(href, e);
        }
        catch (PartInitException e) {
            this.openWebBrowserError(href, e);
        }
    }

    private String urlEncodeForSpaces(char[] input) {
        StringBuffer retu = new StringBuffer(input.length);
        int i = 0;
        while (i < input.length) {
            if (input[i] == ' ') {
                retu.append("%20");
            } else {
                retu.append(input[i]);
            }
            ++i;
        }
        return retu.toString();
    }

    protected boolean openBrowser(URL url) {
        if (url != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (url == null) {
            return false;
        }
        this.openLink(url.toString());
        return true;
    }

    protected void setBoldRanges(StyledText styledText, int[][] boldRanges) {
        int i = 0;
        while (i < boldRanges.length) {
            StyleRange r = new StyleRange(boldRanges[i][0], boldRanges[i][1], null, null, 1);
            styledText.setStyleRange(r);
            ++i;
        }
    }

    protected void setLinkRanges(StyledText styledText, int[][] linkRanges) {
        Color fg = JFaceColors.getHyperlinkText((Display)styledText.getShell().getDisplay());
        int i = 0;
        while (i < linkRanges.length) {
            StyleRange r = new StyleRange(linkRanges[i][0], linkRanges[i][1], fg, null);
            styledText.setStyleRange(r);
            ++i;
        }
    }

    protected WEAboutItem scan(String s) {
        ArrayList<int[]> linkRanges = new ArrayList<int[]>();
        ArrayList<String> links = new ArrayList<String>();
        int urlSeparatorOffset = s.indexOf("://");
        while (urlSeparatorOffset >= 0) {
            char ch;
            boolean startDoubleQuote = false;
            int urlOffset = urlSeparatorOffset;
            do {
                ch = ' ';
                if (--urlOffset > -1) {
                    ch = s.charAt(urlOffset);
                }
                boolean bl = startDoubleQuote = ch == '\"';
            } while (Character.isUnicodeIdentifierStart(ch));
            ++urlOffset;
            StringTokenizer tokenizer = new StringTokenizer(s.substring(urlSeparatorOffset + 3), " \t\n\r\f<>", false);
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            int urlLength = tokenizer.nextToken().length() + 3 + urlSeparatorOffset - urlOffset;
            if (startDoubleQuote) {
                int endOffset = -1;
                int nextDoubleQuote = s.indexOf(34, urlOffset);
                int nextWhitespace = s.indexOf(32, urlOffset);
                if (nextDoubleQuote != -1 && nextWhitespace != -1) {
                    endOffset = Math.min(nextDoubleQuote, nextWhitespace);
                } else if (nextDoubleQuote != -1) {
                    endOffset = nextDoubleQuote;
                } else if (nextWhitespace != -1) {
                    endOffset = nextWhitespace;
                }
                if (endOffset != -1) {
                    urlLength = endOffset - urlOffset;
                }
            }
            linkRanges.add(new int[]{urlOffset, urlLength});
            links.add(s.substring(urlOffset, urlOffset + urlLength));
            urlSeparatorOffset = s.indexOf("://", urlOffset + urlLength + 1);
        }
        return new WEAboutItem(s, (int[][])linkRanges.toArray((T[])new int[linkRanges.size()][2]), links.toArray(new String[links.size()]));
    }
}

