/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.guards;

import org.eclipse.jwt.meta.model.processes.GuardSpecification;

public class TreetoStringParser {
    public static String getString(GuardSpecification gs) {
        StringBuilder strb = new StringBuilder();
        if (gs.getSubSpecification().size() == 0) {
            return TreetoStringParser.getStringfromGuardSpec(gs);
        }
        int i = 0;
        while (i < gs.getSubSpecification().size()) {
            GuardSpecification guardspec = (GuardSpecification)gs.getSubSpecification().get(i);
            if (guardspec.getSubSpecification().size() > 0) {
                String text = TreetoStringParser.getString(guardspec);
                text = TreetoStringParser.optimiseString(text);
                if (i > 0) {
                    strb.append(" ").append(guardspec.getSubSpecificationConnector()).append(" ");
                }
                text = "(" + text + ")";
                text = TreetoStringParser.optimiseString(text);
                strb.append(text);
            } else {
                if (i > 0) {
                    strb.append(" ").append(gs.getSubSpecificationConnector()).append(" ");
                }
                strb.append(TreetoStringParser.getStringfromGuardSpec(guardspec));
            }
            ++i;
        }
        return strb.toString();
    }

    private static String optimiseString(String term) {
        if (term.indexOf("((") == 0 && term.lastIndexOf("))") == term.length() - 2) {
            term = term.substring(1);
            term = term.substring(0, term.length() - 1);
        }
        return term;
    }

    private static String getStringfromGuardSpec(GuardSpecification gs) {
        StringBuilder strb = new StringBuilder();
        if (gs.getSubSpecification().size() == 0) {
            strb.append(gs.getData() != null ? String.valueOf(gs.getData().getName()) + "." : "");
            strb.append(gs.getAttribute() != null ? gs.getAttribute() : "");
            strb.append(" ");
            strb.append(gs.getOperation().getLiteral());
            strb.append(" ");
            strb.append(gs.getValue());
        } else {
            strb.append(gs.getSubSpecificationConnector().getLiteral());
        }
        return strb.toString();
    }
}

