/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.creation;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.actions.handlers.OpenFileHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreationWizardPageFileName
extends WizardPage {
    protected Text packageField;
    protected Text activityField;
    protected Text fileField;
    protected Text authorField;
    protected Text versionField;
    protected boolean showFileNameField;
    protected Button standardPackagesCheckbox;
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CreationWizardPageFileName.this.setPageComplete(CreationWizardPageFileName.this.validatePage());
        }
    };

    public CreationWizardPageFileName(String pageId, boolean showFileNameField) {
        super(pageId);
        this.showFileNameField = showFileNameField;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label packageNameLabel = new Label(composite, 16384);
        packageNameLabel.setText(PluginProperties.wizards_ModelWizardPackage_label);
        data = new GridData();
        data.horizontalAlignment = 4;
        packageNameLabel.setLayoutData((Object)data);
        this.packageField = new Text(composite, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        this.packageField.setLayoutData((Object)data);
        this.packageField.setText(PluginProperties.wizards_ModelWizardPackage_std);
        Label activityNameLabel = new Label(composite, 16384);
        activityNameLabel.setText(PluginProperties.wizards_ModelWizardActivity_label);
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        activityNameLabel.setLayoutData((Object)data2);
        this.activityField = new Text(composite, 2048);
        data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.horizontalSpan = 1;
        this.activityField.setLayoutData((Object)data2);
        this.activityField.setText(PluginProperties.wizards_ModelWizardActivity_std);
        Label authorLabel = new Label(composite, 16384);
        authorLabel.setText(PluginProperties.wizards_ModelWizardAuthor_label);
        GridData data3 = new GridData();
        data3.horizontalAlignment = 4;
        authorLabel.setLayoutData((Object)data3);
        this.authorField = new Text(composite, 2048);
        data3 = new GridData();
        data3.horizontalAlignment = 4;
        data3.grabExcessHorizontalSpace = true;
        data3.horizontalSpan = 1;
        this.authorField.setLayoutData((Object)data3);
        Label versionLabel = new Label(composite, 16384);
        versionLabel.setText(PluginProperties.wizards_ModelWizardVersion_label);
        GridData data4 = new GridData();
        data4.horizontalAlignment = 4;
        versionLabel.setLayoutData((Object)data4);
        this.versionField = new Text(composite, 2048);
        data4 = new GridData();
        data4.horizontalAlignment = 4;
        data4.grabExcessHorizontalSpace = true;
        data4.horizontalSpan = 1;
        this.versionField.setLayoutData((Object)data4);
        Label dummyLabel = new Label(composite, 16384);
        dummyLabel.setLayoutData((Object)new GridData());
        this.standardPackagesCheckbox = new Button(composite, 32);
        this.standardPackagesCheckbox.setText(PluginProperties.wizards_ModelWizardStandardPackages_label);
        this.standardPackagesCheckbox.setSelection(true);
        Label resourceURILabel = new Label(composite, 16384);
        resourceURILabel.setText(PluginProperties.wizards_ModelWizardFile_label);
        GridData data5 = new GridData();
        data5.horizontalAlignment = 4;
        resourceURILabel.setLayoutData((Object)data5);
        Composite fileComposite = new Composite(composite, 0);
        GridData data6 = new GridData();
        data6.horizontalAlignment = 4;
        data6.grabExcessHorizontalSpace = true;
        fileComposite.setLayoutData((Object)data6);
        GridLayout layout2 = new GridLayout();
        data6.horizontalAlignment = 4;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        fileComposite.setLayout((Layout)layout2);
        this.fileField = new Text(fileComposite, 2048);
        data6 = new GridData();
        data6.horizontalAlignment = 4;
        data6.grabExcessHorizontalSpace = true;
        data6.horizontalSpan = 1;
        this.fileField.setLayoutData((Object)data6);
        this.fileField.addModifyListener(this.validator);
        Button resourceURIBrowseFileSystemButton = new Button(fileComposite, 8);
        resourceURIBrowseFileSystemButton.setText(PluginProperties.browse_button);
        resourceURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String fileExtension = WEEditor.getWorkflowExtension();
                String filePath = OpenFileHandler.openFilePathDialog(CreationWizardPageFileName.this.getShell(), null, 4096);
                if (filePath != null) {
                    if (!filePath.endsWith("." + fileExtension)) {
                        filePath = String.valueOf(filePath) + "." + fileExtension;
                    }
                    CreationWizardPageFileName.this.fileField.setText(filePath);
                }
            }
        });
        if (!this.showFileNameField) {
            resourceURILabel.setVisible(false);
            resourceURIBrowseFileSystemButton.setVisible(false);
            this.fileField.setVisible(false);
        }
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        URI fileURI = this.getFileURI();
        this.setErrorMessage(null);
        return !this.showFileNameField || fileURI != null && !fileURI.isEmpty();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fileField.getVisible()) {
            this.fileField.setFocus();
        }
    }

    public URI getFileURI() {
        try {
            return URI.createFileURI((String)this.fileField.getText());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPackageName() {
        return this.packageField.getText();
    }

    public String getActivityName() {
        return this.activityField.getText();
    }

    public String getAuthor() {
        return this.authorField.getText();
    }

    public String getVersion() {
        return this.versionField.getText();
    }

    public void selectFileField() {
        this.fileField.selectAll();
        this.fileField.setFocus();
    }

    public boolean getStandardPackages() {
        return this.standardPackagesCheckbox.getSelection();
    }
}

