/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core.model;

import java.util.HashMap;
import java.util.List;
import org.eclipse.ptp.rm.lml.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectName;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectsType;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.LMLColor;
import org.eclipse.ptp.rm.lml.core.model.LMLNodeData;
import org.eclipse.ptp.rm.lml.core.model.LguiHandler;

public class OIDToObject
extends LguiHandler {
    private static final LMLColor notConnectedColor = LMLColor.lightGray;
    private HashMap<String, ObjectType> oidToObject;
    private HashMap<String, LMLColor> oidToColor;
    private String systemId = null;

    public OIDToObject(ILguiItem lguiItem, LguiType lgui) {
        super(lguiItem, lgui);
        this.updateData();
        this.lguiItem.addListener(new ILguiListener(){

            @Override
            public void handleEvent(ILguiUpdatedEvent e) {
                OIDToObject.this.update(e.getLgui());
                OIDToObject.this.updateData();
            }
        });
    }

    public LMLColor getColorById(String id) {
        if (id == null) {
            return notConnectedColor;
        }
        LMLColor result = this.oidToColor.get(id);
        if (result == null) {
            return notConnectedColor;
        }
        return result;
    }

    public ObjectType getObjectById(String id) {
        return this.oidToObject.get(id);
    }

    public ObjectType getObjectByLMLNode(LMLNodeData nodeData) {
        if (nodeData == null || nodeData.getDataElement() == null) {
            return null;
        }
        return this.getObjectById(nodeData.getDataElement().getOid());
    }

    public String getSystemObjectId() {
        return this.systemId;
    }

    private void updateData() {
        List<ObjectsType> objectsList = this.lguiItem.getOverviewAccess().getObjects();
        for (ObjectsType objects : objectsList) {
            List<ObjectType> objectList = objects.getObject();
            this.oidToObject = new HashMap();
            this.oidToColor = new HashMap();
            for (ObjectType object : objectList) {
                this.oidToObject.put(object.getId(), object);
                this.oidToColor.put(object.getId(), LMLColor.stringToColor(object.getColor()));
                if (object.getType() != ObjectName.SYSTEM) continue;
                this.systemId = object.getId();
            }
        }
    }
}

