/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PanelGridInsertHeaderCommand
extends DesignerCommand {
    private Element _panelGrid;

    public PanelGridInsertHeaderCommand(IHTMLGraphicalViewer viewer, Element panelGrid) {
        super(CommandResources.getString("PanelGridInsertHeaderCommand.Label.InsertHeader"), viewer);
        this._panelGrid = panelGrid;
    }

    public boolean canExecute() {
        boolean hasHeader;
        boolean bl = hasHeader = JSFDOMUtil.findFacet(this._panelGrid, "header") != null;
        if (hasHeader) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        Document doc = this._panelGrid.getOwnerDocument();
        Element facet = doc.createElement("facet");
        facet.setPrefix("f");
        facet.setAttribute("name", "header");
        Element outputText = doc.createElement("outputText");
        outputText.setPrefix("h");
        outputText.setAttribute("value", "Header");
        facet.appendChild(outputText);
        this._panelGrid.insertBefore(facet, this._panelGrid.getFirstChild());
        this.formatNode(this._panelGrid);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._panelGrid);
    }
}

