/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.util.Hexadecimals;
import org.assertj.core.util.Preconditions;

public final class Digests {
    private static final int BUFFER_SIZE = 8192;

    private Digests() {
    }

    public static String toHex(byte[] digest) {
        Preconditions.checkNotNull(digest, "The digest should not be null");
        StringBuilder hex = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            hex.append(Hexadecimals.byteToHexString(b));
        }
        return hex.toString();
    }

    public static byte[] fromHex(String digest) {
        Preconditions.checkNotNull(digest, "The digest should not be null");
        byte[] bytes = new byte[digest.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = Integer.valueOf(digest.substring(i * 2, (i + 1) * 2), 16).byteValue();
        }
        return bytes;
    }

    public static DigestDiff digestDiff(InputStream stream, MessageDigest messageDigest, byte[] expected) throws IOException {
        int len;
        Preconditions.checkNotNull(stream, "The stream should not be null");
        Preconditions.checkNotNull(messageDigest, "The digest should not be null");
        Preconditions.checkNotNull(expected, "The expected should not be null");
        messageDigest.reset();
        byte[] buffer = new byte[8192];
        while ((len = stream.read(buffer)) > 0) {
            messageDigest.update(buffer, 0, len);
        }
        byte[] actualDigest = messageDigest.digest();
        String expectedHex = Digests.toHex(expected);
        String actualHex = Digests.toHex(actualDigest);
        return new DigestDiff(actualHex, expectedHex, messageDigest);
    }
}

