/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Correlation;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.CorrelationSets;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.MessageExchanges;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.To;
import org.eclipse.bpel.model.adapters.AdapterRegistry;
import org.eclipse.bpel.model.adapters.INamespaceMap;
import org.eclipse.bpel.model.proxy.MessageProxy;
import org.eclipse.bpel.model.proxy.OperationProxy;
import org.eclipse.bpel.model.proxy.PortTypeProxy;
import org.eclipse.bpel.model.reordering.IExtensibilityElementListHandler;
import org.eclipse.bpel.model.resource.BPELResource;
import org.eclipse.bpel.model.resource.BPELResourceSetImpl;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.model.util.ImportResolver;
import org.eclipse.bpel.model.util.ImportResolverRegistry;
import org.eclipse.bpel.names.NCNameWordDetector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class BPELUtils {
    public static final String ATTR_XMLNS = "xmlns";
    static Map<String, Locale> string2Locale = new HashMap<String, Locale>();
    static Map<Locale, String> locale2String = new HashMap<Locale, String>();
    static NCNameWordDetector NCNAME_DETECTOR;

    static {
        StringBuilder sb = new StringBuilder();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            sb.setLength(0);
            sb.append(l.getLanguage());
            if (!BPELUtils.isEmptyOrWhitespace(l.getCountry())) {
                sb.append("-").append(l.getCountry());
            }
            String key = sb.toString().toLowerCase();
            string2Locale.put(key, l);
            locale2String.put(l, key);
            ++n2;
        }
        NCNAME_DETECTOR = new NCNameWordDetector();
    }

    public static EObject lookup(EObject ref, QName qname, String name, String refType) {
        Process process = BPELUtils.getProcess(ref);
        if (process == null) {
            return null;
        }
        Iterator it = process.getImports().iterator();
        EObject result = null;
        while (it.hasNext()) {
            Import imp = (Import)it.next();
            String ns = imp.getNamespace();
            if (ns == null) {
                ns = "";
            }
            if (!ns.equals(qname.getNamespaceURI()) || imp.getLocation() == null) continue;
            ImportResolver[] resolvers = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int i = 0;
            while (i < resolvers.length) {
                result = resolvers[i].resolve(imp, qname, name, refType);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return result;
    }

    public static String getNamespace(EObject eObject, String prefix) {
        INamespaceMap<String, String> prefixNSMap = null;
        EObject context = eObject;
        while (context != null) {
            prefixNSMap = BPELUtils.getNamespaceMap(context);
            String value = (String)prefixNSMap.get(prefix);
            if (value != null) {
                return value;
            }
            context = context.eContainer();
        }
        return null;
    }

    public static void setPrefix(EObject eObject, String namespaceURI, String prefix) {
        INamespaceMap<String, String> prefixNSMap = BPELUtils.getNamespaceMap(eObject);
        if (prefixNSMap.containsKey(prefix)) {
            throw new RuntimeException("Prefix is already mapped!");
        }
        prefixNSMap.put(prefix, namespaceURI);
    }

    public static String getNamespacePrefix(EObject eObject, String namespace) {
        EObject context = eObject;
        while (context != null) {
            List<String> pfxList = BPELUtils.getNamespaceMap(context).getReverse(namespace);
            if (pfxList.size() > 0) {
                return pfxList.get(0);
            }
            context = context.eContainer();
        }
        return null;
    }

    public static void setNamespacePrefix(EObject eObject, String namespace, String prefix) {
        BPELUtils.setPrefix(BPELUtils.getNearestScopeOrProcess(eObject), namespace, prefix);
    }

    public static INamespaceMap<String, String> getNamespaceMap(EObject eObject) {
        if (eObject == null) {
            throw new NullPointerException("eObject cannot be null in getNamespaceMap()");
        }
        INamespaceMap nsMap = null;
        while (nsMap == null && eObject != null) {
            nsMap = AdapterRegistry.INSTANCE.adapt((Object)eObject, INamespaceMap.class);
            if (nsMap != null) continue;
            eObject = eObject.eContainer();
        }
        if (nsMap == null) {
            throw new IllegalStateException("INamespaceMap cannot be attached to an eObject");
        }
        return nsMap;
    }

    public static Process getProcess(Object object) {
        if (object instanceof EObject) {
            if (object instanceof Process) {
                return (Process)object;
            }
            EObject cont = ((EObject)object).eContainer();
            while (cont != null) {
                if (cont.eClass() == BPELPackage.eINSTANCE.getProcess()) {
                    return (Process)cont;
                }
                cont = cont.eContainer();
            }
        }
        return null;
    }

    public static EObject getNearestScopeOrProcess(EObject eObject) {
        EObject context = eObject;
        while (context != null) {
            if (context instanceof Scope) {
                return context;
            }
            if (context instanceof Process) {
                return context;
            }
            context = context.eContainer();
        }
        return null;
    }

    public static Map<String, String> getAllNamespacesForContext(EObject eObject) {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        EObject context = eObject;
        while (context != null) {
            INamespaceMap<String, String> localNSMap = BPELUtils.getNamespaceMap(context);
            for (Map.Entry entry : localNSMap.entrySet()) {
                if (nsMap.containsKey(entry.getKey())) continue;
                nsMap.put((String)entry.getKey(), (String)entry.getValue());
            }
            context = context.eContainer();
        }
        return nsMap;
    }

    public static List<ExtensibleElement> reorderExtensibilityList(List<IExtensibilityElementListHandler> extensibilityElementListHandlers, ExtensibleElement parent) {
        ArrayList<ExtensibleElement> tempExtensibilityElementList = new ArrayList<ExtensibleElement>();
        tempExtensibilityElementList.addAll(parent.getExtensibilityElements());
        if (extensibilityElementListHandlers.isEmpty() || parent.getExtensibilityElements() == null || parent.getExtensibilityElements().size() <= 1) {
            return tempExtensibilityElementList;
        }
        for (IExtensibilityElementListHandler element : extensibilityElementListHandlers) {
            element.orderList(parent, tempExtensibilityElementList);
        }
        return tempExtensibilityElementList;
    }

    public static Node convertStringToNode(EObject parent, String s, BPELResource bpelResource) {
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        StringBuilder namespaces = new StringBuilder();
        Map<String, String> nsMap = BPELUtils.getAllNamespacesForContext(parent);
        for (Map.Entry<String, String> e : nsMap.entrySet()) {
            String prefix = e.getKey();
            String value = e.getValue();
            if (BPELConstants.isBPELNamespace(value)) continue;
            if (prefix != "") {
                namespaces.append("xmlns:");
                namespaces.append(prefix);
            } else {
                namespaces.append(ATTR_XMLNS);
            }
            namespaces.append("=\"");
            namespaces.append(value);
            namespaces.append("\" ");
        }
        String namespaceURI = bpelResource.getNamespaceURI();
        if (bpelResource.getOptionUseNSPrefix()) {
            String prefix = "bpws";
            s = "<" + prefix + ":from xmlns:" + prefix + "=\"" + namespaceURI + "\" " + namespaces.toString() + ">" + s + "</" + prefix + ":from>";
        } else {
            s = "<from xmlns=\"" + namespaceURI + "\" " + namespaces.toString() + ">" + s + "</from>";
        }
        try {
            StringReader sr = new StringReader(s);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource source = new InputSource(sr);
            source.setEncoding("UTF8");
            Document document = builder.parse(source);
            return document.getDocumentElement();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String elementToString(Element element) {
        StringWriter writer = new StringWriter();
        DOM2Writer.serializeAsXML((Node)element, (Writer)writer);
        return writer.getBuffer().toString();
    }

    public static QName createAttributeValue(Element element, String attribute) {
        String prefixedValue = element.getAttribute(attribute);
        return BPELUtils.createQName(element, prefixedValue);
    }

    public static QName createQName(Element element, String prefixedValue) {
        int index = prefixedValue.indexOf(58);
        String prefix = index != -1 ? prefixedValue.substring(0, index) : null;
        String localPart = prefixedValue.substring(index + 1);
        String namespaceURI = DOMUtils.getNamespaceURIFromPrefix((Node)element, (String)prefix);
        if (prefix == null) {
            return new QName(namespaceURI, localPart);
        }
        return new QName(namespaceURI, localPart, prefix);
    }

    public static PartnerLink getPartnerLink(EObject eObject, String partnerLinkName) {
        EObject container = eObject;
        while (container != null) {
            PartnerLinks partnerLinks = null;
            if (container instanceof Process) {
                partnerLinks = ((Process)container).getPartnerLinks();
            } else if (container instanceof Scope) {
                partnerLinks = ((Scope)container).getPartnerLinks();
            }
            if (partnerLinks != null) {
                for (PartnerLink pl : partnerLinks.getChildren()) {
                    if (!pl.getName().equals(partnerLinkName)) continue;
                    return pl;
                }
            }
            container = container.eContainer();
        }
        return null;
    }

    public static MessageExchange getMessageExchange(EObject eObject, String messageExchangeName) {
        EObject container = eObject;
        while (container != null) {
            MessageExchanges messageExchanges = null;
            if (container instanceof Process) {
                messageExchanges = ((Process)container).getMessageExchanges();
            } else if (container instanceof Scope) {
                messageExchanges = ((Scope)container).getMessageExchanges();
            }
            if (messageExchanges != null) {
                for (MessageExchange me : messageExchanges.getChildren()) {
                    if (!me.getName().equals(messageExchangeName)) continue;
                    return me;
                }
            }
            container = container.eContainer();
        }
        return null;
    }

    public static CorrelationSet getCorrelationSetForActivity(Correlation correlation, String correlationSetName) {
        EObject container = correlation.eContainer();
        while (container != null) {
            CorrelationSets correlationSets = null;
            if (container instanceof Process) {
                correlationSets = ((Process)container).getCorrelationSets();
            } else if (container instanceof Scope) {
                correlationSets = ((Scope)container).getCorrelationSets();
            } else if (container instanceof OnEvent) {
                correlationSets = ((OnEvent)container).getCorrelationSets();
            }
            if (correlationSets != null) {
                for (CorrelationSet correlationSet : correlationSets.getChildren()) {
                    if (!correlationSet.getName().equals(correlationSetName)) continue;
                    return correlationSet;
                }
            }
            container = container.eContainer();
        }
        return null;
    }

    public static final String getNSPrefixMapKey(String attrName) {
        return ATTR_XMLNS.equals(attrName) ? "" : attrName;
    }

    public static PortType getPortType(URI uri, Element activityElement, String qnameAttribute) {
        QName qName = BPELUtils.createAttributeValue(activityElement, qnameAttribute);
        PortTypeProxy portType = new PortTypeProxy(uri, qName);
        return portType;
    }

    public static Message getMessage(URI uri, Element activityElement, String qnameAttribute) {
        QName qName = BPELUtils.createAttributeValue(activityElement, qnameAttribute);
        MessageProxy message = new MessageProxy(uri, qName);
        return message;
    }

    public static Operation getOperation(URI uri, PortType portType, Element activityElement, String operationAttribute) {
        if (!activityElement.hasAttribute(operationAttribute)) {
            return null;
        }
        String operationSignature = activityElement.getAttribute(operationAttribute);
        OperationProxy operation = new OperationProxy(uri, portType, operationSignature);
        return operation;
    }

    public static final boolean isBPELElement(Node node) {
        return node != null && node.getNodeType() == 1 && BPELConstants.isBPELNamespace(node.getNamespaceURI());
    }

    public static String boolean2XML(Boolean b) {
        if (b == null || b.equals(Boolean.FALSE)) {
            return "no";
        }
        return "yes";
    }

    public static String boolean2XML(boolean b) {
        if (!b) {
            return "no";
        }
        return "yes";
    }

    public static boolean xml2boolean(String xml) {
        return "yes".equals(xml);
    }

    public static CDATASection createCDATASection(Document document, String value) {
        return document.createCDATASection(BPELUtils.stripExtraCR(value));
    }

    public static String stripExtraCR(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            result.append(chars[i]);
            if (i < chars.length - 1 && chars[i] == '\r' && chars[i + 1] == '\n') {
                ++i;
            }
            ++i;
        }
        return result.toString();
    }

    public static BPELResourceSetImpl slightlyHackedResourceSet(ResourceSet resourceSet) {
        if (resourceSet instanceof BPELResourceSetImpl) {
            return (BPELResourceSetImpl)resourceSet;
        }
        Map map = resourceSet.getLoadOptions();
        BPELResourceSetImpl result = (BPELResourceSetImpl)((Object)map.get("slightly.hacked.resource.set"));
        if (result == null) {
            result = new BPELResourceSetImpl();
            map.put("slightly.hacked.resource.set", result);
        }
        return result;
    }

    public static BPELResourceSetImpl slightlyHackedResourceSet(EObject eObj) {
        return BPELUtils.slightlyHackedResourceSet(eObj.eResource().getResourceSet());
    }

    public static Locale lookupLocaleFor(String key) {
        if (key == null) {
            return Locale.getDefault();
        }
        Locale locale = string2Locale.get(key = key.replace('_', '-').toLowerCase());
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String lookupLocaleKeyFor(Locale locale) {
        if (locale == null) {
            return locale2String.get(Locale.getDefault());
        }
        String key = locale2String.get(locale);
        if (key == null) {
            key = locale2String.get(Locale.getDefault());
        }
        return key;
    }

    public static boolean isEmptyOrWhitespace(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        int i = 0;
        int j = value.length();
        while (i < j) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidPrefixName(String pfx) {
        if (pfx == null) {
            return false;
        }
        return NCNAME_DETECTOR.isValid((CharSequence)pfx);
    }

    public static boolean isTransparent(Object parent, Object child) {
        return child instanceof FaultHandler && parent instanceof Invoke || child instanceof Expression && parent instanceof From || child instanceof Expression && parent instanceof To;
    }

    public static boolean isActivityNode(Node node) {
        String name = node.getLocalName();
        return BPELUtils.isBPELElement(node) && ("invoke".equals(name) || "assign".equals(name) || "while".equals(name) || "repeatUntil".equals(name) || "receive".equals(name) || "reply".equals(name) || "throw".equals(name) || "wait".equals(name) || "sequence".equals(name) || "pick".equals(name) || "flow".equals(name) || "scope".equals(name) || "compensate".equals(name) || "rethrow".equals(name) || "exit".equals(name) || "extensionActivity".equals(name) || "invoke".equals(name) || "forEach".equals(name) || "if".equals(name) || "validate".equals(name) || "compensateScope".equals(name) || "empty".equals(name) || "opaqueActivity".equals(name));
    }

    public static void copyInto(Node src, Node dest) throws DOMException {
        Document factory = dest.getOwnerDocument();
        boolean domimpl = factory instanceof DocumentImpl;
        Node start = src;
        Node parent = src;
        Node place = src;
        while (place != null) {
            Node node = null;
            short type = place.getNodeType();
            switch (type) {
                case 4: {
                    node = factory.createCDATASection(place.getNodeValue());
                    break;
                }
                case 8: {
                    node = factory.createComment(place.getNodeValue());
                    break;
                }
                case 1: {
                    Element element = factory.createElement(place.getNodeName());
                    node = element;
                    NamedNodeMap attrs = place.getAttributes();
                    int attrCount = attrs.getLength();
                    int i = 0;
                    while (i < attrCount) {
                        Attr attr = (Attr)attrs.item(i);
                        String attrName = attr.getNodeName();
                        String attrValue = attr.getNodeValue();
                        element.setAttribute(attrName, attrValue);
                        if (domimpl && !attr.getSpecified()) {
                            ((AttrImpl)element.getAttributeNode(attrName)).setSpecified(false);
                        }
                        ++i;
                    }
                    break;
                }
                case 5: {
                    node = factory.createEntityReference(place.getNodeName());
                    break;
                }
                case 7: {
                    node = factory.createProcessingInstruction(place.getNodeName(), place.getNodeValue());
                    break;
                }
                case 3: {
                    node = factory.createTextNode(place.getNodeValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("can't copy node type, " + type + " (" + place.getNodeName() + ')');
                }
            }
            dest.appendChild(node);
            if (place.hasChildNodes()) {
                parent = place;
                place = place.getFirstChild();
                dest = node;
                continue;
            }
            if (place != start) {
                place = place.getNextSibling();
                while (place == null && parent != start) {
                    place = parent.getNextSibling();
                    parent = parent.getParentNode();
                    dest = dest.getParentNode();
                }
                continue;
            }
            place = null;
        }
    }

    public static boolean isAbstractProcess(Process process) {
        Map<String, String> m = BPELUtils.getAllNamespacesForContext((EObject)process);
        boolean result = m.containsValue("http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
        return result;
    }
}

