/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.contentassist;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.contentassist.FunctionTemplatesContentAssistProcessor;
import org.eclipse.bpel.ui.contentassist.Messages;
import org.eclipse.bpel.ui.contentassist.XPathTemplateCompletionProcessor;
import org.eclipse.bpel.ui.details.providers.LinkContentProvider;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.XSDUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class ExpressionContentAssistProcessor
implements IContentAssistProcessor,
ICompletionListener {
    static String EMPTY_STRING = "";
    static ICompletionProposal[] EMPTY_COMPLETION_PROPOSALS = new ICompletionProposal[0];
    private Object theModel = null;
    private int theToggle = 3;
    private String theLastBeginsWith = EMPTY_STRING;
    private String theExpressionContext = EMPTY_STRING;
    private IContentAssistantExtension2 theContentAssistant;
    FunctionTemplatesContentAssistProcessor fFunctionTemplates = new FunctionTemplatesContentAssistProcessor();
    XPathTemplateCompletionProcessor fXpathTemplates = new XPathTemplateCompletionProcessor();
    static final String MINUS = "-";
    static final String PLUS = "+";
    static final String MULTIPLY = "*";
    static final String DIVIDE = "/";
    static final String OPEN_PAREN = "(";
    static final String CLOSE_PAREN = ")";
    static final String OPEN_BRACKET = "[";
    static final String CLOSE_BRACKET = "]";
    static final String COMMA = ",";
    static final String DOLLAR = "$";
    static final String EQUAL = "=";
    static final String NOT_EQUAL = "!=";
    static final String LESS_THAN = "<";
    static final String LESS_THAN_EQUAL = "<=";
    static final String GREATER_THAN = ">";
    static final String GREATER_THAN_EQUAL = ">=";
    static final String MOD = "mod";
    static final String DIV = "div";
    static final String AND = "and";
    static final String OR = "or";
    static final String COLON = ":";
    static final String AT = "@";
    static final String[] OPERATOR_LIST = new String[]{"and", "or", "=", "!=", "<", ">", "<=", ">=", "+", "-", "*", "div", "mod"};
    static final String RESERVED_OPERATOR_CHARS = "+-*/";
    static final String RESERVED_CLOSING_EXPR_CHARS = ")]";

    public void assistSessionStarted(ContentAssistEvent event) {
        IContentAssistant assistant = event.assistant;
        if (assistant instanceof IContentAssistantExtension2) {
            this.theContentAssistant = (IContentAssistantExtension2)assistant;
        }
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.theContentAssistant = null;
        this.theToggle = 3;
        this.theLastBeginsWith = EMPTY_STRING;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public void setModelObject(Object model) {
        this.theModel = model;
        this.fFunctionTemplates.setModel(model);
    }

    public void setExpressionContext(String expressionContext) {
        this.theExpressionContext = expressionContext;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.generateProposals(viewer, offset);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'$', '/', '@', '.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return Messages.getString("ExpressionContentAssistProcessor.32");
    }

    private ProposalType determineProposalType2(ITextViewer viewer, int offset) {
        XPathStack callStack = new XPathStack(viewer, offset);
        if (callStack.parse()) {
            ExpressionType expr = callStack.getSuggestion();
            if (expr != null) {
                switch (expr.theType) {
                    case 1: {
                        if (callStack.theStatus == 1) {
                            return new ProposalType(1, expr.theGrammar);
                        }
                        return new ProposalType(4, EMPTY_STRING);
                    }
                    case 2: {
                        if (callStack.theStatus == 1) {
                            return new ProposalType(2, expr.theGrammar);
                        }
                        return new ProposalType(4, EMPTY_STRING);
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        return new ProposalType(3, EMPTY_STRING);
                    }
                    case 4: 
                    case 100: 
                    case 101: 
                    case 102: {
                        return new ProposalType(4, EMPTY_STRING);
                    }
                    case 3: {
                        if (callStack.theStatus == 1) {
                            return new ProposalType(0, EMPTY_STRING);
                        }
                        return new ProposalType(4, EMPTY_STRING);
                    }
                }
                return new ProposalType(0, EMPTY_STRING);
            }
            return new ProposalType(3, EMPTY_STRING);
        }
        String tempContext = this.startOfVariable(viewer, offset);
        if (tempContext != null) {
            return new ProposalType(1, tempContext);
        }
        tempContext = this.startOfFunction(viewer, offset);
        if (tempContext != null) {
            return new ProposalType(2, tempContext);
        }
        return new ProposalType(3, EMPTY_STRING);
    }

    private ICompletionProposal[] generateProposals(ITextViewer viewer, int offset) {
        ProposalType propType = this.determineProposalType2(viewer, offset);
        boolean toggle = false;
        if (this.theLastBeginsWith.compareTo(propType.theBeginsWith) == 0) {
            toggle = true;
        } else {
            this.theLastBeginsWith = propType.theBeginsWith;
        }
        String funcStart = EMPTY_STRING;
        String varlinkStart = EMPTY_STRING;
        if (propType.isVariableAndFunction()) {
            this.theToggle = (this.theToggle + 1) % 4;
            funcStart = propType.theBeginsWith;
            varlinkStart = propType.theBeginsWith;
        } else if (propType.isVariable()) {
            this.theToggle = toggle ? (this.theToggle + 1) % 4 : 0;
            funcStart = EMPTY_STRING;
            varlinkStart = propType.theBeginsWith;
        } else if (propType.isFunction()) {
            this.theToggle = toggle ? (this.theToggle + 1) % 4 : 1;
            funcStart = propType.theBeginsWith;
            varlinkStart = EMPTY_STRING;
        } else if (propType.isOperator()) {
            this.theToggle = toggle ? (this.theToggle + 1) % 4 : 2;
            funcStart = EMPTY_STRING;
            varlinkStart = EMPTY_STRING;
        }
        switch (this.theToggle) {
            case 0: {
                this.theContentAssistant.setStatusMessage(Messages.getString("ExpressionContentAssistProcessor.44"));
                if (this.theExpressionContext.compareTo("joinCondition/boolean") == 0) {
                    return this.generateLinkProposals(varlinkStart, offset);
                }
                return this.generateVariableProposals(varlinkStart, offset);
            }
            case 1: {
                this.theContentAssistant.setStatusMessage(Messages.getString("ExpressionContentAssistProcessor.45"));
                return this.generateFunctionProposals(viewer, funcStart, offset);
            }
            case 2: {
                this.theContentAssistant.setStatusMessage(Messages.getString("ExpressionContentAssistProcessor.46"));
                return this.generateOperatorProposals(EMPTY_STRING, offset);
            }
            case 3: {
                if (this.theExpressionContext.compareTo("joinCondition/boolean") == 0) {
                    this.theContentAssistant.setStatusMessage(Messages.getString("ExpressionContentAssistProcessor.48"));
                } else {
                    this.theContentAssistant.setStatusMessage(Messages.getString("ExpressionContentAssistProcessor.49"));
                }
                return this.fXpathTemplates.computeCompletionProposals(viewer, offset);
            }
        }
        return null;
    }

    ICompletionProposal[] generateFunctionProposals(ITextViewer viewer, String context, int offset) {
        return this.fFunctionTemplates.computeCompletionProposals(viewer, offset);
    }

    ICompletionProposal[] generateOperatorProposals(String context, int offset) {
        Image img = BPELUIPlugin.INSTANCE.getImage("obj16/operation.gif");
        ICompletionProposal[] proposals = new ICompletionProposal[OPERATOR_LIST.length];
        int i = 0;
        while (i < OPERATOR_LIST.length) {
            proposals[i] = new CompletionProposal(OPERATOR_LIST[i], offset, 0, OPERATOR_LIST[i].length(), img, OPERATOR_LIST[i], null, null);
            ++i;
        }
        return proposals;
    }

    ICompletionProposal[] generateLinkProposals(String context, int offset) {
        ArrayList<CompletionProposal> results = new ArrayList<CompletionProposal>();
        Image linkImg = BPELUIPlugin.INSTANCE.getImage("obj16/link.gif");
        Object[] objectArray = new LinkContentProvider(0).getElements(this.theModel);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            Link link = (Link)next;
            String replName = DOLLAR + link.getName();
            if (replName.startsWith(context)) {
                results.add(new CompletionProposal(replName, offset - context.length(), context.length(), replName.length(), linkImg, link.getName(), null, null));
            }
            ++n2;
        }
        if (results.size() < 1) {
            return new ICompletionProposal[]{new CompletionProposal(EMPTY_STRING, offset, 0, 0, null, Messages.getString("ExpressionContentAssistProcessor.31"), null, null)};
        }
        return results.toArray(EMPTY_COMPLETION_PROPOSALS);
    }

    String getNamespacePrefix(EObject context, String namespace) {
        String prefix = BPELUtils.getNamespacePrefix((EObject)context, (String)namespace);
        while (prefix == null) {
            prefix = BPELUtil.lookupOrCreateNamespacePrefix(context, namespace, null, null);
            if (prefix != null) continue;
            throw new IllegalArgumentException("namespace prefix is null");
        }
        return prefix;
    }

    /*
     * WARNING - void declaration
     */
    ICompletionProposal[] generateVariableProposals(String context, int offset) {
        ArrayList<CompletionProposal> results;
        block48: {
            boolean seekChildren = false;
            String context2 = context.length() > 0 && context.charAt(0) == '$' ? context.substring(1) : context;
            int slash = context2.indexOf(47);
            int dot = context2.indexOf(46);
            int at = context2.indexOf(64);
            if (slash > -1 || dot > -1 || at > -1) {
                seekChildren = true;
            }
            Variable[] variables = BPELUtil.getVisibleVariables((EObject)this.theModel);
            results = new ArrayList<CompletionProposal>();
            CompletionProposal prop = null;
            Variable currVar = null;
            XSDTypeDefinition currXsdType = null;
            Message currMsg = null;
            XSDElementDeclaration currXsdElem = null;
            Image varImg = BPELUIPlugin.INSTANCE.getImage("obj16/variable.gif");
            Image partImg = BPELUIPlugin.INSTANCE.getImage("obj16/message_part.gif");
            Image elementImg = BPELUIPlugin.INSTANCE.getImage("obj16/XSDElementDeclaration.gif");
            Image attrImg = BPELUIPlugin.INSTANCE.getImage("obj16/XSDAttributeDeclaration.gif");
            try {
                if (seekChildren) {
                    XSDComplexTypeDefinition xsdcomplex;
                    Part item;
                    int index = 0;
                    int level = 0;
                    int token = -1;
                    char t = '\u0000';
                    while (index < context2.length()) {
                        t = context2.charAt(index);
                        if (t == '.' || t == '/') {
                            String levelName = context2.substring(token + 1, index);
                            if (level == 0) {
                                int i = 0;
                                while (i < variables.length) {
                                    if (levelName.compareTo(variables[i].getName()) == 0) {
                                        currVar = variables[i];
                                        currXsdType = currVar.getType();
                                        currMsg = currVar.getMessageType();
                                        currXsdElem = currVar.getXSDElement();
                                        ++level;
                                        break;
                                    }
                                    ++i;
                                }
                                if (currVar == null) {
                                    break;
                                }
                            } else {
                                boolean childFound = false;
                                if (context2.charAt(token) == '.') {
                                    if (currMsg != null && currMsg.getParts() != null) {
                                        for (Object next : currMsg.getParts().values()) {
                                            item = (Part)next;
                                            if (levelName.compareTo(item.getName()) != 0) continue;
                                            currXsdType = item.getTypeDefinition();
                                            currMsg = item.getEMessage();
                                            currXsdElem = item.getElementDeclaration();
                                            childFound = true;
                                            break;
                                        }
                                    }
                                    if (!childFound) {
                                        break;
                                    }
                                } else if (context2.charAt(token) == '/') {
                                    XSDSimpleTypeDefinition xsdsimple;
                                    String string;
                                    if (currXsdType == null && currXsdElem != null) {
                                        currXsdType = currXsdElem.getTypeDefinition();
                                    }
                                    if (currXsdType instanceof XSDComplexTypeDefinition) {
                                        xsdcomplex = (XSDComplexTypeDefinition)currXsdType;
                                        for (Object e : XSDUtils.getChildElements(xsdcomplex)) {
                                            String elemNSPrefix;
                                            XSDElementDeclaration elem = ((XSDElementDeclaration)e).getResolvedElementDeclaration();
                                            String elemName = elem.getName();
                                            if (elem.getTargetNamespace() != null && (elemNSPrefix = this.getNamespacePrefix((EObject)currVar, elem.getTargetNamespace())) != null) {
                                                elemName = String.valueOf(elemNSPrefix) + COLON + elemName;
                                            }
                                            if (levelName.compareTo(elemName) != 0) continue;
                                            currXsdType = elem.getTypeDefinition();
                                            currXsdElem = null;
                                            currMsg = null;
                                            childFound = true;
                                            break;
                                        }
                                    } else if (currXsdType instanceof XSDSimpleTypeDefinition && levelName.compareTo(string = (xsdsimple = (XSDSimpleTypeDefinition)currXsdType).getName()) == 0) {
                                        childFound = true;
                                    }
                                    if (!childFound) break;
                                }
                            }
                            token = index;
                        } else if (t == '@') {
                            token = index;
                        }
                        ++index;
                    }
                    if (index == context2.length()) {
                        String beginsWith = index - 1 == token ? EMPTY_STRING : context2.substring(token + 1);
                        if (context2.charAt(token) == '/' || context2.charAt(token) == '@') {
                            if (currXsdType == null && currXsdElem != null) {
                                currXsdType = currXsdElem.getTypeDefinition();
                            }
                            if (currXsdType instanceof XSDComplexTypeDefinition) {
                                void var27_37;
                                xsdcomplex = (XSDComplexTypeDefinition)currXsdType;
                                if (context2.charAt(token) == '/') {
                                    Iterator<XSDFeature> iterator = XSDUtils.getXSDElementsAndAttributes(xsdcomplex).iterator();
                                } else {
                                    Iterator<XSDAttributeDeclaration> iterator = XSDUtils.getChildAttributes(xsdcomplex).iterator();
                                }
                                Image img = null;
                                String tempReplName = null;
                                String tempDispName = null;
                                String namespace = null;
                                String nsprefix = null;
                                while (var27_37.hasNext()) {
                                    Object tempEA = var27_37.next();
                                    if (tempEA instanceof XSDAttributeDeclaration) {
                                        XSDAttributeDeclaration attr = (XSDAttributeDeclaration)tempEA;
                                        tempReplName = AT + attr.getName();
                                        tempDispName = attr.getName();
                                        namespace = attr.getTargetNamespace();
                                        if (namespace != null && namespace.length() > 0) {
                                            nsprefix = this.getNamespacePrefix((EObject)currVar, namespace);
                                            tempReplName = AT + nsprefix + COLON + attr.getName();
                                            tempDispName = String.valueOf(nsprefix) + COLON + tempDispName;
                                        }
                                        img = attrImg;
                                    } else if (tempEA instanceof XSDElementDeclaration) {
                                        XSDElementDeclaration elem = ((XSDElementDeclaration)tempEA).getResolvedElementDeclaration();
                                        tempDispName = tempReplName = elem.getName();
                                        namespace = elem.getTargetNamespace();
                                        if (namespace != null && namespace.length() > 0) {
                                            nsprefix = this.getNamespacePrefix((EObject)currVar, namespace);
                                            tempDispName = tempReplName = String.valueOf(nsprefix) + COLON + tempDispName;
                                        }
                                        img = elementImg;
                                    }
                                    if (tempReplName != null && (beginsWith.length() == 0 || tempDispName != null && tempDispName.startsWith(beginsWith))) {
                                        int replOffset = offset - beginsWith.length();
                                        int replLen = beginsWith.length();
                                        if (context2.charAt(token) == '@') {
                                            --replOffset;
                                            ++replLen;
                                        }
                                        prop = new CompletionProposal(tempReplName, replOffset, replLen, tempReplName.length(), img, String.valueOf(tempDispName) + "   ", null, null);
                                        results.add(prop);
                                    }
                                    tempReplName = null;
                                    tempDispName = null;
                                }
                            } else if (currXsdType instanceof XSDSimpleTypeDefinition) {
                                XSDSimpleTypeDefinition cfr_ignored_0 = (XSDSimpleTypeDefinition)currXsdType;
                            }
                        } else if (context2.charAt(token) == '.' && currMsg != null && currMsg.getParts() != null) {
                            for (Object next : currMsg.getParts().values()) {
                                item = (Part)next;
                                if (beginsWith.length() != 0 && !item.getName().startsWith(beginsWith)) continue;
                                prop = new CompletionProposal(item.getName(), offset - beginsWith.length(), beginsWith.length(), item.getName().length(), partImg, String.valueOf(item.getName()) + "   ", null, null);
                                results.add(prop);
                            }
                        }
                    }
                    break block48;
                }
                Variable[] variableArray = variables;
                int n = variables.length;
                int n2 = 0;
                while (n2 < n) {
                    Variable v = variableArray[n2];
                    String name = v.getName();
                    if (name.startsWith(context2)) {
                        prop = new CompletionProposal(DOLLAR + name, offset - context.length(), context.length(), name.length() + 1, varImg, String.valueOf(name) + "   ", null, null);
                        results.add(prop);
                    }
                    ++n2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                results.toArray(EMPTY_COMPLETION_PROPOSALS);
            }
        }
        if (results.size() < 1) {
            return new ICompletionProposal[]{new CompletionProposal(EMPTY_STRING, offset, 0, 0, null, Messages.getString("ExpressionContentAssistProcessor.31"), null, null)};
        }
        return results.toArray(EMPTY_COMPLETION_PROPOSALS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String startOfVariable(ITextViewer viewer, int offset) {
        int startPosition = offset - 1;
        String context = EMPTY_STRING;
        IDocument document = viewer.getDocument();
        try {
            while (true) {
                if (startPosition < 0) {
                    return null;
                }
                char currChar = document.getChar(startPosition);
                if (currChar == '$') {
                    return context;
                }
                if (!Character.isLetterOrDigit(currChar) && currChar != '/' && currChar != '.' && currChar != '@' && currChar != '_') {
                    return null;
                }
                context = String.valueOf(currChar) + context;
                --startPosition;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String startOfFunction(ITextViewer viewer, int offset) {
        int startPosition = offset - 1;
        String context = EMPTY_STRING;
        IDocument document = viewer.getDocument();
        try {
            while (true) {
                if (startPosition < 0) {
                    return context;
                }
                char currChar = document.getChar(startPosition);
                if (Character.isWhitespace(currChar) || this.isReservedOperatorCharacter(currChar) || currChar == '(' || currChar == '[') {
                    if (context.length() <= 0) return null;
                    return context;
                }
                context = String.valueOf(currChar) + context;
                --startPosition;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return context;
    }

    private boolean isLocationPathCharacter(char c) {
        return "./:@-".indexOf(c) > -1 || Character.isLetterOrDigit(c) || c == '_';
    }

    private boolean isReservedOperatorCharacter(char c) {
        return RESERVED_OPERATOR_CHARS.indexOf(c) > -1;
    }

    private boolean isClosingExpressionCharacter(char c) {
        return RESERVED_CLOSING_EXPR_CHARS.indexOf(c) > -1;
    }

    static /* synthetic */ boolean access$0(ExpressionContentAssistProcessor expressionContentAssistProcessor, char c) {
        return expressionContentAssistProcessor.isReservedOperatorCharacter(c);
    }

    static /* synthetic */ boolean access$1(ExpressionContentAssistProcessor expressionContentAssistProcessor, char c) {
        return expressionContentAssistProcessor.isClosingExpressionCharacter(c);
    }

    class ExpressionType {
        private int theType;
        private String theGrammar;
        static final int EXPRTYPE_VARIABLE = 1;
        static final int EXPRTYPE_FUNCTION = 2;
        static final int EXPRTYPE_LITERAL = 3;
        static final int EXPRTYPE_NUMBER = 4;
        static final int EXPRTYPE_UNARY_OPERATOR = 5;
        static final int EXPRTYPE_NUMERIC_OPERATOR = 6;
        static final int EXPRTYPE_BOOLEAN_OPERATOR = 7;
        static final int EXPRTYPE_NEW_EXPRESSION = 8;
        static final int EXPRTYPE_FUNCTION_ARGUMENTS = 9;
        static final int EXPRTYPE_FUNCTION_ARGUMENT_SEPARATOR = 10;
        static final int CLASS_NUMERIC = 100;
        static final int CLASS_BOOLEAN = 101;
        static final int CLASS_EXPRESSION = 102;

        ExpressionType(int type, String grammar) {
            this.theType = type;
            this.theGrammar = grammar;
        }
    }

    class ProposalType {
        private int theType;
        private String theBeginsWith;
        static final int PROPTYPE_VARIABLE = 1;
        static final int PROPTYPE_FUNCTION = 2;
        static final int PROPTYPE_OPERATOR = 4;

        ProposalType(int type, String beginsWith) {
            this.theType = type;
            this.theBeginsWith = beginsWith;
        }

        boolean isVariable() {
            return (this.theType & 1) == 1;
        }

        boolean isFunction() {
            return (this.theType & 2) == 2;
        }

        boolean isOperator() {
            return (this.theType & 4) == 4;
        }

        boolean isVariableAndFunction() {
            return (this.theType & 3) == 3;
        }
    }

    protected class XPathStack {
        Stack<ExpressionType> theCallStack = new Stack();
        int theStatus = 0;
        IDocument theDocument;
        int theOffset;
        int theIndex;
        int theTopOfStackExprType = -1;

        XPathStack(ITextViewer viewer, int offset) {
            this.theDocument = viewer.getDocument();
            this.theOffset = offset;
            this.theIndex = 0;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive exception aggregation
         */
        private boolean parseNumberExpression() throws BadLocationException {
            proceed = false;
            while (this.theIndex < this.theOffset) {
                block32: {
                    block42: {
                        block40: {
                            block41: {
                                block35: {
                                    block38: {
                                        block39: {
                                            block36: {
                                                block37: {
                                                    block34: {
                                                        block33: {
                                                            block31: {
                                                                currChar = this.theDocument.getChar(this.theIndex);
                                                                if (currChar != '$') break block31;
                                                                if (this.theTopOfStackExprType == 5 || this.theTopOfStackExprType == 6) {
                                                                    return this.parseVariable();
                                                                }
                                                                if (!this.parseVariable()) {
                                                                    return false;
                                                                }
                                                                break block32;
                                                            }
                                                            if (currChar != '\'' && currChar != '\"') break block33;
                                                            if (this.theTopOfStackExprType == 5 || this.theTopOfStackExprType == 6) {
                                                                return this.parseLiteral();
                                                            }
                                                            if (!this.parseLiteral()) {
                                                                return false;
                                                            }
                                                            break block32;
                                                        }
                                                        if (!Character.isDigit(currChar) && currChar != '.') break block34;
                                                        if (this.theTopOfStackExprType == 5 || this.theTopOfStackExprType == 6) {
                                                            return this.parseNumber();
                                                        }
                                                        if (!this.parseNumber()) {
                                                            return false;
                                                        }
                                                        break block32;
                                                    }
                                                    if (!ExpressionContentAssistProcessor.access$0(ExpressionContentAssistProcessor.this, currChar)) break block35;
                                                    if (this.theTopOfStackExprType != 7 && this.theTopOfStackExprType != 6 && this.theTopOfStackExprType != 5 && this.theTopOfStackExprType != -1) break block36;
                                                    if (currChar != '-') break block37;
                                                    this.theCallStack.push(new ExpressionType(5, "-"));
                                                    this.theTopOfStackExprType = 5;
                                                    ++this.theIndex;
                                                    if (this.parseNumberExpression()) {
                                                        this.theCallStack.pop();
                                                        this.theCallStack.pop();
                                                        this.theCallStack.push(new ExpressionType(100, ExpressionContentAssistProcessor.EMPTY_STRING));
                                                        this.theTopOfStackExprType = 100;
                                                    }
                                                    break block32;
                                                }
                                                this.theStatus = -1;
                                                return false;
                                            }
                                            tempOper = Character.toString(currChar);
                                            if (this.theIndex + 1 >= this.theOffset) break block38;
                                            if (ExpressionContentAssistProcessor.access$0(ExpressionContentAssistProcessor.this, this.theDocument.getChar(this.theIndex + 1))) {
                                                ++this.theIndex;
                                                tempOper = String.valueOf(tempOper) + Character.toString(this.theDocument.getChar(this.theIndex));
                                            }
                                            tempType = 0;
                                            tempType = tempOper.compareTo("+") == 0 || tempOper.compareTo("-") == 0 || tempOper.compareTo("*") == 0 || tempOper.compareTo("/") == 0 ? 6 : 7;
                                            this.theCallStack.push(new ExpressionType(tempType, tempOper));
                                            this.theTopOfStackExprType = tempType;
                                            ++this.theIndex;
                                            if (tempType == 7) {
                                                return this.parseBooleanExpression();
                                            }
                                            if (!this.parseNumberExpression()) break block39;
                                            this.theCallStack.pop();
                                            this.theCallStack.pop();
                                            this.theCallStack.pop();
                                            this.theCallStack.push(new ExpressionType(100, ExpressionContentAssistProcessor.EMPTY_STRING));
                                            this.theTopOfStackExprType = 100;
                                            break block32;
                                        }
                                        return false;
                                    }
                                    tempType = 0;
                                    tempType = tempOper.compareTo("+") == 0 || tempOper.compareTo("-") == 0 || tempOper.compareTo("*") == 0 || tempOper.compareTo("/") == 0 ? 6 : 7;
                                    this.theCallStack.push(new ExpressionType(tempType, tempOper));
                                    this.theTopOfStackExprType = tempType;
                                    return false;
                                }
                                if (Character.isWhitespace(currChar)) break block32;
                                if (currChar != '(') break block40;
                                this.theCallStack.push(new ExpressionType(8, Character.toString(currChar)));
                                this.theTopOfStackExprType = 8;
                                ++this.theIndex;
                                if (!this.parseBooleanExpression()) break block41;
                                tempExpr = this.theCallStack.peek();
                                type = ExpressionType.access$0(tempExpr);
                                this.theCallStack.push(new ExpressionType(102, ExpressionContentAssistProcessor.EMPTY_STRING));
                                this.theTopOfStackExprType = 102;
                                if (type == 5 || this.theTopOfStackExprType == 7 || this.theTopOfStackExprType == 6) {
                                    return true;
                                }
                                break block32;
                            }
                            return false;
                        }
                        if (ExpressionContentAssistProcessor.access$1(ExpressionContentAssistProcessor.this, currChar)) {
                            try {
                                tempExpr = this.theCallStack.pop();
                                while (ExpressionType.access$0(tempExpr) != 8 && ExpressionType.access$0(tempExpr) != 9) {
                                    tempExpr = this.theCallStack.pop();
                                }
                                if (tempExpr != null) {
                                    if (ExpressionType.access$0(tempExpr) == 8) {
                                        switch (currChar) {
                                            case ')': {
                                                if (ExpressionType.access$1(tempExpr).compareTo("(") == 0) {
                                                    return true;
                                                }
                                                this.theStatus = -1;
                                                return false;
                                            }
                                            case ']': {
                                                if (ExpressionType.access$1(tempExpr).compareTo("[") == 0) {
                                                    return true;
                                                }
                                                this.theStatus = -1;
                                                return false;
                                            }
                                        }
                                        this.theStatus = -1;
                                        return false;
                                    }
                                    if (ExpressionType.access$0(tempExpr) == 9) {
                                        if (currChar == ')') {
                                            return true;
                                        }
                                        this.theStatus = -1;
                                        return false;
                                    }
                                    this.theStatus = -1;
                                    return false;
                                }
                            }
                            catch (EmptyStackException v0) {
                                this.theStatus = -1;
                                return false;
                            }
                            this.theStatus = -1;
                            return false;
                        }
                        if (currChar == ',') {
                            return true;
                        }
                        type = this.theTopOfStackExprType;
                        proceed = this.parseWord();
                        if (!proceed) break block42;
                        if (this.theTopOfStackExprType != 6 && this.theTopOfStackExprType != 7) ** GOTO lbl155
                        if (type == 6 || type == 7 || type == 5 || type == -1) {
                            this.theStatus = -1;
                            return false;
                        }
                        ++this.theIndex;
                        if (this.theTopOfStackExprType == 7) {
                            return this.parseBooleanExpression();
                        }
                        if (this.parseNumberExpression()) {
                            this.theCallStack.pop();
                            this.theCallStack.pop();
                            this.theCallStack.pop();
                            this.theCallStack.push(new ExpressionType(100, ExpressionContentAssistProcessor.EMPTY_STRING));
                            this.theTopOfStackExprType = 100;
                        } else {
                            return false;
lbl155:
                            // 1 sources

                            if (type == 5 || this.theTopOfStackExprType == 7 || this.theTopOfStackExprType == 6) {
                                return true;
                            }
                        }
                        break block32;
                    }
                    return false;
                }
                ++this.theIndex;
            }
            return false;
        }

        boolean parseBooleanExpression() throws BadLocationException {
            boolean proceed = this.parseNumberExpression();
            while (proceed) {
                ExpressionType tempExpr = this.theCallStack.peek();
                if (tempExpr.theType == 7) {
                    proceed = this.parseNumberExpression();
                    continue;
                }
                return proceed;
            }
            return proceed;
        }

        private boolean parseWord() throws BadLocationException {
            String word = EMPTY_STRING;
            while (this.theIndex < this.theOffset) {
                char nextChar = this.theDocument.getChar(this.theIndex);
                if (nextChar == '(' && word.length() > 0) {
                    this.theCallStack.push(new ExpressionType(2, word));
                    this.theTopOfStackExprType = 2;
                    boolean proceed = this.parseFunction();
                    if (proceed) {
                        this.theCallStack.pop();
                        this.theCallStack.push(new ExpressionType(102, EMPTY_STRING));
                        this.theTopOfStackExprType = 102;
                        return true;
                    }
                    return false;
                }
                if (Character.isWhitespace(nextChar) && word.length() > 0) {
                    if (word.compareToIgnoreCase(ExpressionContentAssistProcessor.MOD) == 0 || word.compareToIgnoreCase(ExpressionContentAssistProcessor.DIV) == 0) {
                        this.theCallStack.push(new ExpressionType(6, word));
                        this.theTopOfStackExprType = 6;
                        return true;
                    }
                    if (word.compareToIgnoreCase(ExpressionContentAssistProcessor.AND) == 0 || word.compareToIgnoreCase(ExpressionContentAssistProcessor.OR) == 0) {
                        this.theCallStack.push(new ExpressionType(7, word));
                        this.theTopOfStackExprType = 7;
                        return true;
                    }
                    int tempIndex = this.theIndex;
                    while (tempIndex < this.theOffset) {
                        if (!Character.isWhitespace(this.theDocument.getChar(tempIndex))) {
                            if (this.theDocument.getChar(tempIndex) == '(') break;
                            this.theStatus = -1;
                            return false;
                        }
                        ++tempIndex;
                    }
                }
                word = String.valueOf(word) + nextChar;
                ++this.theIndex;
            }
            if (this.theIndex >= this.theOffset) {
                this.theCallStack.push(new ExpressionType(2, word));
                this.theStatus = 1;
                return false;
            }
            return false;
        }

        private boolean parseFunction() throws BadLocationException {
            while (this.theIndex < this.theOffset) {
                char nextChar = this.theDocument.getChar(this.theIndex);
                if (nextChar == '(') {
                    this.theCallStack.push(new ExpressionType(9, ExpressionContentAssistProcessor.OPEN_PAREN));
                } else {
                    boolean proceed;
                    if (nextChar == ')') {
                        block10: {
                            block12: {
                                ExpressionType tempExpr;
                                block11: {
                                    try {
                                        tempExpr = this.theCallStack.peek();
                                        if (tempExpr == null) break block10;
                                        if (tempExpr.theType != 2) break block11;
                                        return true;
                                    }
                                    catch (EmptyStackException emptyStackException) {
                                        this.theStatus = -1;
                                        return false;
                                    }
                                }
                                if (tempExpr.theType != 9) break block12;
                                this.theCallStack.pop();
                                return true;
                            }
                            this.theStatus = -1;
                            return false;
                        }
                        this.theStatus = -1;
                        return false;
                    }
                    if (nextChar == ',') {
                        ++this.theIndex;
                        this.theCallStack.push(new ExpressionType(10, ExpressionContentAssistProcessor.COMMA));
                        proceed = this.parseBooleanExpression();
                        if (proceed) continue;
                        return false;
                    }
                    if (!Character.isWhitespace(nextChar)) {
                        proceed = this.parseBooleanExpression();
                        if (proceed) continue;
                        return false;
                    }
                }
                ++this.theIndex;
            }
            return false;
        }

        private boolean parseLiteral() throws BadLocationException {
            char nextChar;
            String literal = EMPTY_STRING;
            char delimiter = nextChar = this.theDocument.getChar(this.theIndex);
            literal = String.valueOf(literal) + nextChar;
            ++this.theIndex;
            while (this.theIndex < this.theOffset) {
                nextChar = this.theDocument.getChar(this.theIndex);
                if (nextChar == delimiter) {
                    literal = String.valueOf(literal) + nextChar;
                    this.theCallStack.push(new ExpressionType(3, literal));
                    this.theTopOfStackExprType = 3;
                    return true;
                }
                literal = String.valueOf(literal) + nextChar;
                ++this.theIndex;
            }
            if (this.theIndex >= this.theOffset) {
                this.theCallStack.push(new ExpressionType(3, literal));
                this.theStatus = 1;
                return false;
            }
            return false;
        }

        private boolean parseNumber() throws BadLocationException {
            String number = EMPTY_STRING;
            while (this.theIndex < this.theOffset) {
                char nextChar = this.theDocument.getChar(this.theIndex);
                if (!Character.isDigit(nextChar) && nextChar != '.') {
                    this.theCallStack.push(new ExpressionType(4, number));
                    this.theTopOfStackExprType = 4;
                    --this.theIndex;
                    return true;
                }
                number = String.valueOf(number) + nextChar;
                ++this.theIndex;
            }
            if (this.theIndex >= this.theOffset) {
                this.theCallStack.push(new ExpressionType(4, number));
                return false;
            }
            return false;
        }

        private boolean parseVariable() throws BadLocationException {
            ++this.theIndex;
            String variable = ExpressionContentAssistProcessor.DOLLAR;
            while (this.theIndex < this.theOffset) {
                block11: {
                    char nextChar = this.theDocument.getChar(this.theIndex);
                    if (ExpressionContentAssistProcessor.this.isLocationPathCharacter(nextChar)) {
                        variable = String.valueOf(variable) + nextChar;
                    } else {
                        if (nextChar == '[') {
                            this.theCallStack.push(new ExpressionType(1, variable));
                            this.theCallStack.push(new ExpressionType(8, ExpressionContentAssistProcessor.OPEN_BRACKET));
                            ++this.theIndex;
                            boolean proceed = this.parseBooleanExpression();
                            if (proceed) {
                                nextChar = this.theDocument.getChar(this.theIndex);
                                if (nextChar == ']') {
                                    try {
                                        ExpressionType tempExpr = this.theCallStack.pop();
                                        while (tempExpr.theType != 8) {
                                            tempExpr = this.theCallStack.pop();
                                        }
                                        if (tempExpr != null && tempExpr.theGrammar.compareTo(ExpressionContentAssistProcessor.CLOSE_BRACKET) == 0) {
                                            return true;
                                        }
                                        break block11;
                                    }
                                    catch (EmptyStackException emptyStackException) {
                                        this.theStatus = -1;
                                        return false;
                                    }
                                }
                                this.theStatus = -1;
                                return false;
                            }
                            return proceed;
                        }
                        this.theCallStack.push(new ExpressionType(1, variable));
                        this.theTopOfStackExprType = 1;
                        --this.theIndex;
                        return true;
                    }
                }
                ++this.theIndex;
            }
            if (this.theIndex >= this.theOffset) {
                this.theCallStack.push(new ExpressionType(1, variable));
                this.theStatus = 1;
                return false;
            }
            this.theStatus = -1;
            return false;
        }

        public boolean parse() {
            try {
                this.parseBooleanExpression();
                return this.theStatus != -1;
            }
            catch (BadLocationException e) {
                System.out.println(e.toString());
                return false;
            }
        }

        public ExpressionType getSuggestion() {
            try {
                return this.theCallStack.peek();
            }
            catch (EmptyStackException emptyStackException) {
                return null;
            }
        }
    }
}

