/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.providers;

import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.ui.details.tree.ITreeNode;
import org.eclipse.bpel.ui.details.tree.PortTypeTreeNode;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PartnerRoleFilter
extends ViewerFilter
implements IFilter {
    boolean requireMyRole = true;
    boolean requirePartnerRole = true;

    public PartnerRoleFilter() {
    }

    public PartnerRoleFilter(boolean requireMyRole, boolean requirePartnerRole) {
        this.requireMyRole = requireMyRole;
        this.requirePartnerRole = requirePartnerRole;
    }

    public void setRequireMyRole(boolean value) {
        this.requireMyRole = value;
    }

    public void setRequirePartnerRole(boolean value) {
        this.requirePartnerRole = value;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof PortTypeTreeNode) {
            return this.select(element);
        }
        if (element instanceof ITreeNode) {
            return this.select(((ITreeNode)element).getModelObject());
        }
        return this.select(element);
    }

    public boolean select(Object toTest) {
        if (toTest == null) {
            return false;
        }
        if (!this.requireMyRole && !this.requirePartnerRole) {
            return true;
        }
        if (PartnerLink.class.isInstance(toTest)) {
            PartnerLink partnerLink = (PartnerLink)toTest;
            if (this.requireMyRole && partnerLink.getMyRole() == null) {
                return false;
            }
            if (this.requirePartnerRole && partnerLink.getPartnerRole() == null) {
                return false;
            }
        }
        if (PortTypeTreeNode.class.isInstance(toTest)) {
            PortTypeTreeNode portTypeTreeNode = (PortTypeTreeNode)toTest;
            if (!portTypeTreeNode.isDerivedFromMyRole() && this.requireMyRole) {
                return false;
            }
            if (!portTypeTreeNode.isDerivedFromPartnerRole() && this.requirePartnerRole) {
                return false;
            }
        }
        return true;
    }
}

