/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.borders;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.editparts.borders.CollapsableBorder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ContainerBorder
extends CollapsableBorder {
    private static final int leftMargin = 6;
    private static final int rightMargin = 10;
    private static final int topMargin = 6;
    private static final int bottomMargin = 3;
    static final int spacing = 5;
    static final int borderWidth = 1;
    static final int margin = 11;
    static final int hBorderInsets = 3;
    static final int vBorderInsets = 22;
    private RoundedRectangle roundRect = new RoundedRectangle();
    private Rectangle rectExpandedTop;
    private Rectangle rectExpandedBottom;
    private Rectangle rectLabel;
    private Rectangle rectImageLabel;
    private Rectangle rectLabelBorder;
    private Rectangle expandedBounds;

    public ContainerBorder(IFigure parentFigure, Image image, String labelText) {
        super(true, 7, parentFigure, labelText, image);
        this.roundRect.setOpaque(true);
        this.roundRect.setCornerDimensions(new Dimension(7, 7));
    }

    public Dimension getPreferredSize(IFigure f) {
        this.calculate(f);
        Dimension d = new Dimension(this.rectLabelBorder.getSize().width, this.rectLabelBorder.getSize().height + this.expandedHeight);
        d.width += 32;
        if (!this.isCollapsed()) {
            d.width += 14;
        }
        return d;
    }

    @Override
    protected void doPaint(IFigure figure, Graphics graphics, Insets insets) {
        boolean needSquareCorners;
        super.doPaint(figure, graphics, insets);
        ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
        graphics.setForegroundColor(registry.get("compositeActivityBorder"));
        if (!this.isCollapsed()) {
            graphics.drawRoundRectangle(this.expandedBounds, 7, 7);
        }
        boolean bl = needSquareCorners = this.getTopMarker() != null || this.getBottomMarker() != null;
        if (this.isCollapsed() && needSquareCorners) {
            Rectangle oldClip = new Rectangle();
            oldClip = graphics.getClip(oldClip);
            Rectangle clippingRect = new Rectangle(this.rectLabelBorder.x + this.rectLabelBorder.width / 2, this.rectLabelBorder.y, this.rectLabelBorder.width / 2 + 2, this.rectLabelBorder.height + 1);
            graphics.setClip(clippingRect);
            graphics.drawRoundRectangle(this.rectLabelBorder, 7, 7);
            clippingRect = new Rectangle(this.rectLabelBorder.x, this.rectLabelBorder.y, this.rectLabelBorder.width / 2 + 1, this.rectLabelBorder.height + 1);
            graphics.setClip(clippingRect);
            graphics.drawRectangle(this.rectLabelBorder);
            graphics.setClip(oldClip);
        } else {
            this.roundRect.setBounds(this.rectLabelBorder);
            this.roundRect.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("activityBorder"));
            this.roundRect.paint(graphics);
        }
        Color old = graphics.getForegroundColor();
        graphics.setForegroundColor(registry.get("COLOR_BLACK"));
        this.collapsedNameLabel.setBounds(this.rectLabel);
        this.collapsedNameLabel.paint(graphics);
        this.imageLabel.setBounds(this.rectImageLabel);
        this.imageLabel.paint(graphics);
        graphics.setForegroundColor(old);
        if (this.isCollapsed()) {
            graphics.drawImage(this.collapsedImage, this.rectCollapsed.getLocation());
        } else {
            graphics.drawImage(this.expandedImage, this.rectExpandedTop.getLocation());
            graphics.drawImage(this.expandedImage, this.rectExpandedBottom.getLocation());
        }
    }

    @Override
    protected void calculate(IFigure figure) {
        Image bottomImage;
        Image topImage;
        IMarker bottomMarker;
        super.calculate(figure);
        Rectangle figureBounds = figure.getBounds().getCopy();
        Dimension imageLabelSize = this.imageLabel.getPreferredSize().getCopy();
        Dimension labelSize = this.collapsedNameLabel.getPreferredSize().getCopy();
        int w = labelSize.width + 5 + imageLabelSize.width;
        int h = Math.max(labelSize.height, imageLabelSize.height);
        int x = figureBounds.x + figureBounds.width / 2 - w / 2;
        int y = figureBounds.y;
        this.rectLabelBorder = new Rectangle(x, y, w, h);
        int verticalMargin = 9;
        if (this.isCollapsed()) {
            --verticalMargin;
        }
        this.rectLabelBorder.expand(new Insets(0, 6, verticalMargin, 10));
        x = this.rectLabelBorder.x + 6;
        y = this.rectLabelBorder.y + 6;
        w = imageLabelSize.width;
        h = imageLabelSize.height;
        this.rectImageLabel = new Rectangle(x, y, w, h);
        x = this.rectLabelBorder.x + 6 + imageLabelSize.width + 5;
        y = this.rectLabelBorder.y + 6;
        w = labelSize.width;
        h = labelSize.height;
        this.rectLabel = new Rectangle(x, y, w, h);
        this.expandedBounds = figureBounds.getCopy();
        this.expandedBounds.x += 16;
        this.expandedBounds.width -= 32;
        this.expandedBounds.y += this.rectLabelBorder.height / 2;
        this.expandedBounds.height -= this.rectLabelBorder.height / 2;
        this.expandedBounds.height -= this.expandedHeight / 2;
        this.rectExpandedTop = new Rectangle(this.rectLabelBorder.x + this.rectLabelBorder.width / 2 - this.expandedWidth / 2, this.rectLabelBorder.y + this.rectLabelBorder.height - 1, this.expandedWidth, this.expandedHeight);
        this.rectExpandedBottom = new Rectangle(figureBounds.x + figureBounds.width / 2 - this.expandedWidth / 2, figureBounds.y + figureBounds.height - this.expandedHeight, this.expandedWidth, this.expandedHeight);
        IMarker topMarker = this.getTopMarker();
        if (topMarker != null) {
            if (this.isCollapsed()) {
                this.topDrawerLocation.x = this.collapsedRectangle.x - 16 + 30 + 1;
                this.topDrawerLocation.y = this.collapsedRectangle.y;
            } else {
                this.topDrawerLocation.x = this.expandedBounds.x - 16;
                this.topDrawerLocation.y = this.expandedBounds.y + 7;
            }
        }
        if ((bottomMarker = this.getBottomMarker()) != null) {
            if (this.isCollapsed()) {
                this.bottomDrawerLocation.x = this.collapsedRectangle.x - 16 + 30 + 1;
                this.bottomDrawerLocation.y = this.collapsedRectangle.y + 12;
            } else {
                this.bottomDrawerLocation.x = this.expandedBounds.x - 16;
                this.bottomDrawerLocation.y = this.expandedBounds.y + 12 + 7;
            }
        }
        if ((topImage = this.getTopImage()) != null) {
            if (this.isCollapsed()) {
                this.topImageLocation.x = this.collapsedRectangle.x - 16 + 30 + 2;
                this.topImageLocation.y = this.collapsedRectangle.y + 30;
            } else {
                this.topImageLocation.x = this.expandedBounds.x - 16 + 30;
                this.topImageLocation.y = this.expandedBounds.y + 7 + 30;
            }
        }
        if ((bottomImage = this.getBottomImage()) != null) {
            if (this.isCollapsed()) {
                this.bottomImageLocation.x = this.collapsedRectangle.x - 16 + 30 + 2;
                this.bottomImageLocation.y = this.collapsedRectangle.y + 30 + 12;
            } else {
                this.bottomImageLocation.x = this.expandedBounds.x - 16 + 30;
                this.bottomImageLocation.y = this.expandedBounds.y + 7 + 12 + 30;
            }
        }
    }

    @Override
    public Insets getInsets(IFigure figure) {
        if (this.isCollapsed()) {
            return super.getInsets(figure);
        }
        this.calculate(figure);
        Insets result = new Insets(22 + this.rectLabelBorder.height, 3, 22, 3);
        result.left += 16;
        result.right += 16;
        return result;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.rectLabelBorder = null;
        this.rectLabel = null;
        this.rectExpandedTop = null;
        this.rectExpandedBottom = null;
    }

    @Override
    public boolean isPointInCollapseImage(int x, int y) {
        if (this.isCollapsed()) {
            return super.isPointInCollapseImage(x, y);
        }
        Point p = new Point(x, y);
        this.parentFigure.translateToRelative((Translatable)p);
        Rectangle rect = this.rectExpandedTop.getCopy();
        rect.expand(new Insets(1, 1, 1, 1));
        if (rect.contains(p)) {
            return true;
        }
        if (!this.isCollapsed()) {
            rect = this.rectExpandedBottom.getCopy();
            rect.expand(new Insets(1, 1, 1, 1));
            return rect.contains(p);
        }
        return false;
    }

    @Override
    protected Rectangle getGradientRect() {
        if (this.isCollapsed()) {
            return super.getGradientRect();
        }
        this.invalidate();
        this.calculate(this.parentFigure);
        return this.expandedBounds;
    }

    public int getTopInset() {
        if (this.rectLabelBorder == null || this.expandedBounds == null) {
            this.calculate(this.parentFigure);
        }
        return this.expandedBounds.y - this.rectLabelBorder.y;
    }
}

