/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.lane;

import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveLaneFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveFromParticipantToLaneFeature
extends MoveLaneFeature {
    public MoveFromParticipantToLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        boolean targetHasFlowNodeRefs;
        Lane movedLane = this.getMovedLane(context);
        boolean moveableHasFlowNodes = movedLane.getFlowNodeRefs().size() > 0;
        Lane targetLane = this.getTargetLane((ITargetContext)context);
        boolean bl = targetHasFlowNodeRefs = targetLane.getFlowNodeRefs().size() > 0;
        if (!moveableHasFlowNodes && !targetHasFlowNodeRefs) {
            return true;
        }
        return moveableHasFlowNodes ^ targetHasFlowNodeRefs;
    }

    @Override
    protected void internalMove(IMoveShapeContext context) {
        this.modifyModelStructure(context);
        this.layoutPictogramElement((PictogramElement)context.getSourceContainer());
        this.layoutPictogramElement((PictogramElement)context.getTargetContainer());
    }

    private void modifyModelStructure(IMoveShapeContext context) {
        Lane movedLane = this.getMovedLane(context);
        Lane targetLane = this.getTargetLane((ITargetContext)context);
        Process sourceProcess = this.getProcess(context.getSourceContainer());
        Process targetProcess = this.getProcess(targetLane);
        this.moveLane(movedLane, sourceProcess, targetProcess);
        for (LaneSet laneSet : sourceProcess.getLaneSets()) {
            if (!laneSet.getLanes().contains(movedLane)) continue;
            laneSet.getLanes().remove(movedLane);
            if (!laneSet.getLanes().isEmpty()) break;
            sourceProcess.getLaneSets().remove(laneSet);
            break;
        }
        if (targetLane.getChildLaneSet() == null) {
            LaneSet newLaneSet = this.createLaneSet();
            targetLane.setChildLaneSet(newLaneSet);
        }
        targetLane.getChildLaneSet().getLanes().add(movedLane);
    }
}

