/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class BoundaryEventPositionHelper {
    private static IPeService peService = Graphiti.getPeService();

    public static boolean canCreateEventAt(ICreateContext context, GraphicsAlgorithm ga, int padding) {
        return BoundaryEventPositionHelper.canCreateEventAt(context.getX(), context.getY(), ga.getWidth(), ga.getHeight(), padding);
    }

    public static boolean canCreateEventAt(int x, int y, GraphicsAlgorithm ga, int padding) {
        return BoundaryEventPositionHelper.canCreateEventAt(x, y, ga.getWidth(), ga.getHeight(), padding);
    }

    public static boolean canCreateEventAt(int x, int y, int w, int h, int padding) {
        int x1 = 0;
        int x2 = 0 + padding;
        int x3 = w - padding;
        int x4 = w;
        int y1 = 0;
        int y2 = 0 + padding;
        int y3 = h - padding;
        int y4 = h;
        if (y >= y1 && y <= y2 || y >= y3 && y <= y4) {
            return true;
        }
        return x >= x1 && x <= x2 || x >= x3 && x <= x4;
    }

    public static boolean canMoveTo(IMoveShapeContext context, Diagram diagram) {
        int x = context.getX() + context.getDeltaX();
        int y = context.getY() + context.getDeltaY();
        if (!(context.getTargetContainer() instanceof Diagram)) {
            ILocation loc = peService.getLocationRelativeToDiagram((Shape)context.getTargetContainer());
            x += loc.getX();
            y += loc.getY();
        }
        BoundaryEvent event = BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getShape(), BoundaryEvent.class);
        GraphicsAlgorithm eventGa = context.getShape().getGraphicsAlgorithm();
        PictogramElement firstBaseElement = BusinessObjectUtil.getFirstBaseElementFromDiagram(diagram, (BaseElement)event.getAttachedToRef());
        if (firstBaseElement == null || !(firstBaseElement instanceof ContainerShape)) {
            return false;
        }
        ContainerShape activityContainer = (ContainerShape)firstBaseElement;
        GraphicsAlgorithm activityGa = activityContainer.getGraphicsAlgorithm();
        ILocation activityLoc = peService.getLocationRelativeToDiagram((Shape)activityContainer);
        PositionOnLine pos = BoundaryEventPositionHelper.getPositionOnLine(x, y, eventGa.getWidth(), eventGa.getHeight(), activityLoc.getX(), activityLoc.getY(), activityGa.getWidth(), activityGa.getHeight());
        return pos.isLegalPosition();
    }

    public static ILocation getLocation(IMoveShapeContext context, Diagram diagram) {
        ILocation eventLoc = peService.getLocationRelativeToDiagram(context.getShape());
        Shape eventShape = context.getShape();
        BoundaryEvent event = BusinessObjectUtil.getFirstElementOfType((PictogramElement)eventShape, BoundaryEvent.class);
        PictogramElement pe = BusinessObjectUtil.getFirstBaseElementFromDiagram(diagram, (BaseElement)event.getAttachedToRef());
        if (pe instanceof ContainerShape) {
            ContainerShape activityShape = (ContainerShape)pe;
            ILocation activityLoc = peService.getLocationRelativeToDiagram((Shape)activityShape);
            IDimension eventSize = GraphicsUtil.calculateSize((PictogramElement)eventShape);
            IDimension activitySize = GraphicsUtil.calculateSize((PictogramElement)activityShape);
            eventLoc.setX(activityLoc.getX() + eventSize.getWidth());
            eventLoc.setY(activityLoc.getY() + activitySize.getHeight() - eventSize.getHeight() / 2);
        }
        return eventLoc;
    }

    public static PositionOnLine getPositionOnLineUsingBPMNShape(Shape eventShape, Shape activityShape) {
        BPMNShape event = BusinessObjectUtil.getFirstElementOfType((PictogramElement)eventShape, BPMNShape.class);
        Bounds eventBounds = event.getBounds();
        BPMNShape activity = BusinessObjectUtil.getFirstElementOfType((PictogramElement)activityShape, BPMNShape.class);
        Bounds activityBounds = activity.getBounds();
        return BoundaryEventPositionHelper.getPositionOnLine((int)eventBounds.getX(), (int)eventBounds.getY(), (int)eventBounds.getWidth(), (int)eventBounds.getHeight(), (int)activityBounds.getX(), (int)activityBounds.getY(), (int)activityBounds.getWidth(), (int)activityBounds.getHeight());
    }

    public static PositionOnLine getPositionOnLineUsingAbsoluteCoordinates(Shape eventShape, Shape activityShape) {
        GraphicsAlgorithm eventGa = eventShape.getGraphicsAlgorithm();
        ILocation eventLoc = peService.getLocationRelativeToDiagram(eventShape);
        GraphicsAlgorithm activityGa = activityShape.getGraphicsAlgorithm();
        ILocation activityLoc = peService.getLocationRelativeToDiagram(activityShape);
        return BoundaryEventPositionHelper.getPositionOnLine(eventLoc.getX(), eventLoc.getY(), eventGa.getWidth(), eventGa.getHeight(), activityLoc.getX(), activityLoc.getY(), activityGa.getWidth(), activityGa.getHeight());
    }

    public static PositionOnLine getPositionOnLine(int eventX, int eventY, int eventW, int eventH, int activityX, int activityY, int activityW, int activityH) {
        int x = eventX + eventW / 2;
        int y = eventY + eventH / 2;
        int x1 = activityX;
        int x2 = x1 + 10;
        int x3 = x1 + activityW - 10;
        int x4 = x1 + activityW + 10;
        int y1 = activityY;
        int y2 = y1 + 10;
        int y3 = y1 + activityH - 10;
        int y4 = y1 + activityH + 10;
        boolean alongLeftX = x >= x1 && x <= x2;
        boolean alongRightX = x >= x3 && x <= x4;
        boolean alongTopY = y >= y1 && y <= y2;
        boolean alongBottomY = y >= y3 && y <= y4;
        PositionOnLine pos = new PositionOnLine(alongLeftX, alongRightX, alongTopY, alongBottomY);
        return pos;
    }

    public static void assignPositionOnLineProperty(PropertyContainer propertyContainer, PositionOnLine pos) {
        FeatureSupport.setPropertyValue(propertyContainer, "boundary.event.relative.pos", pos.toString());
    }

    public static PositionOnLine getPositionOnLineProperty(PropertyContainer propertyContainer) {
        String value = FeatureSupport.getPropertyValue(propertyContainer, "boundary.event.relative.pos");
        return PositionOnLine.fromString(value);
    }

    public static class PositionOnLine {
        private LineType lineType;
        private LocationType locationType;

        public PositionOnLine(LineType lineType, LocationType locationType) {
            this.lineType = lineType;
            this.locationType = locationType;
        }

        public PositionOnLine(boolean alongLeftX, boolean alongRightX, boolean alongTopY, boolean alongBottomY) {
            boolean alongY;
            boolean alongX = alongLeftX || alongRightX;
            boolean bl = alongY = alongTopY || alongBottomY;
            this.lineType = alongX && alongY ? LineType.XY : (alongX ? LineType.X : (alongY ? LineType.Y : LineType.UNKNOWN));
            if (this.lineType != null) {
                switch (this.lineType) {
                    case XY: {
                        if (alongLeftX) {
                            if (alongTopY) {
                                this.locationType = LocationType.TOP_LEFT;
                                break;
                            }
                            this.locationType = LocationType.BOTTOM_LEFT;
                            break;
                        }
                        if (!alongRightX) break;
                        if (alongTopY) {
                            this.locationType = LocationType.TOP_RIGHT;
                            break;
                        }
                        this.locationType = LocationType.BOTTOM_RIGHT;
                        break;
                    }
                    case X: {
                        if (alongLeftX) {
                            this.locationType = LocationType.LEFT;
                            break;
                        }
                        this.locationType = LocationType.RIGHT;
                        break;
                    }
                    case Y: {
                        if (alongTopY) {
                            this.locationType = LocationType.TOP;
                            break;
                        }
                        this.locationType = LocationType.BOTTOM;
                        break;
                    }
                    default: {
                        this.locationType = LocationType.UNKNOWN;
                    }
                }
            }
            if (this.locationType == null) {
                this.locationType = LocationType.UNKNOWN;
            }
        }

        public LineType getLineType() {
            return this.lineType;
        }

        public LocationType getLocationType() {
            return this.locationType;
        }

        public boolean isLegalPosition() {
            return this.lineType != LineType.UNKNOWN && this.locationType != LocationType.UNKNOWN;
        }

        public static PositionOnLine fromString(String s) {
            if (s == null) {
                return null;
            }
            String[] arr = s.split(":");
            if (!arr[0].equals(PositionOnLine.class.getSimpleName().toLowerCase())) {
                return null;
            }
            return new PositionOnLine(LineType.valueOf(arr[1]), LocationType.valueOf(arr[2]));
        }

        public String toString() {
            String prefix = PositionOnLine.class.getSimpleName().toLowerCase();
            String lineType = this.lineType.toString();
            String locationType = this.locationType.toString();
            String colon = ":";
            return prefix + colon + lineType + colon + locationType;
        }

        public static enum LineType {
            X,
            Y,
            XY,
            UNKNOWN;

        }

        public static enum LocationType {
            TOP,
            TOP_LEFT,
            TOP_RIGHT,
            BOTTOM,
            BOTTOM_LEFT,
            BOTTOM_RIGHT,
            LEFT,
            RIGHT,
            UNKNOWN;

        }
    }
}

