/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public class EnvironmentReader {
    private static Properties envVars = null;
    private static Properties envVarsNormalized = null;
    private static ArrayList<String> rawVars = null;

    private static synchronized void init() {
        if (envVars == null) {
            envVars = new Properties();
            envVarsNormalized = Platform.getOS().equals("win32") ? new Properties() : envVars;
            rawVars = new ArrayList();
            Map<String, String> envMap = System.getenv();
            for (String var : envMap.keySet()) {
                String value = envMap.get(var);
                envVars.setProperty(var, value);
                if (envVarsNormalized != envVars) {
                    envVarsNormalized.setProperty(var.toUpperCase(), value);
                }
                rawVars.add(String.valueOf(var) + "=" + value);
            }
            rawVars.trimToSize();
        }
    }

    public static Properties getEnvVars() {
        EnvironmentReader.init();
        return (Properties)envVars.clone();
    }

    public static String getEnvVar(String key) {
        EnvironmentReader.init();
        return envVarsNormalized.getProperty(key);
    }

    @Deprecated
    public static String[] getRawEnvVars() {
        EnvironmentReader.init();
        return rawVars.toArray(new String[rawVars.size()]);
    }
}

