/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.ui;

import java.io.File;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.ui.Activator;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.cdt.debug.gdbjtag.ui.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class GDBJtagStartupTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = Messages.getString("GDBJtagStartupTab.tabName");
    private static final String TAB_ID = "org.eclipse.cdt.debug.gdbjtag.ui.startuptab";
    Text initCommands;
    Text delay;
    Button doReset;
    Button doHalt;
    Button loadImage;
    Text imageFileName;
    Button imageFileBrowseWs;
    Button imageFileBrowse;
    Text imageOffset;
    Button loadSymbols;
    Text symbolsFileName;
    Button symbolsFileBrowseWs;
    Button symbolsFileBrowse;
    Text symbolsOffset;
    Button setPcRegister;
    Text pcRegister;
    Button setStopAt;
    Text stopAt;
    Button setResume;
    boolean resume = false;
    Text runCommands;
    private Button useProjectBinaryForImage;
    private Button useFileForImage;
    private Button useProjectBinaryForSymbols;
    private Button useFileForSymbols;
    private Label imageOffsetLabel;
    private Label symbolsOffsetLabel;
    private Label projBinaryLabel1;
    private Label projBinaryLabel2;

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getStartupTabImage();
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createInitGroup(comp);
        this.createLoadGroup(comp);
        this.createRunOptionGroup(comp);
        this.createRunGroup(comp);
        sc.setMinSize(comp.computeSize(-1, -1));
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void browseWsButtonSelected(String title, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(Messages.getString("GDBJtagStartupTab.FileBrowseWs_Message"));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toOSString();
            String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
            text.setText(fileLoc);
        }
    }

    public void createInitGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagStartupTab.initGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        this.doReset = new Button(comp, 32);
        this.doReset.setText(Messages.getString("GDBJtagStartupTab.doReset_Text"));
        this.doReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.doResetChanged();
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.delay = new Text(comp, 2048);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 60;
        this.delay.setLayoutData((Object)gd);
        this.delay.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.delay.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
        comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        this.doHalt = new Button(comp, 32);
        this.doHalt.setText(Messages.getString("GDBJtagStartupTab.doHalt_Text"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.doHalt.setLayoutData((Object)gd);
        this.doHalt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.initCommands = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = 60;
        this.initCommands.setLayoutData((Object)gd);
        this.initCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createLoadGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 4;
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagStartupTab.loadGroup_Text"));
        this.loadImage = new Button((Composite)group, 32);
        this.loadImage.setText(Messages.getString("GDBJtagStartupTab.loadImage_Text"));
        gd = new GridData();
        gd.horizontalSpan = 4;
        this.loadImage.setLayoutData((Object)gd);
        this.loadImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.loadImageChanged();
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)layout);
        SelectionListener radioButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
                GDBJtagStartupTab.this.updateUseFileEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.useProjectBinaryForImage = new Button(comp, 16);
        this.useProjectBinaryForImage.setText(Messages.getString("GDBJtagStartupTab.useProjectBinary_Label"));
        this.useProjectBinaryForImage.setToolTipText(Messages.getString("GDBJtagStartupTab.useProjectBinary_ToolTip"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.useProjectBinaryForImage.setLayoutData((Object)gd);
        this.useProjectBinaryForImage.addSelectionListener(radioButtonListener);
        this.projBinaryLabel1 = new Label(comp, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.projBinaryLabel1.setLayoutData((Object)gd);
        this.useFileForImage = new Button(comp, 16);
        this.useFileForImage.setText(Messages.getString("GDBJtagStartupTab.useFile_Label"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.useFileForImage.setLayoutData((Object)gd);
        this.useFileForImage.addSelectionListener(radioButtonListener);
        this.imageFileName = new Text(comp, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.imageFileName.setLayoutData((Object)gd);
        this.imageFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
        this.imageFileBrowseWs = this.createPushButton(comp, Messages.getString("GDBJtagStartupTab.FileBrowseWs_Label"), null);
        this.imageFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.browseWsButtonSelected(Messages.getString("GDBJtagStartupTab.imageFileBrowseWs_Title"), GDBJtagStartupTab.this.imageFileName);
            }
        });
        this.imageFileBrowse = this.createPushButton(comp, Messages.getString("GDBJtagStartupTab.FileBrowse_Label"), null);
        this.imageFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.browseButtonSelected(Messages.getString("GDBJtagStartupTab.imageFileBrowse_Title"), GDBJtagStartupTab.this.imageFileName);
            }
        });
        this.imageOffsetLabel = new Label(comp, 0);
        this.imageOffsetLabel.setText(Messages.getString("GDBJtagStartupTab.imageOffsetLabel_Text"));
        this.imageOffset = new Text(comp, 2048);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 100;
        this.imageOffset.setLayoutData((Object)gd);
        this.imageOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.imageOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
        this.loadSymbols = new Button((Composite)group, 32);
        this.loadSymbols.setText(Messages.getString("GDBJtagStartupTab.loadSymbols_Text"));
        gd = new GridData();
        gd.horizontalSpan = 4;
        this.loadSymbols.setLayoutData((Object)gd);
        this.loadSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.loadSymbolsChanged();
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)layout);
        this.useProjectBinaryForSymbols = new Button(comp, 16);
        this.useProjectBinaryForSymbols.setText(Messages.getString("GDBJtagStartupTab.useProjectBinary_Label"));
        this.useProjectBinaryForSymbols.setToolTipText(Messages.getString("GDBJtagStartupTab.useProjectBinary_ToolTip"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.useProjectBinaryForSymbols.setLayoutData((Object)gd);
        this.useProjectBinaryForSymbols.addSelectionListener(radioButtonListener);
        this.projBinaryLabel2 = new Label(comp, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.projBinaryLabel2.setLayoutData((Object)gd);
        this.useFileForSymbols = new Button(comp, 16);
        this.useFileForSymbols.setText(Messages.getString("GDBJtagStartupTab.useFile_Label"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.useFileForSymbols.setLayoutData((Object)gd);
        this.useFileForSymbols.addSelectionListener(radioButtonListener);
        this.symbolsFileName = new Text(comp, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.symbolsFileName.setLayoutData((Object)gd);
        this.symbolsFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
        this.symbolsFileBrowseWs = this.createPushButton(comp, Messages.getString("GDBJtagStartupTab.FileBrowseWs_Label"), null);
        this.symbolsFileBrowseWs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.browseWsButtonSelected(Messages.getString("GDBJtagStartupTab.symbolsFileBrowseWs_Title"), GDBJtagStartupTab.this.symbolsFileName);
            }
        });
        this.symbolsFileBrowse = this.createPushButton(comp, Messages.getString("GDBJtagStartupTab.FileBrowse_Label"), null);
        this.symbolsFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.browseButtonSelected(Messages.getString("GDBJtagStartupTab.symbolsFileBrowse_Title"), GDBJtagStartupTab.this.symbolsFileName);
            }
        });
        this.symbolsOffsetLabel = new Label(comp, 0);
        this.symbolsOffsetLabel.setText(Messages.getString("GDBJtagStartupTab.symbolsOffsetLabel_Text"));
        this.symbolsOffset = new Text(comp, 2048);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 100;
        this.symbolsOffset.setLayoutData((Object)gd);
        this.symbolsOffset.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.symbolsOffset.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
    }

    private void updateUseFileEnablement() {
        boolean enabled = this.loadImage.getSelection() && this.useFileForImage.getSelection();
        this.imageFileName.setEnabled(enabled);
        this.imageFileBrowseWs.setEnabled(enabled);
        this.imageFileBrowse.setEnabled(enabled);
        enabled = this.loadSymbols.getSelection() && this.useFileForSymbols.getSelection();
        this.symbolsFileName.setEnabled(enabled);
        this.symbolsFileBrowseWs.setEnabled(enabled);
        this.symbolsFileBrowse.setEnabled(enabled);
    }

    @Deprecated
    public void createRunOptionGroup(Composite parent) {
    }

    public void createRunGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 2;
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagStartupTab.runGroup_Text"));
        this.setPcRegister = new Button((Composite)group, 32);
        this.setPcRegister.setText(Messages.getString("GDBJtagStartupTab.setPcRegister_Text"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.setPcRegister.setLayoutData((Object)gd);
        this.setPcRegister.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.pcRegisterChanged();
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.pcRegister = new Text((Composite)group, 2048);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 100;
        this.pcRegister.setLayoutData((Object)gd);
        this.pcRegister.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character) || "abcdef".contains(String.valueOf(e.character).toLowerCase());
            }
        });
        this.pcRegister.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
        this.setStopAt = new Button((Composite)group, 32);
        this.setStopAt.setText(Messages.getString("GDBJtagStartupTab.setStopAt_Text"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.setStopAt.setLayoutData((Object)gd);
        this.setStopAt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.stopAtChanged();
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.stopAt = new Text((Composite)group, 2048);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 100;
        this.stopAt.setLayoutData((Object)gd);
        this.stopAt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
        this.runCommands = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 60;
        this.runCommands.setLayoutData((Object)gd);
        this.runCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBJtagStartupTab.this.scheduleUpdateJob();
            }
        });
        this.setResume = new Button((Composite)group, 32);
        this.setResume.setText(Messages.getString("GDBJtagStartupTab.setResume_Text"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.setResume.setLayoutData((Object)gd);
        this.setResume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.resumeChanged();
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void doResetChanged() {
        this.delay.setEnabled(this.doReset.getSelection());
    }

    private void loadImageChanged() {
        boolean enabled = this.loadImage.getSelection();
        this.useProjectBinaryForImage.setEnabled(enabled);
        this.useFileForImage.setEnabled(enabled);
        this.imageOffset.setEnabled(enabled);
        this.imageOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void loadSymbolsChanged() {
        boolean enabled = this.loadSymbols.getSelection();
        this.useProjectBinaryForSymbols.setEnabled(enabled);
        this.useFileForSymbols.setEnabled(enabled);
        this.symbolsOffset.setEnabled(enabled);
        this.symbolsOffsetLabel.setEnabled(enabled);
        this.updateUseFileEnablement();
    }

    private void pcRegisterChanged() {
        this.pcRegister.setEnabled(this.setPcRegister.getSelection());
    }

    private void stopAtChanged() {
        this.stopAt.setEnabled(this.setStopAt.getSelection());
    }

    private void resumeChanged() {
        this.resume = this.setResume.getSelection();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        Path filePath;
        String path;
        if (!super.isValid(launchConfig)) {
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.loadImage.getSelection()) {
            if (!this.useProjectBinaryForImage.getSelection()) {
                if (this.imageFileName.getText().trim().length() == 0) {
                    this.setErrorMessage(Messages.getString("GDBJtagStartupTab.imageFileName_not_specified"));
                    return false;
                }
                try {
                    path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.imageFileName.getText().trim());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("GDBJtagStartupTab.imageFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException e) {
                    this.setErrorMessage(Messages.getString("GDBJtagStartupTab.imageFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.loadSymbols.getSelection()) {
            if (!this.useProjectBinaryForSymbols.getSelection()) {
                if (this.symbolsFileName.getText().trim().length() == 0) {
                    this.setErrorMessage(Messages.getString("GDBJtagStartupTab.symbolsFileName_not_specified"));
                    return false;
                }
                try {
                    path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.symbolsFileName.getText().trim());
                    filePath = new Path(path);
                    if (!filePath.toFile().exists()) {
                        this.setErrorMessage(Messages.getString("GDBJtagStartupTab.symbolsFileName_does_not_exist"));
                        return false;
                    }
                }
                catch (CoreException e) {
                    this.setErrorMessage(Messages.getString("GDBJtagStartupTab.symbolsFileName_does_not_exist"));
                    return false;
                }
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.setPcRegister.getSelection()) {
            if (this.pcRegister.getText().trim().length() == 0) {
                this.setErrorMessage(Messages.getString("GDBJtagStartupTab.pcRegister_not_specified"));
                return false;
            }
        } else {
            this.setErrorMessage(null);
        }
        if (this.setStopAt.getSelection()) {
            if (this.stopAt.getText().trim().length() == 0) {
                this.setErrorMessage(Messages.getString("GDBJtagStartupTab.stopAt_not_specified"));
            }
        } else {
            this.setErrorMessage(null);
        }
        return true;
    }

    public String getId() {
        return TAB_ID;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.doReset.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.doReset", false));
            this.delay.setText(String.valueOf(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.delay", 3)));
            this.doHalt.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.doHalt", false));
            this.initCommands.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.initCommands", ""));
            this.loadImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true));
            this.useProjectBinaryForImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true));
            this.useFileForImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", false));
            this.imageFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", ""));
            this.imageOffset.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", ""));
            this.loadSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true));
            this.useProjectBinaryForSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true));
            this.useFileForSymbols.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false));
            this.symbolsFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", ""));
            this.symbolsOffset.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", ""));
            this.setPcRegister.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false));
            this.pcRegister.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", ""));
            this.setStopAt.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", false));
            this.stopAt.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", ""));
            this.setResume.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false));
            this.runCommands.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.runCommands", ""));
            String programName = CDebugUtils.getProgramName((ILaunchConfiguration)configuration);
            if (programName != null) {
                int lastSlash = programName.indexOf(92);
                if (lastSlash >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                if ((lastSlash = programName.indexOf(47)) >= 0) {
                    programName = programName.substring(lastSlash + 1);
                }
                this.projBinaryLabel1.setText(programName);
                this.projBinaryLabel2.setText(programName);
            }
            this.doResetChanged();
            this.loadImageChanged();
            this.loadSymbolsChanged();
            this.pcRegisterChanged();
            this.stopAtChanged();
            this.resumeChanged();
            this.updateUseFileEnablement();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.doReset", this.doReset.getSelection());
        try {
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.delay", Integer.parseInt(this.delay.getText()));
        }
        catch (NumberFormatException e) {
            Activator.log(e);
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.doHalt", this.doHalt.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.initCommands", this.initCommands.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", this.loadImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", this.useProjectBinaryForImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", this.useFileForImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", this.imageFileName.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", this.imageOffset.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", this.loadSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", this.useProjectBinaryForSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", this.useFileForSymbols.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", this.symbolsFileName.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", this.symbolsOffset.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", this.setPcRegister.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", this.pcRegister.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", this.setStopAt.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", this.stopAt.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", this.setResume.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.runCommands", this.runCommands.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.doReset", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.delay", 3);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.doHalt", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.initCommands", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadImage", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForImage", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.imageOffset", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useFileForSymbols", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.pcRegister", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setStopAt", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.stopAt", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.setResume", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.runCommands", "");
    }
}

